/*
 * pftp -- sends files from host to host through free choosable ports
 *
 * Copyright (C) 1996-2000 Ben Schluricke
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the emplied warranty of MERCHANT-
 * ABILITY OF FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 * Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *    Written by Ben Schluricke
 *    E-Mail:    support@pftp.de
 *
 * This program is dedicated to my girl-friend, Heather O'Rourke.
 *
 *
 */
#ifdef USE_POSIX_THREAD
#define _REENTRANT
#include <pthread.h>
#endif
#include "main.h"

extern void shost(int *, int);
extern off_t offset[SONAME];  /* hold all offsets of the beginning of files */


int printlist(char **accepted_hosts, char *chost, int strnum)
{
   char clienthost[SONAME];
#ifdef HAVE_INET6
   char ipstr[SONAME];
#else
   struct hostent *hp;
   struct in_addr ia;
#endif
   short _ISNUM_=1;
   char *tmphost=NULL;
   int j, count;

   for (count=1; *accepted_hosts; accepted_hosts++, count++);
   for (; *chost;  count++) {
      for (; *chost && (*chost == ' ' || *chost == '\t' || *chost == '*'); chost++);
      if (!*chost) return 1;
      for (j=0,_ISNUM_=1,tmphost=chost; *tmphost \
          && *tmphost != ' ' && *tmphost != '\t'; tmphost++) {
         if (!isdigit(*tmphost)) _ISNUM_=0;
      }
      if (!*tmphost) j=1; /* eol */
      else *tmphost = '\0';
      strcpy(clienthost, chost);
      tmphost++;
      if (j || !*tmphost) *chost = '\0';
      else chost = tmphost;
      if (!_ISNUM_) tmphost = clienthost;
      else {
         int dummy=0;
         j = (*(statstr+strnum))->host_number;
         (*(statstr+strnum))->host_number = atoi(clienthost);
         shost(&dummy, strnum);
         (*(statstr+strnum))->host_number = j;
         tmphost = (*(statstr+strnum))->_HOSTNAME_;
      }
      if (*tmphost != '.' && *tmphost != PFTP_SPECIAL_SIGN) {
#ifdef HAVE_INET6
         int ret=0;
         char tmpstr[SONAME];
         struct addrinfo adin, *adres;
         struct sockaddr_in6 sin6;
         struct sockaddr_in sin;
         sin6.sin6_family = AF_INET6;
         sin6.sin6_port = 0;
         sin6.sin6_addr = in6addr_any;
         memset((char *)&adin, 0, sizeof(adin));
         adin.ai_socktype = (*statstr)->use_udp ? SOCK_DGRAM: SOCK_STREAM; /* SOCK_DGRAM for later implementation */
         adin.ai_addr = (struct sockaddr *)&sin6;
         if ((ret = getaddrinfo(tmphost, "0", &adin, &adres)) < 0) {
            if (slfp) fprintf(slfp, "getaddrinfo: %s: %s\n", tmphost, gai_strerror(ret));
            return 0;
         }
         memcpy(adres->ai_family == AF_INET6 ? (char *)&sin6:(char *)&sin, adres->ai_addr, adres->ai_addrlen);
         if (!inet_ntop(adres->ai_family, adres->ai_family == AF_INET6 ? \
            (char *)sin6.sin6_addr.s6_addr:(char *)&sin.sin_addr.s_addr, tmpstr, INET6_ADDRSTRLEN)) {
            if (slfp) fprintf(slfp, "inet_ntop: %s: %s\n", tmphost, gai_strerror(ret));
            return 0;
         }
         sprintf(ipstr, "%s%s", adres->ai_family == AF_INET6 ? "":"::ffff:", tmpstr);
#else
         unsigned long inum=inet_addr(tmphost);
         if ((hp = (struct hostent *)gethostbyname(tmphost)));
         else if (!(hp = gethostbyaddr((char *)&inum, sizeof(inum), AF_INET))) {
            if (slfp) fprintf(slfp, "** %s: unknown host.\n", tmphost);
            return 0;
         }
         memcpy(&ia, hp->h_addr_list[0], hp->h_length);
#endif
         MEM_CHECK((*accepted_hosts = (char *)calloc(SONAME, sizeof(char))));
#ifdef HAVE_INET6
         for (j=0; *(ipstr+j); j++) *(*accepted_hosts+j) = tolower(*(ipstr+j));
         *(*accepted_hosts+j) = '\0';
#else
         strcpy(*accepted_hosts, inet_ntoa(ia));
#endif
         if (isatty(2) && slfp) fprintf(slfp, "   %d) %s (%s)\n", count, tmphost, *accepted_hosts);
      }
      else if (*tmphost == PFTP_SPECIAL_SIGN) {
#ifdef HAVE_INET6
         if (inet_pton(AF_INET6, tmphost+1, ipstr) <= 0)
#else
#if !defined Linux
#ifdef IRIX64
         if (inet_addr(tmphost+1) == INADDR_NONE)
#else
         if (inet_addr(tmphost+1) < 0)
#endif
#else
         if (!inet_aton(tmphost+1, &ia))
#endif
#endif
         {
            if (slfp) fprintf(slfp, "** %s: invalid address.\n", tmphost+1);
            return 0;
         }
         MEM_CHECK((*accepted_hosts = (char *)calloc(SONAME, sizeof(char))));
         strcpy(*accepted_hosts, tmphost);
         if (isatty(2) && slfp) fprintf(slfp, "   %d) hosts from net %s\n", count, tmphost+1);
      }
      else {
         if (isatty(2) && slfp) fprintf(slfp, "   %d) hosts from domain %s\n", count, tmphost+1);
         MEM_CHECK((*accepted_hosts = (char *)calloc(SONAME, sizeof(char))));
         for (j=0; *(tmphost+j); j++) *((*accepted_hosts)+j) = tolower(*(tmphost+j));
      }
      *(++accepted_hosts) = NULL;
   }
   return 1;
}

int getoffset(char *z)
{
   char *tmpz=z;
   off_t *t=offset;

   for (*t=(off_t)0; *z; z++) {
      if (isdigit(*z)) *t = (*t * (off_t)10) + (off_t) (*z - '0');
      else if (*z == 'a' && isdigit(*(z+1))) {
         t++;
         *t = 0L;
      }
      else break;
   }
   t++;
   *t = -1;

   return (int) ((z - tmpz) - 1);
}

int extract_val_d(double *num_to_set, char *str, int i)
{
      int j=0;

      for (j=i+1,*num_to_set=0; isdigit(*(str+j)); j++) {
         if (*num_to_set) *num_to_set *= (double)10;
         *num_to_set += (double)*(str+j) - '0';
      }
      return j - 1;
}

int extract_val_i(unsigned int *num_to_set, char *str, int i)
{
      int j=0;

      for (j=i+1,*num_to_set=0; isdigit(*(str+j)); j++) {
         if (*num_to_set) *num_to_set *= (unsigned int)10;
         *num_to_set += (unsigned int)*(str+j) - '0';
      }
      return j - 1;
}

int extract_val_li(unsigned long *num_to_set, char *str, int i)
{
      int j=0;

      for (j=i+1,*num_to_set=0; isdigit(*(str+j)); j++) {
         if (*num_to_set) *num_to_set *= (unsigned long)10;
         *num_to_set += (unsigned long)*(str+j) - '0';
      }
      return j - 1;
}
