#ifdef PETSC_RCS_HEADER
static char vcid[] = "$Id: dlregis.c,v 1.1 2000/01/10 03:54:20 knepley Exp $";
#endif

#include "gvec.h"

#undef __FUNCT__  
#define __FUNCT__ "GridInitializePackage"
/*@C
  GridInitializePackage - This function initializes everything in the Grid package. It is called
  from PetscDLLibraryRegister() when using dynamic libraries, and on the first call to GridCreate()
  when using static libraries.

  Input Parameter:
  path - The dynamic library path, or PETSC_NULL

  Level: developer

.keywords: Grid, initialize, package
.seealso: PetscInitialize()
@*/
int GridInitializePackage(char *path) {
  static PetscTruth initialized = PETSC_FALSE;
  char              logList[256];
  char             *className;
  PetscTruth        opt;
  int               ierr;

  PetscFunctionBegin;
  if (initialized == PETSC_TRUE) PetscFunctionReturn(0);
  initialized = PETSC_TRUE;
  /* Register Classes */
  ierr = PetscLogClassRegister(&DISCRETIZATION_COOKIE, "Discretization");                                 CHKERRQ(ierr);
  ierr = PetscLogClassRegister(&GRID_COOKIE,           "Grid");                                           CHKERRQ(ierr);
  ierr = PetscLogClassRegister(&ELEMENT_VEC_COOKIE,    "Element Vector");                                 CHKERRQ(ierr);
  ierr = PetscLogClassRegister(&ELEMENT_MAT_COOKIE,    "Element Matrix");                                 CHKERRQ(ierr);
  ierr = PetscLogClassRegister(&VAR_ORDER_COOKIE,      "VariableOrdering");                               CHKERRQ(ierr);
  ierr = PetscLogClassRegister(&CLASS_MAP_COOKIE,      "Field Class Map");                                CHKERRQ(ierr);
  /* Register Constructors and Serializers */
  ierr = GridRegisterAll(path);                                                                           CHKERRQ(ierr);
  ierr = GridSerializeRegisterAll(path);                                                                  CHKERRQ(ierr);
  ierr = FieldClassMapRegisterAll(path);                                                                  CHKERRQ(ierr);
  ierr = FieldClassMapSerializeRegisterAll(path);                                                         CHKERRQ(ierr);
  ierr = DiscretizationRegisterAll(path);                                                                 CHKERRQ(ierr);
  ierr = DiscretizationSerializeRegisterAll(path);                                                        CHKERRQ(ierr);
  /* Register Events */
  ierr = PetscLogEventRegister(&GRID_Reform,                        "GridReform",       GRID_COOKIE);     CHKERRQ(ierr);
  ierr = PetscLogEventRegister(&GRID_SetUp,                         "GridSetUp",        GRID_COOKIE);     CHKERRQ(ierr);
  ierr = PetscLogEventRegister(&GVEC_EvaluateFunction,              "GVecEvalFunc",     VEC_COOKIE);      CHKERRQ(ierr);
  ierr = PetscLogEventRegister(&GVEC_EvaluateFunctionCollective,    "GVecEvalFuncColl", VEC_COOKIE);      CHKERRQ(ierr);
  ierr = PetscLogEventRegister(&GVEC_EvaluateRhs,                   "GVecEvaluateRhs",  VEC_COOKIE);      CHKERRQ(ierr);
  ierr = PetscLogEventRegister(&GVEC_EvaluateJacobian,              "GVecEvaluateJac",  VEC_COOKIE);      CHKERRQ(ierr);
  ierr = PetscLogEventRegister(&GVEC_SetBoundary,                   "GVecSetBoundary",  VEC_COOKIE);      CHKERRQ(ierr);
  ierr = PetscLogEventRegister(&GVEC_InterpolateField,              "GVecInterpolate",  VEC_COOKIE);      CHKERRQ(ierr);
  ierr = PetscLogEventRegister(&GVEC_InterpolateFieldBatch,         "GVecInterpBatch",  VEC_COOKIE);      CHKERRQ(ierr);
  ierr = PetscLogEventRegister(&GVEC_InterpolateFieldBatchParallel, "GVecInterpBatchP", VEC_COOKIE);      CHKERRQ(ierr);
  ierr = PetscLogEventRegister(&GVEC_InterpolateFieldBatchCalc,     "GVecInterpBatchC", VEC_COOKIE);      CHKERRQ(ierr);
  ierr = PetscLogEventRegister(&GMAT_CreateRectangular,             "GMatCreateRect",   MAT_COOKIE);      CHKERRQ(ierr);
  ierr = PetscLogEventRegister(&GMAT_EvaluateOperatorGalerkin,      "GMatEvalOpGaler",  MAT_COOKIE);      CHKERRQ(ierr);
  ierr = PetscLogEventRegister(&GMAT_EvaluateSystemMatrix,          "GMatEvalSysMat",   MAT_COOKIE);      CHKERRQ(ierr);
  ierr = PetscLogEventRegister(&GMAT_SetBoundary,                   "GMatSetBoundary",  MAT_COOKIE);      CHKERRQ(ierr);
  ierr = PetscLogEventRegister(&GMAT_MatMultConstrained,            "GMatMultConstr",   MAT_COOKIE);      CHKERRQ(ierr);
  ierr = PetscLogEventRegister(&GMAT_MatMultTransposeConstrained,   "GMatMultTRConstr", MAT_COOKIE);      CHKERRQ(ierr);
  /* Process info exclusions */
  ierr = PetscOptionsGetString(PETSC_NULL, "-log_info_exclude", logList, 256, &opt);                      CHKERRQ(ierr);
  if (opt == PETSC_TRUE) {
    ierr = PetscStrstr(logList, "grid", &className);                                                      CHKERRQ(ierr);
    if (className) {
      ierr = PetscLogInfoDeactivateClass(GRID_COOKIE);                                                    CHKERRQ(ierr);
    }
  }
  /* Process summary exclusions */
  ierr = PetscOptionsGetString(PETSC_NULL, "-log_summary_exclude", logList, 256, &opt);                   CHKERRQ(ierr);
  if (opt == PETSC_TRUE) {
    ierr = PetscStrstr(logList, "grid", &className);                                                      CHKERRQ(ierr);
    if (className) {
      ierr = PetscLogEventDeactivateClass(GRID_COOKIE);                                                   CHKERRQ(ierr);
    }
  }
  PetscFunctionReturn(0);
}

#ifdef PETSC_USE_DYNAMIC_LIBRARIES
EXTERN_C_BEGIN
#undef __FUNCT__  
#define __FUNCT__ "PetscDLLibraryRegister"
/*
  PetscDLLibraryRegister - This function is called when the dynamic library it is in is opened.

  This one registers all the grid vectors and matrices that are in the basic Grid library.

  Input Parameter:
  path - library path
*/
int PetscDLLibraryRegister(char *path) {
  int ierr;

  ierr = PetscInitializeNoArguments();
  if (ierr) return(1);
  /*
      If we got here then PETSc was properly loaded
  */
  ierr = GridInitializePackage(path);                                                                     CHKERRQ(ierr);
  return(0);
}
EXTERN_C_END

/* --------------------------------------------------------------------------*/
static char *contents = "PETSc Grid library\n";

static char *authors = "Matt Knepley    knepley@cs.purdue.edu\n\
  http://www.cs.purdue.edu/homes/knepley/comp_fluid\n";

#include "src/sys/src/utils/dlregis.h"

/* --------------------------------------------------------------------------*/

#endif /* PETSC_USE_DYNAMIC_LIBRARIES */

