#ifdef PETSC_RCS_HEADER
static char vcid[] = "$Id: aoregall.c,v 1.2 1999/06/10 22:35:08 knepley Exp $";
#endif

#include "src/dm/ao/aoimpl.h"     /*I  "petscao.h"  I*/
EXTERN_C_BEGIN
extern int AOSerialize_Basic(MPI_Comm, AO *, PetscViewer, PetscTruth);
extern int AOSerialize_Mapping(MPI_Comm, AO *, PetscViewer, PetscTruth);
EXTERN_C_END

#undef __FUNCT__  
#define __FUNCT__ "AOSerializeRegisterAll"
/*@C
  AOSerializeRegisterAll - Registers all of the serialization routines in the AO package. 

  Not Collective

  Level: advanced

.keywords: AO, application ordering, register, all, serialize

.seealso: AOSerializeRegister(), AOSerializeRegisterDestroy()
@*/
int AOSerializeRegisterAll(const char *path)
{
  int ierr;

  PetscFunctionBegin;
  AOSerializeRegisterAllCalled = 1;

  ierr = AOSerializeRegister(AO_SER_BASIC_BINARY,   path, "AOSerialize_Basic",   AOSerialize_Basic);      CHKERRQ(ierr);
  ierr = AOSerializeRegister(AO_SER_MAPPING_BINARY, path, "AOSerialize_Mapping", AOSerialize_Mapping);    CHKERRQ(ierr);
  PetscFunctionReturn(0);
}
