#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "npfile.h"
#include "npstringarray.h"
#include "npsubscription.h"

NP_Subscription::group_list_t *
NP_Subscription::get_group_entry( const char *server )
{
   group_list_t *pointer = group_list;

   int i;
   for( i = 0; i < total; ++i )
   {
      if ( !strcmp( server, pointer->server ))
         break;

      ++pointer;
   }

   if ( i == total )
   {
      snprintf( error_message, sizeof error_message,
                "NP_Subscription: get_group_entry(): no such"
                "server has been added to this object.", server );
      return NULL;
   }

   return pointer;
}

int NP_Subscription::remove_group( int s, int group_idx )
{
   const char *server;
   if (( server = server_names[ s ] ) == NULL )
   {
      server_names.print_error();
      return 1;
   }
   
   group_list_t *pointer;
   if (( pointer = get_group_entry( server )) == NULL )
      return 1;

   if ( pointer->group_names->remove_item( group_idx ))
   {
      pointer->group_names->print_error();
      return 1;
   }

   if ( pointer->article_nos->remove_item( group_idx ))
   {
      pointer->article_nos->print_error();
      return 1;
   }
   
   return 0;
}

int NP_Subscription::remove_group( int s, const char *group )
{
   if ( group == NULL )
   {
      strcpy( error_message, 
              "NP_Subscription: remove_group(): NULL group name passed "
              "as argument." );
      return 1;
   }

   const char *server;
   if (( server = server_names[ s ] ) == NULL )
   {
      server_names.print_error();
      return 1;
   }
   
   group_list_t *pointer;
   if (( pointer = get_group_entry( server )) == NULL )
      return 1;

   if ( pointer->group_names->remove_item( group ))
   {
      pointer->group_names->print_error();
      return 1;
   }

   if ( pointer->article_nos->remove_item( group ))
   {
      pointer->article_nos->print_error();
      return 1;
   }
   
   return 0;
}

int NP_Subscription::remove_group( const char *server, const char *group )
{
   if ( server == NULL )
   {
      strcpy( error_message, "NP_Subscription: remove_group(): "
              "NULL server name passed as argument." );
      return 1;
   }

   if ( group == NULL )
   {
      strcpy( error_message, "NP_Subscription: remove_group(): "
              "NULL group name passed as argument." );
      return 1;
   }
   
   group_list_t *pointer;
   if (( pointer = get_group_entry( server )) == NULL )
      return 1;

   if ( pointer->group_names->remove_item( group ))
   {
      pointer->group_names->print_error();
      return 1;
   }

   if ( pointer->article_nos->remove_item( group ))
   {
      pointer->article_nos->print_error();
      return 1;
   }
   
   return 0;
}

int NP_Subscription::remove_group( const char *server, int g )
{
   if ( server == NULL )
   {
      strcpy( error_message, "NP_Subscription: remove_group():"
              " NULL server name passed as argument." );
      return 1;
   }

   group_list_t *pointer;
   if (( pointer = get_group_entry( server )) == NULL )
      return 1;

   if ( pointer->group_names->remove_item( g ))
   {
      pointer->group_names->print_error();
      return 1;
   }

   if ( pointer->article_nos->remove_item( g ))
   {
      pointer->group_names->print_error();
      return 1;
   }
   
   return 0;
}

