#include <stdlib.h>
#include <stdio.h>

#include "npfile.h"
#include "npstringarray.h"
#include "npsubscription.h"

const char *NP_Subscription::get_group( int i, int j )
{
   if ( i < 0 || i >= total )
   {
      snprintf( error_message, sizeof error_message, "NP_Subscription: "
                "get_total_groups(): server index %d out of range.", i );
      return NULL;
   }

   int groups = get_total_groups( i );
   if ( groups <= 0 )
   {
      snprintf( error_message, sizeof error_message, "NP_Subscription: "
                "get_group(): %s", group_list[ i ].group_names->get_error() );
      return NULL;
   }

   NP_Stringarray &group_array = *group_list[ i ].group_names;
   const char *result = group_array[ j ];

   if ( result == NULL )
   {
      snprintf( error_message, sizeof error_message, "NP_Subscription: "
                "get_group(): %s",
                group_list[ i ].group_names->get_error() );
      return NULL;
   }

   return result;
}

