#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <unistd.h>
#include <signal.h>
#include <ctype.h>

#include <X11/Xlib.h>
#include <gdk/gdkx.h>
#include <gtk/gtk.h>

#include "npfile.h"
#include "npstringarray.h"
#include "npgroup.h"
#include "npnode.h"
#include "nptree.h"
#include "npcollections.h"

void launcher_button_callback( GtkWidget *widget, gpointer data )
{
   NP_Collections *collections = ( NP_Collections *)data;

   if ( collections->launcher_pid )
   {
      kill( collections->launcher_pid, SIGUSR1 ); 
      return;
   }

   switch( collections->launcher_pid = fork() )
   {
      case -1:
         perror( "fork" );
         break;

      case 0:
         close( ConnectionNumber( gdk_display ));
         execlp( "nplauncher", "nplauncher", NULL );
         perror( "execlp" );
         exit( 1 );
         break;

      default:
         char buffer[ 1024 ];
         snprintf( buffer, sizeof buffer, "%d", collections->launcher_pid );
         if ( collections->children.add_item( buffer ))
            collections->children.print_error();
         break;
   }

   return;
}
