#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>

#include "npfile.h"

int NP_File::openrw( const char *fn )
{
   if ( is_open )
   {
      snprintf( error_message, sizeof error_message,
                "NP_File: openrw():" 
                " File %s is still open for this object", filename );
      printf( error_message );
      return 1;
   }

   if ( lock( 1 ))
   {
      close();
      return 2;
   }

   if (( stream = fopen( fn, "r+" )) == NULL )
   {
      if ( errno == ENOENT )
      {
         snprintf( error_message, sizeof error_message,
                   "NP_File: openr(): File %s does not exist", filename );
         return 2;
      }
      else
         snprintf( error_message, sizeof error_message,
                   "NP_File: openr(): fopen() returned error: %s",
                   strerror( errno ));
      return 1;
   }

   if (( filename = strdup( fn )) == NULL )
   {
      perror( "strdup" );
      exit( 1 );
   }

   is_writable = 1;
   is_readable = 1;
   is_open = 1;

   return 0;
}
