/*
 * pencam.h - a quick and dirty picture dumper for my pencam.
 * 	    (C) Copyright 2001 by Bart Hartgers
 *
 *  Modified by and added to by Kevin Sisson <kjsisson@bellsouth.net>
 *  Aug - Nov, 2001
 *  
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

typedef struct
{
  int    black;
  int    white;
  int    amount;
} BrightnessParams;


/* This is taken from the stv680 webcam driver, removing some items that 
   are not necessary or useful here */
typedef struct   
{
	unsigned char 	      bulk_in_endpointAddr; // __u8  the address of the bulk in endpoint 
	char                  *camera_name;

	int                   SupportedModes; 
	int                   CIF;           /* 356x288 */
	int                   VGA;           /* 640x480 */
	int                   QVGA;          /* 320x240 */
	int                   QCIF;          /* 176x144 */
	int                   cwidth;	     /* camera width */
	int                   cheight;	     /* camera height */
	int                   maxwidth;      /* max video width */
	int                   maxheight;     /* max video height */
	int                   vwidth;        /* current width for video window */
	int                   vheight;       /* current height for video window */
	unsigned long int     rawbufsize;
	unsigned long int     maxframesize;  /* rawbufsize * 3 for RGB */
	int                   num_pics;
	int                   pic_no;        /* current picture number */
        int                   light_type;
	int                   FineExp;
	int                   CoarseExp;
	int                   AvgPixVal;     /* average pixel value for image */
	int                   origGain;
	int                   origMode;      /* original camera mode */
	int                   CLKDIV;
	float                 FW;            /* Firmware revision */
	float                 ASICrev;       /* asic revision */
	int                   SensorID;
	int                   SensorIDrev;
	     	
	float                 brightness; 
	unsigned int          chgbright;
	int                   saturation_data;
	int                   lightness_data;
	int                   hue_data;
	
	char                  bus_dirname[10];
	char                  dev_filename[10];
	char                  pathname[100];
	char                  basename[50];
	
} usb_stv;

usb_dev_handle *pencam_open(usb_stv *stv680);

void do_bright(BrightnessParams bright, unsigned char *pic, unsigned long total_bytes);
void bad_value();
int pencam_get_picture( usb_dev_handle *pc, int pic_no, const char *outpath, 
                        usb_stv *stv680);
int pencam_vendor(int set, usb_dev_handle *pc, int type, int size, int value, unsigned char *buffer);
int pencam_configuration( usb_dev_handle *pc, int conf, int i, int a );

void splitup(unsigned char *src, unsigned char *dest, int wdth, int hght, 
             int channel);
void rebuild(unsigned char *src, unsigned char *dest, int wdth, int hght, 
             int channel);

double get_val(int fmin, int fmax);
int pencam_init(usb_dev_handle *pc, usb_stv *stv680);

void bayer_unshuffle(unsigned char *raw, unsigned char *output, usb_stv *stv680);
void bayer_demosaic(usb_stv *stv680, unsigned char *output);

void light_enhance(usb_stv *stv680, unsigned char *output);

void hue_saturation(unsigned char *input, unsigned char *output, usb_stv *stv680);

void sharpen(unsigned char *src_region, unsigned char *dest_region, 
		usb_stv *stv680, int sharpen_percent);
