function debian_load_rootkeys()
  root_key_path = "/usr/share/dns/root.ds"
  ds_list = {}
  pdnslog("debian_load_rootkeys: Loading DNSSEC root keys from " .. root_key_path)
  -- . IN DS 19036 8 2 49aac11d7b6f6446702e54a1607371607a1a41855200fd2ce1cdde32f24e8fb5
  for line in io.lines(root_key_path) do
    ds = string.match(line, "^%.%s+IN%s+DS%s+(%d+%s+%d+%s+%d+%s+%S+)")
    if ds then
      table.insert(ds_list, ds)
    end
  end
  if #ds_list > 0 then
    pdnslog("debian_load_rootkeys: Removing built in root DS entries.")
    clearDS()
    for _, ds in pairs(ds_list) do
      pdnslog("debian_load_rootkeys: Adding DS for root: " .. ds)
      addDS(".", ds)
    end
  end
end

debian_load_rootkeys()
