/*
 * window_main_burst.h
 * Copyright (C) Martin Singer 2009-2011 <m_power3@users.sourceforge.net>
 * 
 * pdfchain is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * pdfchain is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PDFCHAIN_WINDOW_MAIN_BURST_H
#define PDFCHAIN_WINDOW_MAIN_BURST_H

#include "pdfchain.h"
#include "store.h"
#include "dialog_filechooser.h"


/*** Combobox : Counting Methode **********************************************/

class
cCBox_CountingMethode : public Gtk::ComboBox
{
	friend class cTable_Burst;
	
	public:

		cCBox_CountingMethode();
		virtual ~cCBox_CountingMethode();
		
	protected:

		Glib::RefPtr<cLStore_CountingMethode>	rLStore;
		Gtk::CellRendererText					mCRText;
		cTMCRecord_Selection*					pTMCRecord;		
};



/*** Table Burst **************************************************************/

class
cTable_Burst : public Gtk::Table
{
	public:

		cTable_Burst( Gtk::Window& );
		virtual ~cTable_Burst();

		//void clear();
		std::string createCommand();

	private:

		Glib::ustring	sPrefix,
						sSuffix;
		guint			vPageNumbers;
		guint			vDigits_Oct,
						vDigits_Dec,
						vDigits_Hex;

		Gtk::Label						mLabel_SourceFile,
										mLabel_Prefix,
										mLabel_Suffix,
										mLabel_CountingMethod,
										mLabel_CounterDigits;
		cFCButton						mFCButton_SourceFile;
		Gtk::Entry						mEntry_Prefix,
										mEntry_Suffix;
		Glib::RefPtr<Gtk::Adjustment>	rAdjust_Digits;			// Declaration of Adjustment before SpinButton!
		Gtk::SpinButton					mSButton_Digits;
		Gtk::RadioButton				mRButton_Auto,
										mRButton_Manual;
		Gtk::CheckButton				mCButton_AddExtension;
		cCBox_CountingMethode			mCBox_CountingMethod;
		Gtk::Alignment					mAlignment_A,
										mAlignment_B,
										mAlignment_C,
										mAlignment_D,
										mAlignment_E,
										mAlignment_F;
		Gtk::RadioButtonGroup			mRBGroup_CounterDigits;
		cFCDialog						mFCDialog_SaveAs;

		void init();
		
		void onEntryIcon_Prefix_pressed( Gtk::EntryIconPosition icon_pos , const GdkEventButton* event ) {
			mEntry_Prefix.set_text( sPrefix );
			return;
		}

		void onEntryIcon_Suffix_pressed( Gtk::EntryIconPosition icon_pos , const GdkEventButton* event ) {
			mEntry_Suffix.set_text( sSuffix );
			return;
		}

		void onCBox_CountingMethode_changed() {
			Gtk::TreeModel::iterator	iter		= mCBox_CountingMethod.get_active();
			cTMCRecord_Selection*		pt_record	= mCBox_CountingMethod.rLStore->getTMCRecord();

			if ( mRButton_Auto.get_active() ) {
				switch ( (*iter)[pt_record->mTMColumn_ID] ) {
					case Pdfchain::Id::COUNT_OCT:
						rAdjust_Digits->set_value( static_cast<double>( vDigits_Oct ) );
						break;
					case Pdfchain::Id::COUNT_DEC:
						rAdjust_Digits->set_value( static_cast<double>( vDigits_Dec ) );
						break;
					case Pdfchain::Id::COUNT_HEX:
						rAdjust_Digits->set_value( static_cast<double>( vDigits_Hex ) );
						break;
				}
			}

			return;
		}

		void onRButton_Auto_toggled() {
			mSButton_Digits.set_sensitive( mRButton_Manual.get_active() );
			onCBox_CountingMethode_changed();
			return;
		}

		void onFCButton_SourceFile_file_set() {
			vPageNumbers = Pdfchain::count_page_numbers( mFCButton_SourceFile.get_filename() );
			vDigits_Oct = Pdfchain::count_digits_of_guint_oct( vPageNumbers );
			vDigits_Dec = Pdfchain::count_digits_of_guint_dec( vPageNumbers );
			vDigits_Hex = Pdfchain::count_digits_of_guint_hex( vPageNumbers );

			onCBox_CountingMethode_changed();
			return;
		}
};


#endif