/*
 * window_main_bgst.h
 * Copyright (C) Martin Singer 2009-2011 <m_power3@users.sourceforge.net>
 * 
 * pdfchain is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * pdfchain is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PDFCHAIN_WINDOW_MAIN_BGST_H
#define PDFCHAIN_WINDOW_MAIN_BGST_H

#include "pdfchain.h"
#include "dialog_filechooser.h"


/*** Table Merge **************************************************************/

class
cTable_BgSt : public Gtk::Table
{
	public:

		cTable_BgSt( Gtk::Window& );
		virtual ~cTable_BgSt();

		//void clear();
		std::string createCommand();
		
	private:

		guint	vPageNumbers_SourceFile,
				vPageNumbers_BgStFile;

		Gtk::Label				mLabel_SourceFile,
								mLabel_BgStFile;
		cFCButton				mFCButton_SourceFile,
								mFCButton_BgStFile;
		Gtk::RadioButton		mRButton_Background,
								mRButton_Stamp;
		Gtk::RadioButtonGroup	mRBGroup_BgSt;
		Gtk::CheckButton		mCButton_Multi;
		Gtk::Separator			mVSeparator;
		Gtk::Alignment			mAlignment_A,
								mAlignment_B,
								mAlignment_C;
		cFCDialog_SaveAs		mFCDialog_SaveAs;

		void init();

		void onFCButton_SourceFile_file_set() {
			vPageNumbers_SourceFile = Pdfchain::count_page_numbers( mFCButton_SourceFile.get_filename() );
			return;
		}

		void onFCButton_BgStFile_file_set() {
			vPageNumbers_BgStFile = Pdfchain::count_page_numbers( mFCButton_BgStFile.get_filename() );
			return;
		}
};



#endif