Introduction
============
Password Safe is a password database utility. Like many other such
products, commercial and otherwise, it stores your passwords in an
encrypted file, allowing you to remember only one password (the "safe
combination"), instead of all the username/password combinations that
you use.

What makes Password Safe different? Three things:
1. Simplicity: Password Safe is designed to do one thing, and to do it
well. Start the application, enter your "combination", double-click on
the right entry - presto - the password is now on your clipboard,
ready for pasting.
2. Security: The original version was designed by Bruce Schneier -
'nuff said.
3. Open Source: The source code for the project is available for
inspection. For more information, see https://pwsafe.org.

The current version of Password Safe currently runs on Windows 7 and
later. Older versions are still available supporting Windows 95, 98,
ME, NT, 2000, XP, Vista as well as PocketPC. Support for additional
platforms is planned for future releases.

Linux packages are also available for popular distributions. See
README.LINUX.md for more details.

FreeBSD is also supported. See README.FREEBSD.

Downloading
===========
The latest & greatest version of Password Safe may be downloaded from
[SourceForge](https://sourceforge.net/projects/passwordsafe/files/latest/download)
or
[GitHub](https://github.com/pwsafe/pwsafe/releases/latest).

Non-English Support
===================
Thanks to the help of volunteers from all over the world, PasswordSafe
now has built-in support for the following languages:
- Czech
- Chinese
- Danish
- Dutch
- French
- German
- Italian
- Polish
- Russian
- Spanish
- Swedish
- Turkish

Older versions have translations to other languages as well, see
https://pwsafe.org/nonenglish.shtml for the complete list.

If you are interested  in making Password Safe available in other
languages, please let [me](https://pwsafe.org/contact.php) know.

Installation
============
For convenience, Password Safe is packaged into an executable
installer program. This installs the program, sets up shortcuts and
allows you to uninstall the program from the Windows Control
Panel. However, if you prefer, the -bin.zip file contains all the
files you need. Just extract the files (using WinZip, for example) to
any directory, double-click on the Pwsafe.exe icon,and that's
it. You may want to create a shortcut to your desktop and/or Start
menu. Finally, a Microsoft installer (.msi) package is also
available.

License
=======
Password Safe is available under the restrictions set forth in the
standard "Artistic License 2.0". For more details, see the LICENSE
file that comes with the package.

Password Safe 3.29 and later makes use of the
[pugixml project](http://www.pugixml.org), which is available under
the [MIT license](http://www.opensource.org/licenses/mit-license.html).

Helping Out
===========
Please report bugs via the project's bug tracking form, at
https://sourceforge.net/p/passwordsafe/bugs/ (you might want to browse
the list, to see if the issue hasn't been reported already).

Requests for features and enhancements should be submitted to the
Feature Requests page, at
https://sourceforge.net/p/passwordsafe/feature-requests/

You can also post questions, suggestions, rants, raves, etc. to the
Help or Open Discussion forums, at
https://sourceforge.net/p/passwordsafe/discussion/

If you wish to contribute to the project by writing code and/or
documentation, please drop a note to the developer's mailing list:
http://lists.sourceforge.net/lists/listinfo/passwordsafe-devel

New releases are announced on the passwordsafe-announce mailing list:
http://lists.sourceforge.net/lists/listinfo/passwordsafe-announce

Last but not least: PasswordSafe is and will always remain an open
source project, free for and redistribution. However, donations to the
project will help me justify the time and effort I spend in
maintaining and improving this utility. In addition, donations to the
project help maintain SourceForge, the hosting site. If you wish to
donate, please click on the Donate button at the top of
https://pwsafe.org

Release Notes
=============
For information on the latest features, bugfixes and known problems,
see the ReleaseNotes.txt file that comes with the package.

Credits
=======
- The original version of Password Safe was designed by Bruce
Schneier, written by Mark Rosen, and was freely downloadable from
Conterpane Lab's website. Thanks to Mark for writing a great little
application! Following Mark, it was maintained by "AYB", at
Counterpane. Thanks to Counterpane for deciding to open source the
project.
- Jim Russell first brought the code to SourceForge, did some major
cleaning up of the code, set up a nice project and added some minor
features in release 1.9.0
- Releases2.x have been brought to you by: Andrew Mullican,
Edward Quackenbush, Gregg Conklin, Graham Ullrich, and Rony
Shapiro. Karel (Karlo) Van der Gucht also contributed some of the
password policy code and some GUI improvements for 1.92.
- Emilijan Mirceski did the new graphics for 2.0.
- Maxim Tikhonov translated the first online help to Russian.
- Thanks to the PasswordSafe developer's mailing list for help in
nailing down the 3.x file format.
- Many, many new features in 3.x have been implemented by DK.
- Finally, thanks to the folks at SourceForge and GitHub for hosting
this project.

