///
// Copyright (C) 2002 - 2004, Fredrik Arnerup & Rasmus Kaj, See COPYING
///
#include "window.h"
#include <gtkmm/menubar.h>
#include <gtkmm/menu.h>
#include <gtkmm/image.h>
#include <gtkmm/stock.h>
#include "widget/filesel.h"
#include "config.h"
#include "printdialog.h"
#include "aboutdialog.h"
#include "propertiesdialog.h"
#include "streamdialog.h"
#include "inspiration.h"
#include "webbrowser.h"

void FrameWindow::create_menus() {
  using namespace Gtk;
  using namespace Menu_Helpers;
  using SigC::bind;
  using SigC::slot;

  /// *** file menu ***

  Menu *file_menu = manage(new Menu());
  MenuList& list_file = file_menu->items();
  list_file.push_back
    (ImageMenuElem("_New ...", AccelKey("<control>N"),
		   *manage(new Gtk::Image(Gtk::Stock::NEW, 
					  Gtk::ICON_SIZE_MENU)),
		   slot(*this, &FrameWindow::new_document)));
  list_file.push_back
    (ImageMenuElem("New Vi_ew", 
		   *manage(new Gtk::Image(Gtk::Stock::NEW, 
					  Gtk::ICON_SIZE_MENU)),
		   slot(*this, &FrameWindow::duplicate_view)));
  new_view_item = &list_file.back();
  list_file.push_back
    (ImageMenuElem("_Open ...", AccelKey("<control>O"),
		   *manage(new Gtk::Image(Gtk::Stock::OPEN, 
					  Gtk::ICON_SIZE_MENU)),
		   slot(*open_dialog, &Filesel::show_all)));
  list_file.push_back(SeparatorElem());
  list_file.push_back(StockMenuElem(Gtk::Stock::SAVE,
				    slot(*this, &FrameWindow::save)));
  save_item = &list_file.back();
  list_file.push_back
    (ImageMenuElem("Save _As ...", AccelKey("<shift><control>S"),
		   *manage(new Gtk::Image(Gtk::Stock::PRINT, 
					  Gtk::ICON_SIZE_MENU)),
		   slot(*save_dialog, &Filesel::show_all)));
  save_as_item = &list_file.back();
  list_file.push_back(SeparatorElem());
  list_file.push_back
    (ImageMenuElem("_Print ...", AccelKey("<control>P"),
		   *manage(new Gtk::Image(Gtk::Stock::PRINT, 
					  Gtk::ICON_SIZE_MENU)),
		   slot(*print_dialog, &PrintDialog::show_it)));
  print_item = &list_file.back();
  list_file.push_back(StockMenuElem(Gtk::Stock::PRINT_PREVIEW,
				    AccelKey("<shift><control>P"),
				    slot(*this, 
					 &FrameWindow::print_to_viewer)));
  preview_item = &list_file.back();
  list_file.push_back(SeparatorElem());
  list_file.push_back
    (MenuElem("P_roperties ...",
	      slot(*this, &FrameWindow::show_doc_props_dialog)));
  props_item = &list_file.back();
  list_file.push_back(SeparatorElem());
  list_file.push_back(StockMenuElem(Gtk::Stock::CLOSE,
				    slot(*this, &FrameWindow::close)));
  list_file.push_back(StockMenuElem(Gtk::Stock::QUIT,
				    SigC::slot(&FrameWindow::quit)));
  menubar->items().push_back(MenuElem("_File", AccelKey("<alt>f"), 
				      *file_menu));

  /// *** edit menu ***

  edit_menu = manage(new Menu());
  MenuList& list_edit = edit_menu->items();
  
#ifdef ENABLE_UNDO
  list_edit.push_back(StockMenuElem(Gtk::Stock::UNDO, 
				    AccelKey("<control>Z") /*, slot*/));
  undo_item = &list_edit.back();
  list_edit.push_back(StockMenuElem(Gtk::Stock::REDO,
				    AccelKey("<shift><control>Z") /*, slot*/));
  redo_item = &list_edit.back();
  list_edit.push_back(SeparatorElem());
#endif
  
  list_edit.push_back(StockMenuElem(Gtk::Stock::COPY,
				    slot(document_view, 
					 &DocumentView::copy)));
  list_edit.push_back(StockMenuElem(Gtk::Stock::CUT,
				    slot(document_view, 
					 &DocumentView::cut)));
  list_edit.push_back(StockMenuElem(Gtk::Stock::PASTE,
				    slot(document_view, 
					 &DocumentView::paste)));
  list_edit.push_back
    (StockMenuElem(Gtk::Stock::DELETE,
		   AccelKey(guint(GDK_Delete), 
			    Gdk::ModifierType(0)),
		   slot(document_view, &DocumentView::delete_selected)));

  list_edit.push_back(SeparatorElem());
  list_edit.push_back(MenuElem("Select _All", AccelKey("<control>A"),
			       slot(document_view, 
				    &DocumentView::select_all_frames)));
  list_edit.push_back
    (MenuElem("Dese_lect All",	AccelKey("<shift><control>A"),
	      slot(document_view, &DocumentView::unselect_all_frames)));
  list_edit.push_back(SeparatorElem());
  // *** arrange submenu ***
  Menu *arrange_menu = manage(new Menu());
  MenuList& list_arrange = arrange_menu->items();
  list_arrange.push_back(MenuElem("_Group", AccelKey("<control>G"),
				  slot(document_view, 
				       &DocumentView::group_selected)));
  list_arrange.push_back
    (MenuElem("_Ungroup", AccelKey("<control>U"),
	      slot(document_view, &DocumentView::ungroup_selected)));
  list_arrange.push_back(SeparatorElem());
  list_arrange.push_back
    (MenuElem("Move to _top", AccelKey("<control>Home"),
	      bind(slot(document_view, 
			&DocumentView::rearrange_selected), TOP)));
  list_arrange.push_back
    (MenuElem("Move _up", AccelKey("<control>Page_Up"),
	      bind(slot(document_view, 
			&DocumentView::rearrange_selected), UP)));
  list_arrange.push_back
    (MenuElem("Move _down", AccelKey("<control>Page_Down"),
	      bind(slot(document_view, 
			&DocumentView::rearrange_selected), DOWN)));
  list_arrange.push_back
    (MenuElem("Move to _bottom", AccelKey("<control>End"),
	      bind(slot(document_view, 
			&DocumentView::rearrange_selected), BOTTOM)));
  list_edit.push_back(MenuElem("A_rrange", *arrange_menu));
  list_edit.push_back(SeparatorElem());
  list_edit.push_back(MenuElem("Insert Te_xt Frame ...", 
			       slot(*text_frame_dialog,
				    &TextFrameDialog::show_raise)));
  list_edit.push_back(MenuElem("Insert _Image ...", 
			       slot(*import_dialog, &Filesel::show_all)));
  list_edit.push_back(SeparatorElem());
  list_edit.push_back(MenuElem("Pre_ferences ...", 
			       slot(config, &PFile::dialog_show)));
  prefs_item = &list_edit.back();
  menubar->items().push_back(MenuElem("_Edit", AccelKey("<alt>e"), 
				      *edit_menu));


  // *** page menu ***

  page_menu = manage(new Menu());
  MenuList& list_page = page_menu->items();
  list_page.push_back(MenuElem("_Delete", 
			       slot(document_view, 
				    &DocumentView::delete_page)));
  list_page.push_back(SeparatorElem());
  list_page.push_back(MenuElem("Insert _Before ...", 
			       slot(document_view, 
				    &DocumentView::insert_page_before)));
  list_page.push_back(MenuElem("Insert _After ...", 
			       slot(document_view, 
				    &DocumentView::insert_page_after)));
  delete_page_item = &list_page.back();
  //  list_page.push_back(SeparatorElem());
  //  list_page.push_back(MenuElem("_Template Page ...", slot(this, &FrameWindow::show_template_page_dialog)));
  // it is not yet possible to change the template of an existing page
  menubar->items().push_back(MenuElem("_Page", AccelKey("<alt>p"),*page_menu));


  // *** view menu ***

  Menu *view_menu = manage(new Menu());
  MenuList& list_view = view_menu->items();
  list_view.push_back
    (CheckMenuElem("_Toolbar", 
		   slot(*this, &FrameWindow::toggle_toolbar)));
  static_cast<CheckMenuItem*>(&list_view.back())->set_active(true);
  list_view.push_back(SeparatorElem());
  list_view.push_back
    (StockMenuElem(Gtk::Stock::PROPERTIES,
		   slot(PropertiesDialog::instance(),
			&PropertiesDialog::show_raise)));
  list_view.push_back(MenuElem("_Streams", 
			       slot(StreamDialog::instance(),
				    &StreamDialog::show_raise)));
#ifdef ENABLE_UNDO
  list_view.push_back(MenuElem("_Undo history", 
			       slot(UndoDialog::instance(),
				    &UndoDialog::show_raise)));
#endif
  menubar->items().push_back(MenuElem("_View", 
				      AccelKey("<alt>v"), 
				      *view_menu));


  // *** help menu ***

  Menu *help_menu = manage(new Menu());
  MenuList& list_help = help_menu->items();
  list_help.push_back(MenuElem("_User's guide", AccelKey("F1"),
			       SigC::slot(&open_docs)));
  list_help.push_back(MenuElem("_About", 
			       slot(AboutDialog::instance(), 
				    &AboutDialog::show_all)));
  list_help.push_back(SeparatorElem());
  list_help.push_back(MenuElem("_Homepage", 
			       SigC::slot(&open_homepage)));
  list_help.push_back(MenuElem("_Inspiration", 
			       slot(Inspiration::instance(),
				    &Inspiration::show_all)));
  menubar->items().push_back(MenuElem("_Help", AccelKey("<alt>h"), 
				      *help_menu));
  menubar->items().back().set_right_justified();
}
