#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include "Speedwalk.h"
#include "Win32PluginAPI.cpp"

static Speedwalk * sample;

#define MAJOR "1"
#define MINOR "1"

extern "C" G_MODULE_EXPORT void plugin_init(plugin_address_table_t * pat) {
	plugin_address_table_init(pat);
	sample = new Speedwalk();
}

extern "C" G_MODULE_EXPORT void plugin_cleanup(void) {
  delete sample;
}

extern "C" G_MODULE_EXPORT char * plugin_query_name() {
  return "Speedwalk";
}

extern "C" G_MODULE_EXPORT char * plugin_query_description() {
  return _("Allows speedwalking on lines starting with '-'");
}

extern "C" G_MODULE_EXPORT char * plugin_query_major() {
  return MAJOR;
}

extern "C" G_MODULE_EXPORT char * plugin_query_minor() {
  return MINOR;
}

Speedwalk::Speedwalk() {
  version = 0.1;
  name = strdup("Speedwalk");
  register_plugin(this, VERSION);
  plugin_handler_add_input_filter(get_plugin_handler(), this);
}


Speedwalk::~Speedwalk() {
  free(name);
  name = NULL;
  unregister_plugin(this);
}

void G_MODULE_EXPORT Speedwalk::input(Connection * c, char * buf) {

  char * pc = buf;
  char buf2[1024];
  VT * vt;

  // Is this a valid speedwalk command:
  if (buf[0] != '-')
    return;

  // Start parsing
  while (*pc != '\0') {

    Socket * s = connection_get_socket(c);

    switch (*pc) {
    case 'n':
		socket_write(s, "north\n", 6);
      break;
    case 's':
		socket_write(s, "south\n", 6);
      break;
    case 'e':
		socket_write(s, "east\n", 5);
      break;
    case 'w':
		socket_write(s, "west\n", 5);
      break;
    case 'u':
	    socket_write(s, "up\n", 3);
      break;
    case 'd':
		socket_write(s, "down\n", 5);

    case 'N':
      if (*(pc+1) == '\0')
	break;

      if (*(pc+1) == 'E') {
		  socket_write(s, "northeast\n", 10);
	pc++;
	break;
      }
      if (*(pc+1) == 'W') {
			socket_write(s, "northwest\n", 10);
	pc++;
	break;
      }	

      sprintf(buf2, "Invalid speedwalk at index %d (%c%c)\n", pc-buf, *pc, *(pc+1));
	  vt = connection_get_vt(c);
	  vt_append(vt, buf);

      break;
      
    case 'S':

      if (*(pc+1) == '\0')
	break;

      if (*(pc+1) == 'E') {
			socket_write(s, "southeast\n", 10);
	pc++;
	break;
      }
      if (*(pc+1) == 'W') {
			socket_write(s, "southwest\n", 10);
	pc++;
	break;
      }	

      sprintf(buf2, "Invalid speedwalk at index %d (%c%c)\n", pc-buf, *pc, *(pc+1));
	  vt = connection_get_vt(c);
	  vt_append(vt, buf);
      break;

    default:

      sprintf(buf2, "Invalid speedwalk at index %d (%c%c)\n", pc-buf, *pc, *(pc+1));
	  vt = connection_get_vt(c);
      vt_append(vt, buf);
    }
    pc++;
  }

  buf[0] = '\0';
}
