# This plugin is copyright 2001 Catherine Allen (mango@turf.org)
# It is released under version 2.0 of the GPL.

import papaya
import re
import string

from _gtk import *
from GTK import *

userlist_major = "1"
userlist_minor = "2"

def userlist_init():
    global userlist_windows
    global userlist_clists
    global userlist_users
    global userlist_timeouts
    global userlist_popup_windows
    global userlist_finger_data

    global userlist_regexp
    global userlist_sort_by

    try:
        if userlist_sort_by >= 0:
            papaya.message("Python: Userlist Plugin", "There is already an instance of the Python userlist plugin active.  I will not attempt to load a second time.")
            return
    except NameError:
        papaya.message("Python: Userlist Plugin", "Userlist plugin version " + userlist_major + "." + userlist_minor + " is now active.");
    
    userlist_windows = {}
    userlist_clists = {}
    userlist_users = {}
    userlist_timeouts = {}
    userlist_sort_by = {}
    userlist_popup_windows = {}
    userlist_finger_data = {}

    pattern = "^[ ]*([0-9]+)[ ]+([a-zA-Z]+).*- ([a-zA-Z]+)([^~]*)(.*)\n$"
    userlist_regexp = re.compile(pattern)
    
    # default sort_by is level

    papaya.input_add("userlist_input_func")
    papaya.event_add("userlist_on_event")

def userlist_input_func(input):
    global papaya_connection

    if input == 'userlist':
        userlist_retrieve(papaya_connection)
        return ''

    return input

def userlist_retrieve(conn):
    global userlist_users
    global userlist_windows
    global clist
    global papaya_connection

    if userlist_windows.has_key(conn) == 0:
        userlist_create_widget(conn)

    userlist_users[conn] = []

    # Set the active connection as after the timeout, Papaya won't know what
    # it is.
    papaya_connection = conn
    papaya.turf_protocol_add('who', 'userlist_callback', conn)

def userlist_sort_func(first, second):

    global userlist_sort_by
    global userlist_current_mud

    sort = userlist_sort_by[userlist_current_mud]

    if sort in [0]:
        one = string.atoi(first[sort])
        two = string.atoi(second[sort])

        if one < two:
            return 1

        if one == two:
            return 0

        return -1

    else:
        one = first[sort]
        two = second[sort]
        
    if one > two:
        return 1
    
    if one == two:
        return 0

    return -1

def userlist_callback(input, data):

    global userlist_users
    global pattern
    global papaya_connection
    global userlist_regexp
    global userlist_current_mud

    if input:
        if ord(input[0]) == 0x1f:
            return

        mymatch = userlist_regexp.match(input)

        if mymatch == None:
            return

        tmparray = []
        tmparray.append(mymatch.group(1))
        tmparray.append(mymatch.group(2))
        tmparray.append(mymatch.group(3))
        tmparray.append(mymatch.group(4))
        tmparray.append(mymatch.group(5))
        
        userlist_users[data].append(tmparray)
        tmparray = []

        return

    # Do we want to sort this list?

    gtk_clist_clear(userlist_clists[data])
    userlist_current_mud = data
    userlist_users[data].sort(userlist_sort_func)
    for i in userlist_users[data]:

        level = i[0]
        class_hero = i[1]
        name = i[2]
        title = i[3]
        flags = i[4]
        
        gtk_clist_append(userlist_clists[data], [name, title, level, class_hero, flags])
        
    # Fix the clist to be more optimally sized.

    for i in [0,1,2,3,4]:
        gtk_clist_set_column_width(userlist_clists[data], i, gtk_clist_optimal_column_width(userlist_clists[data], i))
                                   
    userlist_users[data] = []
    userlist_timeouts[data] = gtk_timeout_add(60000, userlist_retrieve, (data,))

def userlist_column_clicked(extra, column, mud):

    global userlist_sort_by
    global userlist_timeouts

    if userlist_sort_by.has_key(mud) == 1:

        if column == 0:
            userlist_sort_by[mud] = 2
        elif column == 1:
            userlist_sort_by[mud] = 3
        elif column == 2:
            userlist_sort_by[mud] = 0
        elif column == 3:
            userlist_sort_by[mud] = 1
        else:
            userlist_sort_by[mud] = 4

        gtk_timeout_remove(userlist_timeouts[mud])
        userlist_retrieve(mud)

def userlist_row_clicked(extra, row, column, more, mud):

    global userlist_windows
    global userlist_clists
    global papaya_connection

    name = gtk_clist_get_text(userlist_clists[mud], row, 0)

    if userlist_popup_windows.has_key(name) == 1:
        gtk_widget_destroy(userlist_popup_windows[name])

    papaya_connection = mud
    papaya.turf_protocol_add("finger " + name, 'userlist_finger_callback', name)

def userlist_finger_callback(input, name):
    global userlist_finger_data

    if input == None:
        text = userlist_popup(name, "Finger: " + name, userlist_finger_data[name])
        return

    if ord(input[0]) == 0x1f:
        return

    if userlist_finger_data.has_key(name) == 0:
        userlist_finger_data[name] = ""

    userlist_finger_data[name] = userlist_finger_data[name] + input

def userlist_create_widget(mud):
    # Create a userlist window

    global userlist_windows
    global userlist_clists

    window = gtk_window_new (WINDOW_TOPLEVEL)
    gtk_window_set_title(window, mud + " - Papaya Userlist")
    gtk_signal_connect(window, "destroy", userlist_destroyed, ('disconnect',))

    gtk_widget_show(window)

    clist = gtk_clist_new_with_titles(5, ['Name', 'Title', 'Level', 'Class', 'Flags'])
    gtk_widget_show(clist)
    gtk_container_add(window, clist)

    gtk_signal_connect(clist, "click_column", userlist_column_clicked, (mud,))
    gtk_signal_connect(clist, "select_row", userlist_row_clicked, (mud,))

    userlist_windows[mud] = window
    userlist_clists[mud] = clist
    userlist_sort_by[mud] = 0

def userlist_destroyed(object, args):
    # Need to know which connection we're destroying the widget of.

    global userlist_windows

    for key in userlist_windows.keys():
        if userlist_windows[key] == object:
            userlist_destroy_widget(key)

def userlist_on_event(type):
    if type == 'disconnect':
        gtk_widget_hide(userlist_windows[papaya_connection])
        gtk_widget_destroy(userlist_windows[papaya_connection])

def userlist_destroy_widget(key):
    global userlist_windows
    global userlist_clists
    global userlist_users
    global userlist_timeouts

    if userlist_windows.has_key(key) == 1:
        gtk_timeout_remove(userlist_timeouts[key])
        
        del userlist_windows[key]
        del userlist_clists[key]
        del userlist_users[key]
        del userlist_timeouts[key]
        del userlist_sort_by[key]

def userlist_popup_destroyed(widget, key):
    global userlist_popup_windows
    global userlist_finger_data
    del userlist_popup_windows[key]

    if userlist_finger_data.has_key(key) == 1:
        del userlist_finger_data[key]


# Creates a single popup window with the title 'title' and a text box
# containing 'string'.
def userlist_popup(key, title, string):
    global userlist_popup_windows

    window = gtk_window_new(WINDOW_TOPLEVEL)
    gtk_window_set_title(window, title)
    gtk_signal_connect(window, "destroy", userlist_popup_destroyed, (key,))

    gtk_widget_show(window)

    text_box = gtk_hbox_new(0, 2)
    gtk_widget_show(text_box)

    text = gtk_text_new(None, None)
    gtk_text_set_editable(text, 0)
    gtk_text_set_word_wrap(text, 1);
    gtk_box_pack_start(text_box, text, 1, 1, 0)
    gtk_widget_show(text)

    font = gdk_font_load("-*-courier-medium-r-normal-*-*-100-*-*-*-*-*-*")

    gtk_text_insert(text, font, None, None, string, len(string))

    vscrollbar = gtk_vscrollbar_new(gtk_text_get_vadj(text))
    gtk_box_pack_start(text_box, vscrollbar, 0, 0, 0)
    gtk_widget_show(vscrollbar)

    gtk_container_add(window, text_box)

    gtk_widget_set_usize(window, 500, 190)

    userlist_popup_windows[key] = window
    return text
        
userlist_init()
