#include "FontPreference.h"
#include "mudclient.h"

extern PreferenceHandler * preferenceHandler;
static FontPreference * fontPreference;
FontPreference::FontPreference() {
  xml = NULL;
  fontPreference = this;
}

FontPreference::~FontPreference() {
  fontPreference = NULL;
  if (xml)
    g_object_unref(xml);
}

GtkWidget * FontPreference::getWidget() {
  char buf[1024];
  snprintf(buf, 1024, "%s/share/papaya/fontpreferences.glade", getPrefix());
  
  if (xml) {
    GtkWidget * vbox = glade_xml_get_widget(xml, "vbox");
    return vbox;
  }

  xml = glade_xml_new(buf, "vbox", NULL);
  glade_xml_signal_autoconnect(xml);
  GtkWidget * vbox = glade_xml_get_widget(xml, "vbox");
  gtk_widget_show(vbox);

  // Now attach the font choosers to the table.

  prompt_chooser = new FontChooser("monospace 12");
  input_chooser = new FontChooser("monospace 12");
  output_chooser = new FontChooser("monospace 12");
  bold_chooser = new FontChooser("monospace bold 12");
  italic_chooser = new FontChooser("monospace italic 12");

  GtkWidget * table = glade_xml_get_widget(xml, "output_font_table");

  gtk_table_attach(GTK_TABLE(table), output_chooser->getUI(),
		   1, 2, 0, 1,
		   (GtkAttachOptions) (GTK_FILL|GTK_EXPAND),
		   (GtkAttachOptions) 0, 0, 0);

  gtk_table_attach(GTK_TABLE(table), prompt_chooser->getUI(),
		   1, 2, 1, 2,
		   (GtkAttachOptions) (GTK_FILL|GTK_EXPAND),
		   (GtkAttachOptions) 0, 0, 0);

  gtk_table_attach(GTK_TABLE(table), bold_chooser->getUI(),
		   1, 2, 2, 3,
		   (GtkAttachOptions) (GTK_FILL|GTK_EXPAND),
		   (GtkAttachOptions) 0, 0, 0);

  gtk_table_attach(GTK_TABLE(table), italic_chooser->getUI(),
		   1, 2, 3, 4,
		   (GtkAttachOptions) (GTK_FILL|GTK_EXPAND),
		   (GtkAttachOptions) 0, 0, 0);


  table = glade_xml_get_widget(xml, "input_font_table");

  gtk_table_attach(GTK_TABLE(table), input_chooser->getUI(),
		   1, 2, 0, 1,
		   (GtkAttachOptions) (GTK_FILL|GTK_EXPAND),
		   (GtkAttachOptions) 0, 0, 0);


  return vbox;
}

void FontPreference::loadPreferences(Prefs * prefs) {
  Preference::loadPreferences(prefs);

  output_chooser->setFont(prefs->getPreference("OutputFont"));
  input_chooser->setFont(prefs->getPreference("InputFont"));
  prompt_chooser->setFont(prefs->getPreference("PromptFont"));
  italic_chooser->setFont(prefs->getPreference("ItalicFont"));
  bold_chooser->setFont(prefs->getPreference("BoldFont"));
}

void FontPreference::applyPreferences(Prefs * prefs) {
  Preference::applyPreferences(prefs);
  
  gchar * font = output_chooser->getFont();
  prefs->setPreference("OutputFont", font);
  g_free(font);

  font = input_chooser->getFont();
  prefs->setPreference("InputFont", font);
  g_free(font);

  font = italic_chooser->getFont();
  prefs->setPreference("ItalicFont", font);
  g_free(font);

  font = bold_chooser->getFont();
  prefs->setPreference("BoldFont", font);
  g_free(font);

  font = prompt_chooser->getFont();
  prefs->setPreference("PromptFont", font);
  g_free(font);
}

void FontPreference::destroyWidget() {
  if (xml)
    g_object_unref(xml);
  xml = NULL;
}

Category * FontPreference::getCategories() {
  return (Category *)font_categories;
}
