#ifndef INCLUDE_ALIAS_H
#define INCLUDE_ALIAS_H

#include <stdio.h>
#include "PapayaList.h"

#define ALIAS_FAIL 0
#define ALIAS_OK 1

struct alias_data {
  char * name;
  char * body;
  int macro_key;
};

class Alias {

 public:

  Alias();
  ~Alias();

  struct alias_data * getAliasByKey(int);
  struct alias_data * getAliasByName(char *);
  struct alias_data * getAlias(int); // By index in the list

  int addAlias(char *, char *, int);
  void removeAlias(char *);
  void updateAlias(char *, char *, char *);
  int getNumberOfAliases();

  void saveAliases();

  void check_aliases(Connection *, char *, char *);

 private:
  void parseAlias(struct alias_data *, char *, char *, int);
  void loadAliases();
  int readAlias(FILE * fp, char * line);
  void writeAlias(FILE * fp, struct alias_data * alias);
  
  PapayaList * aliasList;
  
  int append_argument(char *, int, int, char *, char);
  int append_char(char *, int, int, char);
  char * findArgument(char *, int);

};

#endif // INCLUDE_ALIAS_H
