/*
**  Folder.h
**
**  Copyright (c) 2001, 2002
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**  
**  This library is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
**  Lesser General Public License for more details.
**  
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#import <Foundation/Foundation.h>

@class Flags;
@class Message;
@class Store;

@interface Folder : NSObject
{
  NSMutableArray *allMessages, *allVisibleMessages;
  NSString *name;

  Store *store;

  BOOL showDeleted;
}

- (id) initWithName: (NSString *) theName;

- (NSString *) name;
- (void) setName: (NSString *) theName;

- (void) appendMessage: (Message *) theMessage;

- (void) appendMessageFromRawSource: (NSData *) theData;

- (void) appendMessageFromRawSource: (NSData *) theData
                              flags: (Flags *) theFlags;

- (NSArray *) allMessages;
- (void) setMessages: (NSArray *) theMessages;

- (Message *) messageAtIndex: (int) theIndex;

- (int) count;

- (void) close;

- (NSArray *) expunge: (BOOL) returnDeletedMessages;

- (Store *) store;
- (void) setStore: (Store *) theStore;

- (void) removeMessage: (Message *) theMessage;

- (BOOL) showDeleted;
- (void) setShowDeleted: (BOOL) theBOOL;

- (int) numberOfDeletedMessages;

- (void) updateCache;

@end
