/* NOT YET COMPLETE! */

/* Implements PKCS #1 v2.1 as specified by RSA Laboratories
 *
 * Written by Tom St Denis
 */
#include <mycrypt.h>

/* error codes */
enum {
   PKCS_OK,                      /* no error */
   PKCS_NUM_TOO_LARGE,           /* number is too large */
   PKCS_MSG_TOO_LARGE,           /* message too large */
   PKCS_ERROR                    /* non-PKCS error */
};

#ifdef PKCS

/* I2OSP(x, xLen)
 *
 * Purpose:  Converts an integer to a big-endian format.  This is for MPI bignums
 */
int pkcs_mp_I2OSP(mp_int *x, int xLen, unsigned char *dst)
{

   /* make sure x < 256^xLen */
   if (mp_unsigned_bin_size(x) > xLen) {
      return PKCS_NUM_TOO_LARGE;
   }

   /* convert it to I2OSP format */
   if (mp_to_unsigned_bin(x, dst) != MP_OKAY) {
      return PKCS_ERROR;
   }

   return PKCS_OK;
}


/* I2OSP(x, xLen)
 *
 * Purpose:  Converts an integer to a big-endian format.  This is for unsigned longs.
 */
int pkcs_long_I2OSP(unsigned long x, int xLen, unsigned char *dst)
{
  int true_length, step;

  /* get the # of bytes for the integer */
  if (x > 0x00FFFFFF) {
     true_length = 4;
  } else if (x > 0x0000FFFF) {
     true_length = 3;
  } else if (x > 0x000000FF) {
     true_length = 2;
  } else {
     true_length = 1;
  }

  /* is it too large? */
  if (true_length > xLen) {
     return PKCS_NUM_TOO_LARGE;
  }

  /* since we are putting this out in big-endian format lets pre-shift the number */
  x = x << (8 * (true_length - 4));

  /* convert it */
  for (step = 0; step < true_length; step++) {
      dst[step] = (x >> 24) & 255;
      x         = x << 8;
  }

  return PKCS_OK;
}

/* OS2IP(x, xLen)
 *
 * Purpose: Converts an octet string to an integer.  For MPI nums.
 */
int pkcs_mp_OS2IP(const unsigned char *input, int xLen, mp_int *dst)
{
   if (mp_read_unsigned_bin(dst, (unsigned char *)input, xLen) != MP_OKAY) {
      return PKCS_ERROR;
   }
   return PKCS_OK;
}

/* OS2IP(x, xLen)
 *
 * Purpose: Converts an octet string to an integer.  For unsigned longs.
 */
int pkcs_long_OS2IP(const unsigned char *input, int xLen, unsigned long *dst)
{
   *dst = 0;
   while (xLen--) {
       *dst = (*dst << 8) | ((unsigned long)*input++);
   }
   return PKCS_OK;
}

/* RSAEP((n, e), m)
 *
 * Purpose: Applies the public key encryption function to a formatted integer m.
 *
 */
int pkcs_RSAEP(mp_int *n, mp_int *e, mp_int *m, mp_int *c)
{
   if (mp_cmp(n, m) != MP_GT) {
      return PKCS_NUM_TOO_LARGE;
   }

   if (mp_exptmod(m, e, n, c) != MP_OKAY) {
      return PKCS_ERROR;
   }

   return PKCS_OK;
}

/* RSADP((n, d), c)
 *
 * Purpose: Applies the private key encryption function to a formatted integer m.
 *
 */
int pkcs_RSADP(mp_int *n, mp_int *d, mp_int *c, mp_int *m)
{
   if (mp_cmp(n, m) != MP_GT) {
      return PKCS_NUM_TOO_LARGE;
   }

   if (mp_exptmod(c, d, n, m) != MP_OKAY) {
      return PKCS_ERROR;
   }

   return PKCS_OK;
}

/* RSASP1((n, d), m)
 *
 * Purpose:  Applies the private key operation to a formatted integer m for the purposes of signing.
 */
int pkcs_RSASP1(mp_int *n, mp_int *d, mp_int *m, mp_int *s)
{
   return pkcs_RSADP(n, d, m, s);
}

/* RSAVP1((n, e), s)
 *
 * Purpose:  Applies the public key operation to a formatted integer m for the purposes of verifying.
 */
int pkcs_RSAVP1(mp_int *n, mp_int *e, mp_int *s, mp_int *m)
{
   return pkcs_RSAEP(n, e, s, m);
}

/* MGF1(mgfSeed, maskLen)
 *
 * Purpose:  Randomly generates a mask with a provided hash, seed and length.
 *
 * Deviation:  Accepts an index into the hash descriptor table so any hash can be used.
 */
int pkcs_MGF1(const unsigned char *mgfSeed, unsigned long mgfSeedLen,
                    unsigned long maskLen, unsigned char *out, int hash)
{
   unsigned char mdbuf[MAXBLOCKSIZE], counter_tmp[4];
   unsigned long counter, x;
   hash_state    md;

   /* valid hash? */
   if (hash_is_valid(hash) == CRYPT_ERROR) {
      return PKCS_ERROR;
   }

   /* reset the automata state so the first pass through will hash the data */
   x = hash_descriptor[hash].hashsize;
   counter = 0;

   while (maskLen--) {
       if (x == hash_descriptor[hash].hashsize) {
          /* init the hash */
          hash_descriptor[hash].init(&md);

          /* convert counter to big-endian format */
          if (pkcs_long_I2OSP(counter++, 4, counter_tmp) != PKCS_OK) {
             return PKCS_ERROR;
          }

          /* perform the hash HASH(mgfSeed || C) */
          hash_descriptor[hash].process(&md, mgfSeed, mgfSeedLen);
          hash_descriptor[hash].process(&md, counter_tmp, 4);

          /* store the hash digest in mdbuf */
          hash_descriptor[hash].done(&md, mdbuf);
          x = 0;
       }
       /* copy bytes of the hash output to 'out' */
       *out++ = mdbuf[x++];
   }
   zeromem(mdbuf, sizeof(mdbuf));
   return PKCS_OK;
}

/* RSAES-OAEP-Encrypt((n, e), M, L)
 *
 * Purpose:  Encrypts a message M with OAEP padding of a message to prevent CCA attacks.
 *
 * Deviation:  You can choose the hash to use with the MGF and there is no support for L strings.
 */
int pkcs_RSAES_OAEP_Encrypt(mp_int *n, mp_int *e, 
                            const unsigned char *M, unsigned long mLen,
                            unsigned char *C, unsigned long *cLen,
                            int hash, int wprng, prng_state *prng)
{
   unsigned long hLen, k, i, j;
   unsigned char seed[1024], DB[1024], dbMask[1024], maskedDB[1024], seedMask[1024],
                 maskedSeed[1024], lHash[1024], EM[1024];
   mp_int pt;
   hash_state md;

   /* check hash */
   if (hash_is_valid(hash) == CRYPT_ERROR ||
       prng_is_valid(wprng) == CRYPT_ERROR) {
      return PKCS_ERROR;
   }

   /* setup hLen and k */
   hLen = hash_descriptor[hash].hashsize;
   k    = mp_unsigned_bin_size(n) - 1;

   /* check length */
   if (mLen > (k - 2*hLen - 2)) {
      return PKCS_MSG_TOO_LARGE;
   }

   /* step 2.a generate lHash = Hash(L), where L == empty string */
      hash_descriptor[hash].init(&md);
      hash_descriptor[hash].done(&md, lHash);

   /* step 2.b generate string PS which is k - mLen - 2*hLen - 2 zero octets
    * [superficial]
    */

   /* step 2.c concatenate lHash || PS || 0x01 || M  into DB */

      /* lHash */
      for (i = j = 0; i < hLen; i++) {
          DB[j++] = lHash[i];
      }

      /* PS */
      for (i = 0; i < (k - mLen - 2*hLen - 2); i++) {
          DB[j++] = 0;
      }

      /* 0x01 */
      DB[j++] = 0x01;

      /* message */
      for (i = 0; i < mLen; i++) {
          DB[j++] = M[i];
      }

   /* step 2.d seed = random octet string of length hLen */
      if (prng_descriptor[wprng].read(seed, hLen, prng) != hLen) {
         return PKCS_ERROR;
      }

   /* step 2.e dbMask = MGF(seed, k - hLen - 1) */
      if (pkcs_MGF1(seed, hLen, k - hLen - 1, dbMask, hash) == PKCS_ERROR) {
         return PKCS_ERROR;
      }

   /* step 2.f maskedDB = DB xor dbMask, [length == k - hLen - 1] */
      for (i = 0; i < (k - hLen - 1); i++) {
          maskedDB[i] = DB[i] ^ dbMask[i];
      }

   /* step 2.g seedMask = MGF(maskedDB, hLen) */
      if (pkcs_MGF1(maskedDB, k - hLen - 1, hLen, seedMask, hash) == PKCS_ERROR) {
         return PKCS_ERROR;
      }

   /* step 2.h maskedSeed = seed xor seedMask [length == hLen] */
      for (i = 0; i < hLen; i++) {
          maskedSeed[i] = seed[i] ^ seedMask[i];
      }

   /* step 2.i EM = 0x00 || maskedSeed || maskedDB  */
      EM[0] = 0x00;

      for (i = 0, j = 1; i < hLen; i++) {
          EM[j++] = maskedSeed[i];
      }

      for (i = 0; i < (k - hLen - 1); i++) {
          EM[j++] = maskedDB[i];
      }

   /* step 3.a convert EM to an integer via OS2IP */
      mp_init(&pt);
      if (pkcs_mp_OS2IP(EM, k, &pt) != PKCS_OK) {
         mp_clear(&pt);
         return PKCS_ERROR;
      }

   /* step 3.b apply RSAEP to integer */
      if (pkcs_RSAEP(n, e, &pt, &pt) != PKCS_OK) {
         mp_clear(&pt);
         return PKCS_ERROR;
      }

   /* step 3.c convert to octet stream with I2OSP */
      if (pkcs_mp_I2OSP(&pt, *cLen, C) != PKCS_OK) {
         mp_clear(&pt);
         return PKCS_ERROR;
      }
      *cLen = mp_unsigned_bin_size(&pt);

   /* clean up */
   mp_clear(&pt);
   return PKCS_OK;
}


#endif /* PKCS */

static const char *ID_TAG = "pkcs.c";



