(*
 * Copyright (c) 2001 Stefan Kral
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *)


type initcodeinstr =
    AddIntOnDemandCode of VSimdBasics.vintreg * P4Basics.p4vinstr list
and riregfileentry =
    IFree
  | IHolds of VSimdBasics.vintreg
  | ITmpHoldsProduct of VSimdBasics.vintreg * int
  | IVarHoldsProduct of VSimdBasics.vintreg * VSimdBasics.vintreg * int
and rsregfileentry = SFree | SHolds of VSimdBasics.vsimdreg
and vsregfileentry =
    SFresh
  | SDead
  | SDying of P4Basics.p4rmmxreg
  | SIn of P4Basics.p4rmmxreg
  | SInAndOut of P4Basics.p4rmmxreg * int
  | SInConst of P4Basics.p4rmmxreg * string
  | SOut of int
  | SConst of string
  | SOnDemand of P4Basics.p4vinstr list
and viregfileentry =
    IFresh
  | IDead
  | IDying of P4Basics.p4rintreg
  | IIn of P4Basics.p4rintreg
  | IInAndOut of P4Basics.p4rintreg * int
  | IInConst of P4Basics.p4rintreg * string
  | IOut of int
  | IConst of string
  | IOnDemand of P4Basics.p4vinstr list

val vsregfileentryIsFresh : vsregfileentry -> bool

val livevsregfileentryToP4rmmxreg :
  vsregfileentry -> P4Basics.p4rmmxreg option

val vsregfileentryToP4memop : vsregfileentry -> P4Basics.p4memop option
val vsregfileentryToP4rmmxreg : vsregfileentry -> P4Basics.p4rmmxreg option

val liveviregfileentryToP4rintreg :
  viregfileentry -> P4Basics.p4rintreg option

val viregfileentryToP4rintreg : viregfileentry -> P4Basics.p4rintreg option

val vsregfileentryToP4rmmxreg' : vsregfileentry -> P4Basics.p4rmmxreg

val viregfileentryToP4rintreg' : viregfileentry -> P4Basics.p4rintreg

val viregWantsIn :
  viregfileentry VSimdBasics.VIntRegMap.t ->
  VSimdBasics.VIntRegMap.key -> bool
val vsregWantsIn :
  vsregfileentry VSimdBasics.VSimdRegMap.t ->
  VSimdBasics.VSimdRegMap.key -> bool

val touchSimdDstReg :
  VSimdBasics.VSimdRegMap.key ->
  vsregfileentry VSimdBasics.VSimdRegMap.t ->
  vsregfileentry VSimdBasics.VSimdRegMap.t
val touchIntDstReg :
  VSimdBasics.VIntRegMap.key ->
  viregfileentry VSimdBasics.VIntRegMap.t ->
  viregfileentry VSimdBasics.VIntRegMap.t

val vsregfileentryIsFresh : vsregfileentry -> bool
val viregfileentryIsFresh : viregfileentry -> bool

val riregfileentryToVireg : riregfileentry -> VSimdBasics.vintreg option

val riregfileentryIsFree : riregfileentry -> bool
