(*
 * Copyright (c) 2001 Stefan Kral
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *)

open List
open Util
open GenUtil
open VSimdBasics
open P4Basics
open P4RegisterAllocationBasics
open P4Translate
open CodeletMisc
open VFpBasics
open AssignmentsToVfpinstrs
open Fft
open Symmetry


let hc2hc_gen n dir =
  let _ = info "generating..." in
  let (zeroth_elements, middle_elements, final_elements) =
    match dir with
      | FORWARD -> 
	  (no_twiddle_gen_expr n real_sym dir,
	   twiddle_dit_gen_expr n no_sym middle_hc2hc_forward_sym dir,
	   no_twiddle_gen_expr (2*n) final_hc2hc_forward_sym dir)
      | BACKWARD ->
	  (no_twiddle_gen_expr n hermitian_sym dir,
	   twiddle_dif_gen_expr n middle_hc2hc_backward_sym no_sym dir,
	   no_twiddle_gen_expr (2*n) final_hc2hc_backward_sym dir)
  and (_, num_twiddles, _) = Twiddle.twiddle_policy () in

  let zeroth_elements' = 
	vect_optimize varinfo_hc2hc_zerothelements n zeroth_elements
  and middle_elements' = 
	vect_optimize varinfo_hc2hc_middleelements n middle_elements
  and final_elements'  = 
	vect_optimize varinfo_hc2hc_finalelements n final_elements in

  let fnarg_inout, fnarg_iostride = P4_MFunArg 1,P4_MFunArg 3
  and fnarg_w,fnarg_m,fnarg_dist = P4_MFunArg 2,P4_MFunArg 4,P4_MFunArg 5 in

  let (inout,iostride1p,iostride4p) = makeNewVintreg3 () 
  and (w,x,y) = makeNewVintreg3 () in

  let initcode = 
	[(iostride4p, [P4V_IntLoadEA(P4V_SID(iostride1p,8,0), iostride4p)])] @
	loadfnargs [(fnarg_inout, inout); 
		    (fnarg_w, w); 
		    (fnarg_iostride, iostride1p)] in
  let initcode' = map (fun (d,xs) -> AddIntOnDemandCode(d,xs)) initcode in

  let (unparser_1, unparser_2) = 
    match dir with
      | FORWARD  -> (strided_hc2hc_unparser_1, strided_hc2hc_unparser_2)
      | BACKWARD -> (strided_hc2hc_unparser_2, strided_hc2hc_unparser_1) in

  let unparser_zeroth_elements =
	make_asm_unparser
	  ([], unparser_1 (inout,inout,iostride4p,n))
	  ([], unparser_2 (inout,inout,iostride4p,n))
	  ([], fail_unparser "hc2hc unparser zeroth elements (TWIDDLE)")
  and unparser_middle_elements =
	make_asm_unparser
	  ([], unparser_1 (x,y,iostride4p,n))
	  ([], unparser_2 (x,y,iostride4p,n))
	  ([], unitstride_complex_unparser w)
  and unparser_final_elements =
	make_asm_unparser
	  ([], unparser_1 (x,y,iostride4p,n))
	  ([], unparser_2 (x,y,iostride4p,n))
	  ([], fail_unparser "hc2hc unparser final elements (TWIDDLE)") in

  let p4vinstrs' = 
	[
	 P4V_IntUnaryOpMem(P4_IShlImm 3, fnarg_dist)	(* dist *= 8 *)
	]  @
	(vsimdinstrsToP4vinstrs unparser_zeroth_elements zeroth_elements') @
	[
	 P4V_RefInts([w]);
	 P4V_IntCpyUnaryOp(P4_ICopy, inout, x);
	 P4V_IntCpyUnaryOp(P4_ICopy, inout, y);
	 P4V_Jump(P4V_BTarget_Named(".LC2"));

	 P4V_Label(".LC1")
	] @
	(vsimdinstrsToP4vinstrs unparser_middle_elements middle_elements') @
	[
	 P4V_IntUnaryOp(P4_IAddImm(num_twiddles n * 16), w);
	 
	 P4V_IntBinOpMem(P4_IAdd, fnarg_dist, x);
	 P4V_IntBinOpMem(P4_ISub, fnarg_dist, y);
	 P4V_IntUnaryOpMem(P4_ISubImm 2, fnarg_m);
	 P4V_CondBranch(P4_BCond_GreaterZero, P4V_BTarget_Named(".LC1"));
	 P4V_CondBranch(P4_BCond_EqualZero, P4V_BTarget_Named(".LC3"));
	 P4V_Jump(P4V_BTarget_Named(".LC4"));

	 P4V_Label(".LC2");
	 P4V_IntBinOpMem(P4_IAdd, fnarg_dist, x);
	 P4V_IntBinOpMem(P4_ISub, fnarg_dist, y);
	 P4V_IntUnaryOpMem(P4_ISubImm 2, fnarg_m);

	 P4V_RefInts([x;y;w]);
	 P4V_CondBranch(P4_BCond_GreaterZero, P4V_BTarget_Named(".LC1"));
	 P4V_CondBranch(P4_BCond_EqualZero, P4V_BTarget_Named(".LC3"));
	 P4V_Jump(P4V_BTarget_Named(".LC4"));
	 P4V_Label(".LC3")
	] @
	(vsimdinstrsToP4vinstrs unparser_final_elements final_elements') @
	[
	 P4V_Label(".LC4")
	] in
  (n, dir, HC2HC, initcode', p4vinstrs')





