
/*
 * Copyright (C) 2002-2003 Stefan Holst
 * Copyright (C) 2004-2005 Maximilian Schwerin
 *
 * This file is part of oxine a free media player.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: otk_button.h 2086 2007-05-20 11:37:57Z mschwerin $
 *
 */

#ifndef HAVE_OTK_BUTTON_H
#define HAVE_OTK_BUTTON_H


/**
 * Creates a new button with a text label.
 */
otk_widget_t *otk_text_button_new (otk_t * otk, int x, int y, int w, int h,
                                   const char *text,
                                   otk_cb_t cb, void *cb_data);


/**
 * Creates a new button with a vector label.
 */
otk_widget_t *otk_vector_button_new (otk_t * otk, int x, int y, int w, int h,
                                     odk_osd_vector_type_t type, int vec_w,
                                     int vec_h, otk_cb_t cb, void *cb_data);

/**
 * Sets the text of this button.
 *
 * @param button                The button object.
 * @param text                  The new text of the label.
 */
void otk_button_set_text (otk_widget_t * button, const char *text);


/**
 * Sets the vector type of this button.
 *
 * @param button                The button object.
 * @param type                  The new vector type.
 */
void otk_button_set_vector (otk_widget_t * button,
                            odk_osd_vector_type_t type);


/**
 * Sets the update callback. This callback is used to update the label of the
 * button.
 *
 * @param button                The button object.
 * @param cb                    The update callback.
 * @param cb_data               The user data that is passed to the callback.
 */
void otk_button_set_update_cb (otk_widget_t * button, otk_update_cb_t cb,
                               void *cb_data);


#endif /* HAVE_OTK_BUTTON_H */
