
/*
 * Copyright (C) 2004-2005 Maximilian Schwerin
 *
 * This file is part of oxine a free media player.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: odk_xk.h 2836 2007-09-25 11:01:41Z mschwerin $
 *
 */

#ifndef HAVE_ODK_XK_H

#include "config.h"

#ifdef HAVE_LIBX11

#include <X11/Xlib.h>
#include <X11/keysym.h>
#include <X11/XF86keysym.h>

#else

/* Data types */
#ifndef KeySym
#define KeySym                  int
#endif

#endif /* HAVE_LIBX11 */

/* Modifier mask */
#ifndef ShiftMask
#define ShiftMask               (1<<0)
#endif
#ifndef ControlMask
#define ControlMask             (1<<2)
#endif
#ifndef Mod1Mask
#define Mod1Mask                (1<<3)
#endif

/* Keys */
#ifndef XK_F1
#define XK_F1                   0xffbe
#endif
#ifndef XK_F2
#define XK_F2                   0xffbf
#endif
#ifndef XK_F3
#define XK_F3                   0xffc0
#endif
#ifndef XK_F4
#define XK_F4                   0xffc1
#endif
#ifndef XK_F5
#define XK_F5                   0xffc2
#endif
#ifndef XK_F6
#define XK_F6                   0xffc3
#endif
#ifndef XK_F7
#define XK_F7                   0xffc4
#endif
#ifndef XK_F8
#define XK_F8                   0xffc5
#endif
#ifndef XK_Help
#define XK_Help                 0xff6a                          /* Help */
#endif
#ifndef XK_h
#define XK_h                    0x0068                          /* U+0068 LATIN SMALL LETTER H */
#endif
#ifndef XK_H
#define XK_H                    0x0048                          /* U+0048 LATIN CAPITAL LETTER H */
#endif
#ifndef XK_question
#define XK_question             0x003f                          /* U+003F QUESTION MARK */
#endif
#ifndef XK_o
#define XK_o                    0x006f                          /* U+006F LATIN SMALL LETTER O */
#endif
#ifndef XK_F9
#define XK_F9                   0xffc6
#endif
#ifndef XK_F10
#define XK_F10                  0xffc7
#endif
#ifndef XK_0
#define XK_0                    0x0030                          /* U+0030 DIGIT ZERO */
#endif
#ifndef XK_KP_0
#define XK_KP_0                 0xffb0
#endif
#ifndef XK_1
#define XK_1                    0x0031                          /* U+0031 DIGIT ONE */
#endif
#ifndef XK_KP_1
#define XK_KP_1                 0xffb1
#endif
#ifndef XK_2
#define XK_2                    0x0032                          /* U+0032 DIGIT TWO */
#endif
#ifndef XK_KP_2
#define XK_KP_2                 0xffb2
#endif
#ifndef XK_3
#define XK_3                    0x0033                          /* U+0033 DIGIT THREE */
#endif
#ifndef XK_KP_3
#define XK_KP_3                 0xffb3
#endif
#ifndef XK_4
#define XK_4                    0x0034                          /* U+0034 DIGIT FOUR */
#endif
#ifndef XK_KP_4
#define XK_KP_4                 0xffb4
#endif
#ifndef XK_5
#define XK_5                    0x0035                          /* U+0035 DIGIT FIVE */
#endif
#ifndef XK_KP_5
#define XK_KP_5                 0xffb5
#endif
#ifndef XK_6
#define XK_6                    0x0036                          /* U+0036 DIGIT SIX */
#endif
#ifndef XK_KP_6
#define XK_KP_6                 0xffb6
#endif
#ifndef XK_7
#define XK_7                    0x0037                          /* U+0037 DIGIT SEVEN */
#endif
#ifndef XK_KP_7
#define XK_KP_7                 0xffb7
#endif
#ifndef XK_8
#define XK_8                    0x0038                          /* U+0038 DIGIT EIGHT */
#endif
#ifndef XK_KP_8
#define XK_KP_8                 0xffb8
#endif
#ifndef XK_9
#define XK_9                    0x0039                          /* U+0039 DIGIT NINE */
#endif
#ifndef XK_KP_9
#define XK_KP_9                 0xffb9
#endif
#ifndef XK_z
#define XK_z                    0x007a                          /* U+007A LATIN SMALL LETTER Z */
#endif
#ifndef XK_y
#define XK_y                    0x0079                          /* U+0079 LATIN SMALL LETTER Y */
#endif
#ifndef XK_Z
#define XK_Z                    0x005a                          /* U+005A LATIN CAPITAL LETTER Z */
#endif
#ifndef XK_Y
#define XK_Y                    0x0059                          /* U+0059 LATIN CAPITAL LETTER Y */
#endif
#ifndef XK_x
#define XK_x                    0x0078                          /* U+0078 LATIN SMALL LETTER X */
#endif
#ifndef XK_X
#define XK_X                    0x0058                          /* U+0058 LATIN CAPITAL LETTER X */
#endif
#ifndef XK_c
#define XK_c                    0x0063                          /* U+0063 LATIN SMALL LETTER C */
#endif
#ifndef XK_C
#define XK_C                    0x0043                          /* U+0043 LATIN CAPITAL LETTER C */
#endif
#ifndef XK_r
#define XK_r                    0x0072                          /* U+0072 LATIN SMALL LETTER R */
#endif
#ifndef XK_R
#define XK_R                    0x0052                          /* U+0052 LATIN CAPITAL LETTER R */
#endif
#ifndef XK_t
#define XK_t                    0x0074                          /* U+0074 LATIN SMALL LETTER T */
#endif
#ifndef XK_T
#define XK_T                    0x0054                          /* U+0054 LATIN CAPITAL LETTER T */
#endif
#ifndef XK_v
#define XK_v                    0x0076                          /* U+0076 LATIN SMALL LETTER V */
#endif
#ifndef XK_plus
#define XK_plus                 0x002b                          /* U+002B PLUS SIGN */
#endif
#ifndef XK_KP_Add
#define XK_KP_Add               0xffab
#endif
#ifndef XF86XK_AudioRaiseVolume
#define XF86XK_AudioRaiseVolume 0x1008FF13
#endif
#ifndef XK_V
#define XK_V                    0x0056                          /* U+0056 LATIN CAPITAL LETTER V */
#endif
#ifndef XK_minus
#define XK_minus                0x002d                          /* U+002D HYPHEN-MINUS */
#endif
#ifndef XK_KP_Subtract
#define XK_KP_Subtract          0xffad
#endif
#ifndef XF86XK_AudioLowerVolume
#define XF86XK_AudioLowerVolume 0x1008FF11
#endif
#ifndef XK_m
#define XK_m                    0x006d                          /* U+006D LATIN SMALL LETTER M */
#endif
#ifndef XF86XK_AudioMute
#define XF86XK_AudioMute        0x1008FF12
#endif
#ifndef XF86XK_AudioPlay
#define XF86XK_AudioPlay        0x1008FF14
#endif
#ifndef XF86XK_AudioPause
#define XF86XK_AudioPause       0x1008FF31
#endif
#ifndef XK_Pause
#define XK_Pause                0xff13                          /* Pause, hold */
#endif
#ifndef XK_s
#define XK_s                    0x0073                          /* U+0073 LATIN SMALL LETTER S */
#endif
#ifndef XK_S
#define XK_S                    0x0053                          /* U+0053 LATIN CAPITAL LETTER S */
#endif
#ifndef XF86XK_AudioStop
#define XF86XK_AudioStop        0x1008FF15
#endif
#ifndef XK_Left
#define XK_Left                 0xff51                          /* Move left, left arrow */
#endif
#ifndef XK_Page_Up
#define XK_Page_Up              0xff55
#endif
#ifndef XK_p
#define XK_p                    0x0070                          /* U+0070 LATIN SMALL LETTER P */
#endif
#ifndef XK_P
#define XK_P                    0x0050                          /* U+0050 LATIN CAPITAL LETTER P */
#endif
#ifndef XF86XK_AudioPrev
#define XF86XK_AudioPrev        0x1008FF16
#endif
#ifndef XK_Right
#define XK_Right                0xff53                          /* Move right, right arrow */
#endif
#ifndef XK_Page_Down
#define XK_Page_Down            0xff56
#endif
#ifndef XK_n
#define XK_n                    0x006e                          /* U+006E LATIN SMALL LETTER N */
#endif
#ifndef XK_N
#define XK_N                    0x004e                          /* U+004E LATIN CAPITAL LETTER N */
#endif
#ifndef XF86XK_AudioNext
#define XF86XK_AudioNext        0x1008FF17
#endif
#ifndef XK_Up
#define XK_Up                   0xff52                          /* Move up, up arrow */
#endif
#ifndef XK_Down
#define XK_Down                 0xff54                          /* Move down, down arrow */
#endif
#ifndef XK_e
#define XK_e                    0x0065                          /* U+0065 LATIN SMALL LETTER E */
#endif
#ifndef XK_E
#define XK_E                    0x0045                          /* U+0045 LATIN CAPITAL LETTER E */
#endif
#ifndef XF86XK_Eject
#define XF86XK_Eject            0x1008FF2C
#endif
#ifndef XK_a
#define XK_a                    0x0061                          /* U+0061 LATIN SMALL LETTER A */
#endif
#ifndef XK_A
#define XK_A                    0x0041                          /* U+0041 LATIN CAPITAL LETTER A */
#endif
#ifndef XK_i
#define XK_i                    0x0069                          /* U+0069 LATIN SMALL LETTER I */
#endif
#ifndef XK_I
#define XK_I                    0x0049                          /* U+0049 LATIN CAPITAL LETTER I */
#endif
#ifndef XK_O
#define XK_O                    0x004f                          /* U+004F LATIN CAPITAL LETTER O */
#endif
#ifndef XK_Home
#define XK_Home                 0xff50
#endif
#ifndef XK_End
#define XK_End                  0xff57                          /* EOL */
#endif
#ifndef XK_space
#define XK_space                0x0020                          /* U+0020 SPACE */
#endif
#ifndef XK_Return
#define XK_Return               0xff0d                          /* Return, enter */
#endif
#ifndef XK_Tab
#define XK_Tab                  0xff09
#endif
#ifndef XK_Escape
#define XK_Escape               0xff1b
#endif
#ifndef XK_BackSpace
#define XK_BackSpace            0xff08                          /* Back space, back char */
#endif
#ifndef XK_f
#define XK_f                    0x0066                          /* U+0066 LATIN SMALL LETTER F */
#endif
#ifndef XK_F
#define XK_F                    0x0046                          /* U+0046 LATIN CAPITAL LETTER F */
#endif
#ifndef XK_M
#define XK_M                    0x004d                          /* U+004D LATIN CAPITAL LETTER M */
#endif
#ifndef XK_q
#define XK_q                    0x0071                          /* U+0071 LATIN SMALL LETTER Q */
#endif
#ifndef XK_Delete
#define XK_Delete               0xffff                          /* Delete, rubout */
#endif
#ifndef XK_Insert
#define XK_Insert               0xff63                          /* Insert, insert here */
#endif
#ifndef XK_l
#define XK_l                    0x006c                          /* U+006C LATIN SMALL LETTER L */
#endif
#ifndef XF86XK_AudioRecord
#define XF86XK_AudioRecord      0x1008FF1C
#endif
#ifndef XK_Shift_L
#define XK_Shift_L              0xffe1                          /* Left shift */
#endif
#ifndef XK_d
#define XK_d                    0x0064                          /* U+0064 LATIN SMALL LETTER D */
#endif
#ifndef XK_D
#define XK_D                    0x0044                          /* U+0044 LATIN CAPITAL LETTER D */
#endif
#ifndef XK_k
#define XK_k                    0x006b                          /* U+006B LATIN SMALL LETTER K */
#endif
#ifndef XK_K
#define XK_K                    0x004b                          /* U+004B LATIN CAPITAL LETTER K */
#endif
#ifndef XK_u
#define XK_u                    0x0075                          /* U+0075 LATIN SMALL LETTER U */
#endif
#ifndef XK_U
#define XK_U                    0x0055                          /* U+0055 LATIN CAPITAL LETTER U */
#endif
#ifndef XK_w
#define XK_w                    0x0077                          /* U+0077 LATIN SMALL LETTER W */
#endif
#ifndef XK_W
#define XK_W                    0x0057                          /* U+0057 LATIN CAPITAL LETTER W */
#endif
#ifndef XK_b
#define XK_b                    0x0062                          /* U+0062 LATIN SMALL LETTER B */
#endif
#ifndef XK_B
#define XK_B                    0x0042                          /* U+0042 LATIN CAPITAL LETTER B */
#endif

#endif /* HAVE_ODK_XK_H */
