
/*
 * Copyright (C) 2004-2005 Maximilian Schwerin
 *
 * This file is part of oxine a free media player.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Thanks goes to Florian Echtler for adding Xinerama support.
 *
 * $Id: odk_keymap.h 1802 2007-02-05 22:12:57Z mschwerin $
 *
 */

#ifndef HAVE_ODK_KEYMAP_H
#define HAVE_ODK_KEYMAP_H
#ifdef __cplusplus
extern "C" {
#endif

#ifdef HAVE_LIBX11
#include <X11/Xlib.h>
#endif

#include "event.h"
#include "odk_xk.h"

int odk_keymap_kbd2action (oxine_event_t * event, KeySym kbd_key, int kbd_modifier);
int odk_keymap_lirc2action (oxine_event_t *event, char *lirc_action);

#ifdef __cplusplus
}
#endif
#endif /* HAVE_ODK_KEYMAP_H */
