dnl
dnl checking for youtube
dnl
AC_DEFUN([AC_CHECK_YOUTUBE], [
    AC_ARG_ENABLE([youtube], 
                  AC_HELP_STRING([--disable-youtube], 
                                 [do not activate YouTube support]),
                  [enable_youtube=$enableval], [enable_youtube=yes])

    if test x"$enable_youtube" = xyes; then
        AC_CHECK_CURL

        if test "$have_curl" = "yes"; then
            AC_DEFINE([HAVE_YOUTUBE], [1], [Define this if you want to enable YouTube support and have libcurl installed.])
            have_youtube=yes
        else
            AC_MSG_WARN([])
            AC_MSG_WARN([Please install the CURL library if you wish to use the YouTube plugin.])
            AC_MSG_WARN([])
            have_youtube=no
        fi
    fi
])
