dnl
dnl checking for HAL
dnl
AC_DEFUN([AC_CHECK_HAL], [
    AC_ARG_ENABLE([hal], 
                  AC_HELP_STRING([--disable-hal], 
                                 [do not activate HAL support]),
                  [enable_hal=$enableval], [enable_hal=yes])

    have_hal=no
    if test x"$enable_hal" = xyes; then
        PKG_CHECK_MODULES(HAL, [hal-storage >= 0.2, dbus-glib-1 >= 0.20],
                          [have_hal=yes], [have_hal=no])
        if test "$have_hal" = "yes" ; then
            AC_DEFINE(HAVE_HAL, 1, [defined if using libhal])
        fi
    fi

    AC_SUBST(HAL_LIBS)
    AC_SUBST(HAL_CFLAGS)
])
