
/*
 * Copyright (C) 2004-2005 Maximilian Schwerin
 *
 * This file is part of oxine a free media player.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: oxine-createGUI.c 2528 2007-07-17 13:19:49Z mschwerin $
 *
 */
#include "config.h"

#include <ctype.h>
#include <libintl.h>
#include <locale.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#ifdef ENABLE_NLS
#    include <libintl.h>
#      define _(String) gettext (String)
#    ifdef gettext_noop
#        define N_(String) gettext_noop (String)
#    else
#        define N_(String) (String)
#    endif
#else

/* Stubs that do something close enough.  */
#    define textdomain(String) (String)
#    define gettext(String) (String)
#    define dgettext(Domain,Message) (Message)
#    define dcgettext(Domain,Message,Type) (Message)
#    define bindtextdomain(Domain,Directory) (Domain)
#    define _(String) (String)
#    define N_(String) (String)
#endif

#define COLOR   "6989bd"

typedef struct {
    char *header;
    char *filename;
} header_menu_t;

int
main (int argc, char **argv)
{
#ifdef HAVE_IMAGE_TOOLS
    // set up internationalization
#ifdef HAVE_SETLOCALE
    setlocale (LC_ALL, "");
#endif

    bindtextdomain (PACKAGE, OXINE_LOCALEDIR);
    textdomain (PACKAGE);

    header_menu_t header_menus[] = {
        {_("Help"), "menu_help.png"},
        {_("Films"), "menu_video.png"},
        {_("Music"), "menu_music.png"},
        {_("Images"), "menu_image.png"},
        {_("Media"), "menu_media.png"},
        {_("Playlist"), "menu_playlist.png"},
        {_("Subtitles"), "menu_subtitle.png"},
        {_("Settings"), "menu_settings.png"},
        {_("Weather"), "menu_weather.png"},
        {_("CD Extractor"), "menu_extractor.png"},
        {NULL, NULL}
    };

    if (argc < 2) {
        printf ("\nUsage %s <filename>\n\n", argv[0]);
        abort ();
    }

    int i;
    for (i = 1; i < argc; i++) {
        int j = 0;
        while (header_menus[j].filename) {
            if (strcmp (header_menus[j].filename, argv[i]) == 0)
                break;
            j++;
        }

        if (!header_menus[j].filename) {
            printf ("Could not create %s\n", argv[i]);
            continue;
        }

        printf ("Creating %s ...\n", header_menus[j].filename);

        char cmd[2048];
        char *_cmd = cmd;
        sprintf (_cmd, BIN_CONVERT
                 " -size 500x100 xc:none "
                 " -fill blue" " -draw 'line 15,0 15,99'" " -fill black");
        _cmd = (char *) _cmd + strlen (_cmd);

        char *header = strdup (header_menus[j].header);
        char *word = strtok (header, " ");
        while (word) {
            char *word_upper = strdup (word);
            int k = 0;
            for (; k < strlen (word_upper); k++)
                word_upper[k] = toupper (word_upper[k]);

            sprintf (_cmd,
                     " \\( -clone 0"
                     " -font SansBold.ttf"
                     " -pointsize %d"
                     " -fill '#%s'"
                     " -annotate +5+60 \"  %c\" \\) ",
                     (word[0] != word_upper[0]) ? 50 : 60,
                     COLOR, word_upper[0]);
            _cmd = (char *) _cmd + strlen (_cmd);

            sprintf (_cmd,
                     " \\( -clone 0"
                     " -font SansBold.ttf "
                     " -pointsize 50"
                     " -fill '#%s'"
                     " -annotate +5+60 \" %s\" \\) ", COLOR,
                     (char *) (word_upper + 1));
            _cmd = (char *) _cmd + strlen (_cmd);

            word = strtok (NULL, " ");
        }
        sprintf (_cmd,
                 " -delete 0 -trim +repage +append"
                 " -fill none -opaque blue -trim +repage"
                 " -background transparent -flatten"
                 " /tmp/header-%s", header_menus[j].filename);
        printf ("%s\n", cmd);
        if (system (cmd) != 0) {
            printf ("ERROR: Could not execute command %s\n", cmd);
            abort ();
        }

        _cmd = cmd;
        sprintf (_cmd,
                 BIN_COMPOSITE
                 " -compose atop -depth 8 -geometry +0+0 header-all.png background.png %s",
                 header_menus[j].filename);
        printf ("%s\n", cmd);
        if (system (cmd) != 0) {
            printf ("ERROR: Could not execute command %s\n", cmd);
            abort ();
        }

        _cmd = cmd;
        sprintf (_cmd,
                 BIN_COMPOSITE
                 " -compose atop -depth 8 -geometry +20+540"
                 " -gravity SouthWest /tmp/header-%s %s %s",
                 header_menus[j].filename,
                 header_menus[j].filename, header_menus[j].filename);
        printf ("%s\n", cmd);
        if (system (cmd) != 0) {
            printf ("ERROR: Could not execute command %s\n", cmd);
            abort ();
        }
    }

    return 0;
#else
    printf ("Please install mjpegtools, netpbm and "
            "imagemagic to use this tool!\n");
    return 1;
#endif
}
