
/*
 * Copyright (C) 2002-2003 Stefan Holst
 * Copyright (C) 2004-2005 Maximilian Schwerin
 *
 * This file is part of oxine a free media player.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: oxine.h,v 1.43 2006/01/17 13:55:53 mschwerin Exp $
 *
 */

#ifndef HAVE_OXINE_H
#define HAVE_OXINE_H

#include "filelist.h"
#include "odk.h"
#include "otk.h"
#include "playlist.h"

#ifndef FALSE
#define FALSE 0
#endif
#ifndef TRUE
#define TRUE 1
#endif

typedef struct oxine_s oxine_t;

struct oxine_s {
    xine_t *xine;

    otk_t *otk;
    odk_t *odk;

#ifdef HAVE_DISC_POLLING
    int use_polling;
#endif

    int otk_clear_job;

    /* This is 1 whenever a gui is visible, that the user can interact with. */
    int user_interface_is_visible;
    /* This is 1 whenever the controls are visible. */
    int control_menu_is_visible;

    /* The playlist */
    playlist_t *playlist;

    /* A list of removable discs present in the system */
    filelist_t *removable_discs;

    /* The filelists */
    filelist_t *toplevel_filelist;
    filelist_t *current_filelist;
    filelist_t *mostlistened_filelist;

    /* This is used to get back to the filelist menu associated with the
     * current file type. */
    otk_button_cb_t filelist_menu;

    /* This is called to get back to the previous menu. */
    otk_button_cb_t backto_menu;

    /* This is called to repaint the currently visible menu. This can also be
     * clean_otk_stuff. */
    otk_button_cb_t repaint_menu;

    /* This is called when playback ends. */
    otk_button_cb_t playback_ended_menu;

    pthread_mutex_t download_mutex;
};
#endif
