
/*
 * Copyright (C) 2004-2005 Maximilian Schwerin
 *
 * This file is part of oxine a free media player.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: gui_utils.h,v 1.12 2006/01/08 15:40:02 mschwerin Exp $
 *
 */

#ifndef _GUI_UTILS_H
#define _GUI_UTILS_H



#include "oxine.h"
#include "playlist.h"

void set_time_string (void *oxine_p, otk_widget_t * widget);
void set_status_string (void *oxine_p, otk_widget_t * widget);

void clean_otk_stuff (void *oxine_p);

void show_stream_parameter (oxine_t * oxine, odk_stream_param_t param);

void show_stream_speed (oxine_t * oxine);
void show_stream_lang (oxine_t * oxine);
void show_stream_spu (oxine_t * oxine);
void show_deinterlace (oxine_t * oxine);
void show_aspect_ratio (oxine_t * oxine);
void show_mute (oxine_t * oxine);

void
  show_xine_param (oxine_t * oxine, int param, int devideby, const char *format, const char *param_name);

void show_message (oxine_t * oxine, char *message);
void show_message_ok (oxine_t * oxine, char *message, otk_button_cb_t ok_cb);
void show_message_ok_cancel (oxine_t * oxine, char *message,
                             otk_button_cb_t ok_cb,
                             otk_button_cb_t cancel_cb);

#define show_error(oxine,message,ok_cb) (show_message_ok(oxine,message,ok_cb))
#define please_wait(oxine) (show_message(oxine, _("Please wait...")))
#define could_not_play(oxine, ok_cb, cancel_cb) (show_message_ok_cancel(oxine, _("Could not play title!"), ok_cb, cancel_cb))

void playlist_play_first (oxine_t * oxine);
void playlist_play_prev (oxine_t * oxine);
void playlist_play_next (oxine_t * oxine);
void playlist_play_item (oxine_t * oxine, playitem_t * playitem);

#endif
