<?php

/**
 * import_users.php
 * 
 * Author: Steve Bourgeois <owl@bozzit.com>
 * Project Founder: Chris Vincent <cvincent@project802.net>
 *
 * Copyright (c) 1999-2005 The Owl Project Team
 * Licensed under the GNU GPL. For full terms see the file COPYING.
 */

require_once(dirname(dirname(__FILE__)) . "/config/owl.php");
require_once($default->owl_fs_root . "/lib/Net_CheckIP/CheckIP.php");
require_once($default->owl_fs_root . "/lib/disp.lib.php");
require_once($default->owl_fs_root . "/lib/owl.lib.php");
require_once($default->owl_fs_root . "/lib/security.lib.php");
include_once($default->owl_fs_root . "/lib/header.inc");
include_once($default->owl_fs_root . "/lib/userheader.inc");

if (!fIsAdmin(true))
{
   die("$owl_lang->err_unauthorized");
} 

if (!empty($userfile))
{
   $userfile = uploadCompat("userfile");
}

print("<center>");
print("<table class=\"border1\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\" width=\"$default->table_expand_width\"><tr><td align=\"left\" valign=\"top\" width=\"100%\">\n");
fPrintButtonSpace(12, 1);
print("<br />\n");
print("<table class=\"border2\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\" width=\"100%\"><tr><td align=\"left\" valign=\"top\" width=\"100%\">\n");

if ($default->show_prefs == 1 or $default->show_prefs == 3)
{
   fPrintPrefs("infobar1", "top");
}

fPrintButtonSpace(12, 1);
print("<br />\n");

fPrintAdminPanel("importusers");

print("<form enctype=\"multipart/form-data\" action=\"" . $_SERVER["PHP_SELF"] ."\" method=\"post\">\n");
print("<input type=\"hidden\" name=\"sess\" value=\"$sess\"></input>");
print("<table class=\"margin2\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\" width=\"100%\">\n");
fPrintSectionHeader($owl_lang->header_csv_import, "admin2");
print("<tr>\n");
print("<td align=\"left\" valign=\"top\">\n");
print("<table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" width=\"100%\">\n");
print("<tr>\n");
print("<td class=\"form1\">$owl_lang->sendcsvfile:</td>\n");
print("<td class=\"form1\" width=\"100%\"><input class=\"finput1\" type=\"file\" name=\"userfile\" size=\"24\" maxlength=\"512\"></input></td>\n");
print("</tr>\n");
print("<td class=\"form1\">");
fPrintButtonSpace(1, 1);
print("</td>\n");
print("<td class=\"form2\" width=\"100%\">");
fPrintSubmitButton($owl_lang->sendfile, $owl_lang->alt_sendfile, "submit", "send_file_x");
fPrintSubmitButton($owl_lang->btn_reset, $owl_lang->alt_reset_form, "reset");
print("</td>\n");
print("</tr>\n");

if (!empty($userfile))
{
   define( 'GROUPID', '0');
   define( 'USERNAME', '1');
   define( 'FULLNAME', '2');
   define( 'PASSWORD', '3');
    
   $handle = fopen ($userfile["tmp_name"],"r");
   $qSQL = new OWL_db;
   $dNowDate = $qSQL->now();
   $row = 0;
   $CountLines = 0;
   
   while ($data = fgetcsv ($handle, 5000, ",")) 
   {
      if ($row == 0)
      {
         $row++;
         continue;
      } 
      $CountLines++;
      $PrintLines = $CountLines % 2;
      if ($PrintLines == 0)
      {
         $sTrClass = "file1";
      }
      else
      {
         $sTrClass = "file2";
      }

      $query = "INSERT INTO $default->owl_users_table (login_failed, passwd_last_changed, lastlogin,curlogin,groupid,username,name,password,quota_max,quota_current,email,notify,attachfile,disabled,noprefaccess,language,maxsessions,newsadmin,comment_notify,buttonstyle,homedir,firstdir,email_tool, change_paswd_at_login, expire_account, user_auth, logintonewrec) VALUES ('0', $dNowDate, $dNowDate, $dNowDate, ";
   
      $num = count ($data);
   
      //print "<p> $num fields in line $row: <br>\n";
      $row++;
      $bSkipUser = false;
      for ($c=0; $c < $num; $c++)  
      {
         if ($c > GROUPID )
         {
            $query .= ", ";
         }
   
         if ( $c == GROUPID )
         {
            if (is_numeric($data[$c]))
            {
               $qSQL->query("SELECT * FROM $default->owl_groups_table WHERE id = '$data[$c]'");
               if ($qSQL->num_rows() == 0)
               {
                  $sMessage = $owl_lang->invalid_groupid . "'$data[$c]'";
                  $bSkipUser = true;
               }
            }
            else
            {
               $qSQL->query("SELECT * FROM $default->owl_groups_table WHERE name = '$data[$c]'");
               if ($qSQL->num_rows() == 0)
               {
                  $qSQL->query("INSERT INTO $default->owl_groups_table (name) VALUES ('$data[$c]')");
                  print("<tr>\n");
                  print("<td class=\"$sTrClass\">$owl_lang->group_create</td>\n");
                  print("<td class=\"$sTrClass\" width=\"100%\">$data[$c]</td>\n");
                  print("</tr>\n");
                  $data[$c] = $qSQL->insert_id($default->owl_groups_table, 'id');
                  $CountLines++;
                  $PrintLines = $CountLines % 2;
                  if ($PrintLines == 0)
                  {
                     $sTrClass = "file1";
                  }
                  else
                  {
                     $sTrClass = "file2";
                  }
               }
               else
               {
                  $qSQL->next_record();
                  $data[$c] = $qSQL->f("id");
               }
            }
         }
         elseif ( $c == PASSWORD )
         {
            $data[$c] = md5($data[$c]);
         }
         elseif ( $c == USERNAME )
         {
            $sUserName = $data[$c];
            $qSQL->query("SELECT * FROM $default->owl_users_table WHERE username = '$sUserName'");
            if ($qSQL->num_rows() > 0)
            {
                  $bSkipUser = true;
                  $sMessage = $owl_lang->msg_user_exists;
            }
         }
         elseif ( $c == FULLNAME )
         {
            $sFullName = $data[$c];
         }
         $newdata = ereg_replace("'","\'",$data[$c]);
         $query .= "'$newdata'";
       }
       $query .= ")";
   
       print("<tr>\n");
       print("<td class=\"$sTrClass\">$owl_lang->user_created_skipped</td>\n");
       if (!$bSkipUser)
       {
          $qSQL->query($query);
          print("<td class=\"$sTrClass\" width=\"100%\">$sUserName ($sFullName) $owl_lang->import_inserted</td>\n");
       }
       else
       {
          print("<td class=\"$sTrClass\" width=\"100%\">$sUserName ($sFullName) $owl_lang->import_skipped $sMessage</td>\n");
       }
       print("</tr>\n");
    
   }
   fclose ($handle);
   unlink($userfile["tmp_name"]);
}
print("</table>\n");
print("</td></tr></table>\n");
print("</form>\n");

fPrintButtonSpace(12, 1);
if ($default->show_prefs == 2 or $default->show_prefs == 3)
{
   fPrintPrefs("infobar2");
}
print("</td></tr></table>\n");
print("</center>");

include($default->owl_fs_root .  "/lib/footer.inc");

?>
