/**
 * Copyright (C) 2001-2005 France Telecom R&D
 */
package org.objectweb.util.ant;

import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;

import java.util.Arrays;
import java.util.List;

/**
 * This tool class helps the use of DirectoryScanner.
 *
 * @author S.Chassande-Barrioz
 */
public class DirectoryScannerHelper  {

    /**
     * Extract selected files from a matching task.
     * @param mt is the matching task
     * @param root is the file descriptor of the root directory
     * @return a collection of String corresponding to selected files
     */
    public static List getSelectedFiles(DirectoryScanner ds, Project project) {
        List result = Arrays.asList(ds.getIncludedFiles());
        if (project != null) {
            project.log("includes=" + result.toString(), Project.MSG_DEBUG);
        }
    	List toDeselect = Arrays.asList(ds.getExcludedFiles());
        if (project != null) {
            project.log("excludes=" + toDeselect.toString(), Project.MSG_DEBUG);
        }
        result.removeAll(toDeselect);
        if (project != null) {
            project.log("selected=" + toDeselect.toString(), Project.MSG_DEBUG);
        }
        return result;
    }
    
    /**
     * Extract selected files from a matching task.
     * @param mt is the matching task
     * @param root is the file descriptor of the root directory
     * @return an array of String corresponding to selected files
     */
    public static String[] getSelectedFilesAsString(DirectoryScanner ds, Project project) {
        return (String[]) getSelectedFiles(ds, project).toArray(new String[0]);
    }    

    /**
     * Extract selected directories from a matching task.
     * @param mt is the matching task
     * @param root is the file descriptor of the root directory
     * @return a collection of String corresponding to selected directories
     */
    public static List getSelectedDirectories(DirectoryScanner ds, Project project) {
        List result = Arrays.asList(ds.getIncludedDirectories());
        if (project != null) {
            project.log("includes=" + result.toString(), Project.MSG_DEBUG);
        }
    	List toDeselect = Arrays.asList(ds.getExcludedDirectories());
        if (project != null) {
            project.log("excludes=" + toDeselect.toString(), Project.MSG_DEBUG);
        }
        result.removeAll(toDeselect);
        if (project != null) {
            project.log("selected=" + toDeselect.toString(), Project.MSG_DEBUG);
        }
        return result;
    }
    
    /**
     * Extract selected directories from a matching task.
     * @param mt is the matching task
     * @param root is the file descriptor of the root directory
     * @return an array of String corresponding to selected directories
     */
    public static String[] getSelectedDirectoriesAsString(DirectoryScanner ds, Project project) {
        return (String[]) getSelectedFiles(ds, project).toArray(new String[0]);
    }    

}
