/**
  @file devlist.h

  @author Johan Hedberg <johan.hedberg@nokia.com>

  Copyright (C) 2006 Nokia Corporation. All rights reserved.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License, version 2, as
  published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA

*/  
#ifndef _DEVLIST_H_
#define _DEVLIST_H_

#include <stdint.h>
#include <dbus/dbus.h>

typedef struct {
    const char     *bda;
    const char     *name;
    uint8_t         cls[3];
    unsigned char   rssi;
    uint16_t        clock;
} DevInfo;

/** Start the inquiry process
 * @param receiver D-BUS address of the list receiver
 * @returns TRUE on success, FALSE on failure
 */
gboolean init_search(const char *receiver);

/** Stop an ongoing search */
void stop_search(void);

/** Send dev_found D-BUS signal
 * @param connection D-BUS connection to use
 * @param dev        Device info
 * @returns TRUE on success, FALSE on failure
 */
gboolean send_dbus_dev_found(DBusConnection *connection, DevInfo *dev);

/** Send search_complete D-BUS signal
 * @param connection D-BUS connection to use
 * @returns TRUE on success, FALSE on failure
 */
gboolean send_dbus_search_complete(DBusConnection *connection);

/** Check if a search is in progress
 * @returns TRUE if search is in progress, else FALSE
 */
gboolean search_in_progress(void);

/** Callback to notify that the list receiver has exited
 * @param connection D-BUS connection
 * @param message    Service exited signal
 * @param user_data  Optional user data
 * @returns DBUS_HANDLER_RESULT_HANDLED if the list receiver exited
 */
DBusHandlerResult name_exit_filter(DBusConnection *connection,
                                   DBusMessage *message,
                                   void *user_data);

#endif /* _DEVLIST_H_ */
