/*
 *      ESS Technology allegro audio driver.
 *
 *      Copyright (C) 1992-2000  Don Kim (don.kim@esstech.com)
 *
 */
#ifndef __SRCMGR_H
#define __SRCMGR_H

typedef enum
{
  KSSTATE_STOP,
  /*KSSTATE_ACQUIRE, */
  /*KSSTATE_PAUSE, */
  KSSTATE_RUN
}
KSSTATE, *PKSSTATE;

/* -------------------------------------------------------------------------- */

typedef struct
{
  ULONG Physical;
  ULONG Length;
}
MBUFFER, *PMBUFFER;

typedef struct
{
  BYTE WaveType;
  BOOLEAN Format16Bit;
  BOOLEAN FormatStereo;
  BOOLEAN SR_8khzFlag;
  KSSTATE State;
  ULONG Frequency;
  ULONG Length;
  PMBUFFER Buffer;

  /* DSP kernel support */
  PCLIENT_INST DspClientInstance;
  USHORT wFreqIndex;
  USHORT wSRC3VarLen;
  ULONG StreamType;
  ULONG PositionBeforePaused;
}
ALLEGRO_WAVE, *PALLEGRO_WAVE;


#define WAVE_PLAYBACK  0
#define WAVE_CAPTURE   1
#define WAVE_MIXER     2

extern PALLEGRO_WAVE CaptureStream;
extern PALLEGRO_WAVE PlaybackStream;
extern PALLEGRO_WAVE MidiStream;


/*void AllocateStream ( BYTE waveType, PWAVE_INFO waveFormat ); */
void InitStream ();
void AllocateStream (allegro_devc * devc, BYTE waveType);
void FreeStream (allegro_devc * devc, PALLEGRO_WAVE AllegroWave);
ULONG SRCMGR_GetPosition (allegro_devc * devc, PALLEGRO_WAVE AllegroWave);
void SetFormat (allegro_devc * devc, PALLEGRO_WAVE AllegroWave,
		PWAVE_INFO waveFormat);
/*void SetState ( struct ess_state *s, PALLEGRO_WAVE AllegroWave, KSSTATE NewState ); */
void
SRCMGR_SetVolume (allegro_devc * devc, IN PCLIENT_INST client, IN USHORT left,
		  IN USHORT right);
void SRCMGR_SetRearVolume (allegro_devc * devc, IN PCLIENT_INST client,
			   IN USHORT left, IN USHORT right);
void SRCMGR_SetPassThruVolume (allegro_devc * devc, IN PPASSTHRU client,
			       IN USHORT left, IN USHORT right);
void SRCMGR_SetPassThruRearVolume (allegro_devc * devc, IN PPASSTHRU client,
				   IN USHORT left, IN USHORT right);
/*#include "src3pbc.h" */
short SRC3_PB_COEFF_HALF[5][666] = {


#if 0
  /* src3.5 44.1 khz */
  {0, -1, 2, -6, 13, -26, 48, -83, 135, -212, 326, -497, 776, -1325, 3084,
   15636, -2172, 1090, -665, 431, -283, 183, -115, 70, -40, 21, -10, 4, -2, 0,
   0, -1, 4, -9, 20, -40, 72, -122, 199, -311, 477, -728, 1142, -1975, 4859,
   14731, -2854, 1472, -906, 588, -386, 250, -157, 94, -54, 28, -14, 6, -2, 0,
   0, -1, 5, -12, 26, -51, 92, -156, 253, -395, 605, -924, 1456, -2555, 6712,
   13518, -3263, 1725, -1069, 696, -456, 294, -184, 111, -63, 33, -16, 7, -2,
   1, 0, -2, 6, -14, 31, -60, 108, -182, 293, -457, 699, -1068, 1692, -3017,
   8574, 12046, -3408, 1842, -1149, 749, -491, 316, -197, 118, -66, 35, -16,
   7, -2, 1, 0, -2, 6, -16, 34, -65, 117, -196, 315, -490, 749, -1147, 1827,
   -3315, 10376, 10376, -3315, 1827, -1147, 749, -490, 315, -196, 117, -65,
   34, -16, 6, -2, 0, 1, -2, 7, -16, 35, -66, 118, -197, 316, -491, 749,
   -1149, 1842, -3408, 12046, 8574, -3017, 1692, -1068, 699, -457, 293, -182,
   108, -60, 31, -14, 6, -2, 0, 1, -2, 7, -16, 33, -63, 111, -184, 294, -456,
   696, -1069, 1725, -3263, 13518, 6712, -2555, 1456, -924, 605, -395, 253,
   -156, 92, -51, 26, -12, 5, -1, 0, 0, -2, 6, -14, 28, -54, 94, -157, 250,
   -386, 588, -906, 1472, -2854, 14731, 4859, -1975, 1142, -728, 477, -311,
   199, -122, 72, -40, 20, -9, 4, -1, 0, 0, -2, 4, -10, 21, -40, 70, -115,
   183, -283, 431, -665, 1090, -2172, 15636, 3084, -1325, 776, -497, 326,
   -212, 135, -83, 48, -26, 13, -6, 2, -1, 0, 0, -1, 2, -6, 12, -22, 38, -62,
   98, -152, 231, -358, 591, -1215, 16195, 1447, -652, 386, -248, 163, -106,
   67, -41, 24, -13, 6, -3, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   16384, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, -3, 6, -13,
   24, -41, 67, -106, 163, -248, 386, -652, 1447, 16195, -1215, 591, -358,
   231, -152, 98, -62, 38, -22, 12, -6, 2, -1, 0},
#else	/* if */	 /* src3.6 44.1 khz */
  {0,
   -2,
   9,
   -30,
   78,
   -176,
   364,
   -743,
   1859,
   16060,
   -1459,
   633,
   -312,
   149,
   -64,
   23,
   -7,
   1,
   0,
   -4,
   17,
   -54,
   141,
   -315,
   647,
   -1329,
   3466,
   15404,
   -2260,
   1004,
   -495,
   235,
   -100,
   36,
   -10,
   2,
   0,
   -5,
   25,
   -79,
   202,
   -448,
   918,
   -1897,
   5200,
   14423,
   -2803,
   1269,
   -627,
   296,
   -125,
   44,
   -12,
   2,
   1,
   -8,
   33,
   -102,
   258,
   -566,
   1156,
   -2406,
   7004,
   13158,
   -3095,
   1425,
   -703,
   330,
   -137,
   47,
   -12,
   2,
   1,
   -9,
   40,
   -122,
   302,
   -658,
   1339,
   -2813,
   8814,
   11661,
   -3154,
   1473,
   -726,
   338,
   -139,
   47,
   -12,
   2,
   1,
   -11,
   45,
   -135,
   330,
   -714,
   1449,
   -3077,
   10563,
   9991,
   -3008,
   1422,
   -700,
   323,
   -131,
   44,
   -11,
   1,
   2,
   -12,
   48,
   -139,
   338,
   -724,
   1469,
   -3158,
   12182,
   8215,
   -2692,
   1285,
   -631,
   289,
   -116,
   38,
   -9,
   1,
   2,
   -12,
   47,
   -134,
   321,
   -684,
   1385,
   -3024,
   13609,
   6399,
   -2245,
   1081,
   -529,
   240,
   -95,
   30,
   -7,
   1,
   2,
   -11,
   42,
   -118,
   278,
   -589,
   1193,
   -2650,
   14784,
   4611,
   -1712,
   830,
   -405,
   182,
   -71,
   22,
   -5,
   0,
   2,
   -9,
   32,
   -90,
   209,
   -440,
   891,
   -2021,
   15660,
   2913,
   -1133,
   553,
   -269,
   120,
   -46,
   14,
   -3,
   0,
   1,
   -5,
   18,
   -50,
   115,
   -241,
   488,
   -1135,
   16201,
   1361,
   -551,
   270,
   -131,
   58,
   -22,
   7,
   -1,
   0,
   -0,
   0,
   -0,
   0,
   -0,
   0,
   -0,
   0,
   16384,
   0,
   -0,
   0,
   -0,
   0,
   -0,
   0,
   -0,
   0,
   0,
   -1,
   7,
   -22,
   58,
   -131,
   270,
   -551,
   1361,
   16201,
   -1135,
   488,
   -241,
   115,
   -50,
   18,
   -5,
   1,
   0,
   -3,
   14,
   -46,
   120,
   -269,
   553,
   -1133,
   2913,
   15660,
   -2021,
   891,
   -440,
   209,
   -90,
   32,
   -9,
   2,
   0,
   -5,
   22,
   -71,
   182,
   -405,
   830,
   -1712,
   4611,
   14784,
   -2650,
   1193,
   -589,
   278,
   -118,
   42,
   -11,
   2,
   1,
   -7,
   30,
   -95,
   240,
   -529,
   1081,
   -2245,
   6399,
   13609,
   -3024,
   1385,
   -684,
   321,
   -134,
   47,
   -12,
   2,
   1,
   -9,
   38,
   -116,
   289,
   -631,
   1285,
   -2692,
   8215,
   12182,
   -3158,
   1469,
   -724,
   338,
   -139,
   48,
   -12,
   2,
   1,
   -11,
   44,
   -131,
   323,
   -700,
   1422,
   -3008,
   9991,
   10563,
   -3077,
   1449,
   -714,
   330,
   -135,
   45,
   -11,
   1,
   2,
   -12,
   47,
   -139,
   338,
   -726,
   1473,
   -3154,
   11661,
   8814,
   -2813,
   1339,
   -658,
   302,
   -122,
   40,
   -9,
   1,
   2,
   -12,
   47,
   -137,
   330,
   -703,
   1425,
   -3095,
   13158,
   7004,
   -2406,
   1156,
   -566,
   258,
   -102,
   33,
   -8,
   1,
   2,
   -12,
   44,
   -125,
   296,
   -627,
   1269,
   -2803,
   14423,
   5200,
   -1897,
   918,
   -448,
   202,
   -79,
   25,
   -5,
   0,
   2,
   -10,
   36,
   -100,
   235,
   -495,
   1004,
   -2260,
   15404,
   3466,
   -1329,
   647,
   -315,
   141,
   -54,
   17,
   -4,
   0,
   1,
   -7,
   23,
   -64,
   149,
   -312,
   633,
   -1459,
   16060,
   1859,
   -743,
   364,
   -176,
   78,
   -30,
   9,
   -2,
   0,
   0,
   -2,
   7,
   -18,
   40,
   -84,
   171,
   -405,
   16364,
   430,
   -178,
   87,
   -42,
   18,
   -7,
   2,
   -0,
   0,
   0,
   -1,
   4,
   -14,
   38,
   -86,
   178,
   -362,
   884,
   16303,
   -783,
   334,
   -165,
   79,
   -34,
   13,
   -4,
   1,
   0,
   -2,
   11,
   -38,
   99,
   -222,
   458,
   -938,
   2377,
   15879,
   -1754,
   768,
   -379,
   181,
   -78,
   28,
   -8,
   1,
   0,
   -4,
   19,
   -63,
   162,
   -360,
   740,
   -1522,
   4032,
   15111,
   -2469,
   1104,
   -545,
   258,
   -110,
   39,
   -11,
   2,
   1,
   -6,
   28,
   -87,
   222,
   -490,
   1002,
   -2075,
   5797,
   14031,
   -2927,
   1333,
   -658,
   310,
   -130,
   46,
   -12,
   2,
   1,
   -8,
   35,
   -109,
   274,
   -600,
   1224,
   -2555,
   7610,
   12682,
   -3139,
   1453,
   -717,
   335,
   -139,
   48,
   -12,
   2,
   1,
   -10,
   42,
   -127,
   314,
   -681,
   1385,
   -2919,
   9407,
   11120,
   -3126,
   1466,
   -723,
   335,
   -137,
   46,
   -11,
   1,
   1,
   -11,
   46,
   -137,
   335,
   -723,
   1466,
   -3126,
   11120,
   9407,
   -2919,
   1385,
   -681,
   314,
   -127,
   42,
   -10,
   1,
   2,
   -12,
   48,
   -139,
   335,
   -717,
   1453,
   -3139,
   12682,
   7610,
   -2555,
   1224,
   -600,
   274,
   -109,
   35,
   -8,
   1,
   2,
   -12,
   46,
   -130,
   310,
   -658,
   1333,
   -2927,
   14031,
   5797,
   -2075,
   1002,
   -490,
   222,
   -87,
   28,
   -6,
   1,
   2,
   -11,
   39,
   -110,
   258,
   -545,
   1104,
   -2469,
   15111,
   4032,
   -1522,
   740,
   -360,
   162,
   -63,
   19,
   -4,
   0,
   1,
   -8,
   28,
   -78,
   181,
   -379,
   768,
   -1754,
   15879,
   2377,
   -938,
   458,
   -222,
   99,
   -38,
   11,
   -2,
   0,
   1,
   -4,
   13,
   -34,
   79,
   -165,
   334,
   -783,
   16303,
   884,
   -362,
   178,
   -86,
   38,
   -14,
   4,
   -1,
   0,
   0,
   -0,
   2,
   -7,
   18,
   -42,
   87,
   -178,
   430,
   16364,
   -405,
   171,
   -84,
   40,
   -18,
   7,
   -2,
   0,
   },


#endif
/* 32khz  */
  {-1,
   8,
   -31,
   85,
   -198,
   410,
   -788,
   1490,
   -3112,
   13478,
   6633,
   -2373,
   1202,
   -637,
   325,
   -151,
   62,
   -21,
   5,
   -1,
   0,
   -0,
   0,
   -0,
   0,
   -0,
   0,
   -0,
   0,
   16384,
   0,
   -0,
   0,
   -0,
   0,
   -0,
   0,
   -0,
   0,
   -0,
   -1,
   5,
   -21,
   62,
   -151,
   325,
   -637,
   1202,
   -2373,
   6633,
   13478,
   -3112,
   1490,
   -788,
   410,
   -198,
   85,
   -31,
   8,
   -1,
   },

#if 0				/* src3.6  */
/* 22.05 khz */
  {1, -4, 11, -29, 63, -124, 226, -387, 639, -1039, 1741, -3337, 12626, 7840,
   -2805, 1536, -928, 570, -343, 198, -107, 53, -24, 9, -3, 0, 0, -1, 3, -10,
   22, -46, 86, -151, 253, -412, 677, -1192, 2807, 15743, -2023, 987, -579,
   355, -217, 128, -71, 37, -17, 7, -2, 1, 1, -3, 11, -27, 59, -115, 208,
   -355, 584, -950, 1600, -3128, 13912, 6117, -2340, 1298, -787, 483, -290,
   167, -90, 44, -19, 7, -2, 0, 0, -1, 5, -15, 34, -69, 128, -224, 375, -611,
   1005, -1790, 4422, 14964, -2693, 1347, -795, 488, -297, 175, -97, 50, -23,
   9, -3, 1, 1, -3, 9, -23, 50, -97, 175, -297, 488, -795, 1347, -2693, 14964,
   4422, -1790, 1005, -611, 375, -224, 128, -69, 34, -15, 5, -1, 0, 0, -2, 7,
   -19, 44, -90, 167, -290, 483, -787, 1298, -2340, 6117, 13912, -3128, 1600,
   -950, 584, -355, 208, -115, 59, -27, 11, -3, 1, 1, -2, 7, -17, 37, -71,
   128, -217, 355, -579, 987, -2023, 15743, 2807, -1192, 677, -412, 253, -151,
   86, -46, 22, -10, 3, -1, 0, 0, -3, 9, -24, 53, -107, 198, -343, 570, -928,
   1536, -2805, 7840, 12626, -3337, 1741, -1039, 639, -387, 226, -124, 63,
   -29, 11, -4, 1, 0, -1, 4, -10, 20, -39, 69, -116, 190, -310, 532, -1122,
   16222, 1320, -585, 335, -205, 125, -75, 42, -22, 11, -5, 2, 0, 0, 1, -3,
   10, -27, 60, -120, 220, -380, 629, -1023, 1699, -3148, 9537, 11150, -3336,
   1772, -1062, 653, -395, 230, -126, 63, -29, 11, -3, 1, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 16384, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, -3, 11,
   -29, 63, -126, 230, -395, 653, -1062, 1772, -3336, 11150, 9537, -3148,
   1699, -1023, 629, -380, 220, -120, 60, -27, 10, -3, 1, 0, 0, 2, -5, 11,
   -22, 42, -75, 125, -205, 335, -585, 1320, 16222, -1122, 532, -310, 190,
   -116, 69, -39, 20, -10, 4, -1, 0},
#else /* src3.7 */
  {2,
   -12,
   47,
   -139,
   338,
   -726,
   1473,
   -3154,
   11661,
   8814,
   -2813,
   1339,
   -658,
   302,
   -122,
   40,
   -9,
   1,
   0,
   -2,
   9,
   -30,
   78,
   -176,
   364,
   -743,
   1859,
   16060,
   -1459,
   633,
   -312,
   149,
   -64,
   23,
   -7,
   1,
   2,
   -12,
   47,
   -137,
   330,
   -703,
   1425,
   -3095,
   13158,
   7004,
   -2406,
   1156,
   -566,
   258,
   -102,
   33,
   -8,
   1,
   0,
   -4,
   17,
   -54,
   141,
   -315,
   647,
   -1329,
   3466,
   15404,
   -2260,
   1004,
   -495,
   235,
   -100,
   36,
   -10,
   2,
   2,
   -12,
   44,
   -125,
   296,
   -627,
   1269,
   -2803,
   14423,
   5200,
   -1897,
   918,
   -448,
   202,
   -79,
   25,
   -5,
   0,
   0,
   -5,
   25,
   -79,
   202,
   -448,
   918,
   -1897,
   5200,
   14423,
   -2803,
   1269,
   -627,
   296,
   -125,
   44,
   -12,
   2,
   2,
   -10,
   36,
   -100,
   235,
   -495,
   1004,
   -2260,
   15404,
   3466,
   -1329,
   647,
   -315,
   141,
   -54,
   17,
   -4,
   0,
   1,
   -8,
   33,
   -102,
   258,
   -566,
   1156,
   -2406,
   7004,
   13158,
   -3095,
   1425,
   -703,
   330,
   -137,
   47,
   -12,
   2,
   1,
   -7,
   23,
   -64,
   149,
   -312,
   633,
   -1459,
   16060,
   1859,
   -743,
   364,
   -176,
   78,
   -30,
   9,
   -2,
   0,
   1,
   -9,
   40,
   -122,
   302,
   -658,
   1339,
   -2813,
   8814,
   11661,
   -3154,
   1473,
   -726,
   338,
   -139,
   47,
   -12,
   2,
   0,
   -2,
   7,
   -18,
   40,
   -84,
   171,
   -405,
   16364,
   430,
   -178,
   87,
   -42,
   18,
   -7,
   2,
   -0,
   0,
   1,
   -11,
   45,
   -135,
   330,
   -714,
   1449,
   -3077,
   10563,
   9991,
   -3008,
   1422,
   -700,
   323,
   -131,
   44,
   -11,
   1,
   0,
   -1,
   4,
   -14,
   38,
   -86,
   178,
   -362,
   884,
   16303,
   -783,
   334,
   -165,
   79,
   -34,
   13,
   -4,
   1,
   2,
   -12,
   48,
   -139,
   338,
   -724,
   1469,
   -3158,
   12182,
   8215,
   -2692,
   1285,
   -631,
   289,
   -116,
   38,
   -9,
   1,
   0,
   -2,
   11,
   -38,
   99,
   -222,
   458,
   -938,
   2377,
   15879,
   -1754,
   768,
   -379,
   181,
   -78,
   28,
   -8,
   1,
   2,
   -12,
   47,
   -134,
   321,
   -684,
   1385,
   -3024,
   13609,
   6399,
   -2245,
   1081,
   -529,
   240,
   -95,
   30,
   -7,
   1,
   0,
   -4,
   19,
   -63,
   162,
   -360,
   740,
   -1522,
   4032,
   15111,
   -2469,
   1104,
   -545,
   258,
   -110,
   39,
   -11,
   2,
   2,
   -11,
   42,
   -118,
   278,
   -589,
   1193,
   -2650,
   14784,
   4611,
   -1712,
   830,
   -405,
   182,
   -71,
   22,
   -5,
   0,
   1,
   -6,
   28,
   -87,
   222,
   -490,
   1002,
   -2075,
   5797,
   14031,
   -2927,
   1333,
   -658,
   310,
   -130,
   46,
   -12,
   2,
   2,
   -9,
   32,
   -90,
   209,
   -440,
   891,
   -2021,
   15660,
   2913,
   -1133,
   553,
   -269,
   120,
   -46,
   14,
   -3,
   0,
   1,
   -8,
   35,
   -109,
   274,
   -600,
   1224,
   -2555,
   7610,
   12682,
   -3139,
   1453,
   -717,
   335,
   -139,
   48,
   -12,
   2,
   1,
   -5,
   18,
   -50,
   115,
   -241,
   488,
   -1135,
   16201,
   1361,
   -551,
   270,
   -131,
   58,
   -22,
   7,
   -1,
   0,
   1,
   -10,
   42,
   -127,
   314,
   -681,
   1385,
   -2919,
   9407,
   11120,
   -3126,
   1466,
   -723,
   335,
   -137,
   46,
   -11,
   1,
   -0,
   0,
   -0,
   0,
   -0,
   0,
   -0,
   0,
   16384,
   0,
   -0,
   0,
   -0,
   0,
   -0,
   0,
   -0,
   0,
   1,
   -11,
   46,
   -137,
   335,
   -723,
   1466,
   -3126,
   11120,
   9407,
   -2919,
   1385,
   -681,
   314,
   -127,
   42,
   -10,
   1,
   0,
   -1,
   7,
   -22,
   58,
   -131,
   270,
   -551,
   1361,
   16201,
   -1135,
   488,
   -241,
   115,
   -50,
   18,
   -5,
   1,
   2,
   -12,
   48,
   -139,
   335,
   -717,
   1453,
   -3139,
   12682,
   7610,
   -2555,
   1224,
   -600,
   274,
   -109,
   35,
   -8,
   1,
   0,
   -3,
   14,
   -46,
   120,
   -269,
   553,
   -1133,
   2913,
   15660,
   -2021,
   891,
   -440,
   209,
   -90,
   32,
   -9,
   2,
   2,
   -12,
   46,
   -130,
   310,
   -658,
   1333,
   -2927,
   14031,
   5797,
   -2075,
   1002,
   -490,
   222,
   -87,
   28,
   -6,
   1,
   0,
   -5,
   22,
   -71,
   182,
   -405,
   830,
   -1712,
   4611,
   14784,
   -2650,
   1193,
   -589,
   278,
   -118,
   42,
   -11,
   2,
   2,
   -11,
   39,
   -110,
   258,
   -545,
   1104,
   -2469,
   15111,
   4032,
   -1522,
   740,
   -360,
   162,
   -63,
   19,
   -4,
   0,
   1,
   -7,
   30,
   -95,
   240,
   -529,
   1081,
   -2245,
   6399,
   13609,
   -3024,
   1385,
   -684,
   321,
   -134,
   47,
   -12,
   2,
   1,
   -8,
   28,
   -78,
   181,
   -379,
   768,
   -1754,
   15879,
   2377,
   -938,
   458,
   -222,
   99,
   -38,
   11,
   -2,
   0,
   1,
   -9,
   38,
   -116,
   289,
   -631,
   1285,
   -2692,
   8215,
   12182,
   -3158,
   1469,
   -724,
   338,
   -139,
   48,
   -12,
   2,
   1,
   -4,
   13,
   -34,
   79,
   -165,
   334,
   -783,
   16303,
   884,
   -362,
   178,
   -86,
   38,
   -14,
   4,
   -1,
   0,
   1,
   -11,
   44,
   -131,
   323,
   -700,
   1422,
   -3008,
   9991,
   10563,
   -3077,
   1449,
   -714,
   330,
   -135,
   45,
   -11,
   1,
   0,
   -0,
   2,
   -7,
   18,
   -42,
   87,
   -178,
   430,
   16364,
   -405,
   171,
   -84,
   40,
   -18,
   7,
   -2,
   0,
   },

#endif

/* 11.025 khz */
  {0, -1, 2, -7, 19, -43, 89, -169, 303, -529, 947, -1999, 15740, 2789, -1157,
   629, -360, 204, -110, 55, -25, 10, -3, 1, 0, 0, 0, -1, 3, -11, 31, -73,
   153, -296, 535, -937, 1655, -3280, 12609, 7814, -2740, 1444, -824, 469,
   -256, 130, -61, 25, -9, 3, 0, 0, 0, 0, 3, -9, 25, -61, 130, -256, 469,
   -824, 1444, -2740, 7814, 12609, -3280, 1655, -937, 535, -296, 153, -73, 31,
   -11, 3, -1, 0, 0, 0, 1, -3, 10, -25, 55, -110, 204, -360, 629, -1157, 2789,
   15740, -1999, 947, -529, 303, -169, 89, -43, 19, -7, 2, -1, 0, 0, 0, 1, -4,
   11, -24, 48, -91, 163, -285, 512, -1110, 16221, 1310, -566, 310, -178, 100,
   -54, 27, -12, 5, -2, 0, 0, 0, 0, -1, 3, -11, 29, -68, 142, -273, 492, -860,
   1525, -3081, 13900, 6091, -2281, 1216, -695, 395, -214, 109, -50, 21, -7,
   2, 0, 0, 0, -1, 3, -10, 29, -69, 146, -285, 520, -913, 1604, -3082, 9512,
   11129, -3273, 1678, -953, 544, -299, 154, -73, 31, -11, 3, -1, 0, 0, 0, 1,
   -5, 15, -38, 83, -164, 304, -537, 938, -1740, 4398, 14957, -2657, 1288,
   -724, 414, -231, 121, -58, 25, -10, 3, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 16384, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 3, -10, 25, -58,
   121, -231, 414, -724, 1288, -2657, 14957, 4398, -1740, 938, -537, 304,
   -164, 83, -38, 15, -5, 1, 0, 0, 0, -1, 3, -11, 31, -73, 154, -299, 544,
   -953, 1678, -3273, 11129, 9512, -3082, 1604, -913, 520, -285, 146, -69, 29,
   -10, 3, -1, 0, 0, 0, 2, -7, 21, -50, 109, -214, 395, -695, 1216, -2281,
   6091, 13900, -3081, 1525, -860, 492, -273, 142, -68, 29, -11, 3, -1, 0, 0,
   0, 0, -2, 5, -12, 27, -54, 100, -178, 310, -566, 1310, 16221, -1110, 512,
   -285, 163, -91, 48, -24, 11, -4, 1, 0, 0},


  /* 8khz */

  {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 16384, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, -1, 2, -4, 6, -8, 11, -16, 21,
   -28, 36, -47, 60, -76, 95, -118, 146, -181, 223, -277, 345, -438, 571,
   -781, 1174, -2219, 15643, 3118, -1397, 882, -629, 477, -373, 297, -240,
   194, -157, 127, -102, 82, -65, 51, -40, 30, -23, 17, -13, 9, -6, 4, -3, 2,
   -1, 1, 0, 0, 0, 0, 0, -1, 1, -2, 4, -6, 9, -13, 18, -26, 35, -46, 60, -78,
   100, -126, 159, -198, 245, -302, 373, -462, 576, -728, 944, -1278, 1881,
   -3356, 13542, 6759, -2670, 1631, -1147, 862, -672, 535, -430, 348, -282,
   228, -184, 147, -117, 92, -72, 55, -42, 31, -23, 16, -12, 8, -5, 3, -2, 1,
   -1, 0, 0, 0, 0, -1, 1, -3, 4, -6, 10, -14, 20, -28, 38, -51, 67, -87, 111,
   -140, 176, -220, 273, -337, 416, -515, 641, -807, 1041, -1397, 2018, -3436,
   10417, 10417, -3436, 2018, -1397, 1041, -807, 641, -515, 416, -337, 273,
   -220, 176, -140, 111, -87, 67, -51, 38, -28, 20, -14, 10, -6, 4, -3, 1, -1,
   0, 0, 0, 0, -1, 1, -2, 3, -5, 8, -12, 16, -23, 31, -42, 55, -72, 92, -117,
   147, -184, 228, -282, 348, -430, 535, -672, 862, -1147, 1631, -2670, 6759,
   13542, -3356, 1881, -1278, 944, -728, 576, -462, 373, -302, 245, -198, 159,
   -126, 100, -78, 60, -46, 35, -26, 18, -13, 9, -6, 4, -2, 1, -1, 0, 0, 0, 0,
   0, 1, -1, 2, -3, 4, -6, 9, -13, 17, -23, 30, -40, 51, -65, 82, -102, 127,
   -157, 194, -240, 297, -373, 477, -629, 882, -1397, 3118, 15643, -2219,
   1174, -781, 571, -438, 345, -277, 223, -181, 146, -118, 95, -76, 60, -47,
   36, -28, 21, -16, 11, -8, 6, -4, 2, -1, 1, 0, 0, 0}
};

/*#include "src3rec.h" */
#define REDUCED_FILTER 1

#if REDUCED_FILTER
/*short   SRC3_REC_COEFF_HALF[4][313] = { */
short SRC3_REC_COEFF_HALF[5][680] = {
#else /* if */
short SRC3_REC_COEFF_HALF[4][528] = {
#endif

#if REDUCED_FILTER

#if 1				/* Higher Sampling Rate Acuracy for 44.1khz */
  {2,
   -11,
   44,
   -126,
   288,
   -552,
   921,
   -1398,
   2184,
   14981,
   395,
   -683,
   594,
   -412,
   237,
   -112,
   42,
   -11,
   2,
   0,
   2,
   -11,
   43,
   -117,
   252,
   -450,
   680,
   -862,
   812,
   15037,
   1708,
   -1221,
   843,
   -520,
   278,
   -124,
   44,
   -11,
   2,
   0,
   2,
   -11,
   39,
   -101,
   204,
   -331,
   421,
   -333,
   -372,
   14758,
   3185,
   -1743,
   1062,
   -605,
   303,
   -128,
   43,
   -10,
   1,
   0,
   1,
   -9,
   33,
   -80,
   149,
   -204,
   163,
   157,
   -1340,
   14155,
   4778,
   -2211,
   1231,
   -656,
   310,
   -123,
   38,
   -8,
   1,
   0,
   1,
   -8,
   25,
   -58,
   91,
   -79,
   -77,
   582,
   -2077,
   13254,
   6436,
   -2585,
   1332,
   -666,
   295,
   -108,
   30,
   -5,
   -0,
   0,
   1,
   -6,
   18,
   -35,
   35,
   37,
   -287,
   922,
   -2576,
   12092,
   8100,
   -2828,
   1350,
   -629,
   256,
   -82,
   17,
   0,
   -1,
   0,
   1,
   -4,
   11,
   -13,
   -16,
   137,
   -455,
   1166,
   -2844,
   10715,
   9706,
   -2902,
   1273,
   -541,
   192,
   -46,
   -0,
   6,
   -3,
   0,
   0,
   -2,
   4,
   6,
   -59,
   216,
   -576,
   1309,
   -2898,
   9181,
   11195,
   -2779,
   1096,
   -404,
   106,
   0,
   -20,
   13,
   -4,
   1,
   0,
   -1,
   -2,
   22,
   -92,
   272,
   -646,
   1354,
   -2764,
   7548,
   12505,
   -2435,
   819,
   -221,
   -0,
   53,
   -42,
   20,
   -6,
   1,
   0,
   0,
   -6,
   33,
   -114,
   303,
   -667,
   1307,
   -2473,
   5880,
   13585,
   -1858,
   449,
   0,
   -120,
   110,
   -65,
   28,
   -8,
   1,
   1,
   -9,
   40,
   -126,
   310,
   -643,
   1181,
   -2063,
   4237,
   14391,
   -1043,
   -0,
   248,
   -247,
   167,
   -87,
   35,
   -10,
   1,
   0,
   1,
   -11,
   44,
   -128,
   297,
   -580,
   994,
   -1573,
   2677,
   14888,
   0,
   -506,
   508,
   -372,
   221,
   -106,
   40,
   -11,
   2,
   0,
   2,
   -11,
   43,
   -121,
   265,
   -487,
   763,
   -1041,
   1251,
   15056,
   1251,
   -1041,
   763,
   -487,
   265,
   -121,
   43,
   -11,
   2,
   0,
   2,
   -11,
   40,
   -106,
   221,
   -372,
   508,
   -506,
   0,
   14888,
   2677,
   -1573,
   994,
   -580,
   297,
   -128,
   44,
   -11,
   1,
   0,
   1,
   -10,
   35,
   -87,
   167,
   -247,
   248,
   -0,
   -1043,
   14391,
   4237,
   -2063,
   1181,
   -643,
   310,
   -126,
   40,
   -9,
   1,
   0,
   1,
   -8,
   28,
   -65,
   110,
   -120,
   0,
   449,
   -1858,
   13585,
   5880,
   -2473,
   1307,
   -667,
   303,
   -114,
   33,
   -6,
   0,
   0,
   1,
   -6,
   20,
   -42,
   53,
   -0,
   -221,
   819,
   -2435,
   12505,
   7548,
   -2764,
   1354,
   -646,
   272,
   -92,
   22,
   -2,
   -1,
   0,
   1,
   -4,
   13,
   -20,
   0,
   106,
   -404,
   1096,
   -2779,
   11195,
   9181,
   -2898,
   1309,
   -576,
   216,
   -59,
   6,
   4,
   -2,
   0,
   0,
   -3,
   6,
   -0,
   -46,
   192,
   -541,
   1273,
   -2902,
   9706,
   10715,
   -2844,
   1166,
   -455,
   137,
   -16,
   -13,
   11,
   -4,
   1,
   0,
   -1,
   0,
   17,
   -82,
   256,
   -629,
   1350,
   -2828,
   8100,
   12092,
   -2576,
   922,
   -287,
   37,
   35,
   -35,
   18,
   -6,
   1,
   0,
   -0,
   -5,
   30,
   -108,
   295,
   -666,
   1332,
   -2585,
   6436,
   13254,
   -2077,
   582,
   -77,
   -79,
   91,
   -58,
   25,
   -8,
   1,
   1,
   -8,
   38,
   -123,
   310,
   -656,
   1231,
   -2211,
   4778,
   14155,
   -1340,
   157,
   163,
   -204,
   149,
   -80,
   33,
   -9,
   1,
   0,
   1,
   -10,
   43,
   -128,
   303,
   -605,
   1062,
   -1743,
   3185,
   14758,
   -372,
   -333,
   421,
   -331,
   204,
   -101,
   39,
   -11,
   2,
   0,
   2,
   -11,
   44,
   -124,
   278,
   -520,
   843,
   -1221,
   1708,
   15037,
   812,
   -862,
   680,
   -450,
   252,
   -117,
   43,
   -11,
   2,
   0,
   2,
   -11,
   42,
   -112,
   237,
   -412,
   594,
   -683,
   395,
   14981,
   2184,
   -1398,
   921,
   -552,
   288,
   -126,
   44,
   -11,
   2,
   0,
   2,
   -10,
   37,
   -94,
   186,
   -289,
   334,
   -164,
   -720,
   14592,
   3705,
   -1907,
   1125,
   -626,
   308,
   -128,
   42,
   -10,
   1,
   0,
   1,
   -9,
   30,
   -73,
   129,
   -162,
   80,
   307,
   -1612,
   13886,
   5327,
   -2348,
   1273,
   -664,
   308,
   -120,
   36,
   -7,
   1,
   0,
   1,
   -7,
   23,
   -50,
   72,
   -39,
   -151,
   705,
   -2269,
   12893,
   6993,
   -2683,
   1348,
   -659,
   285,
   -101,
   26,
   -3,
   -0,
   0,
   1,
   -5,
   15,
   -27,
   17,
   73,
   -348,
   1015,
   -2690,
   11654,
   8645,
   -2873,
   1335,
   -605,
   237,
   -71,
   12,
   2,
   -2,
   0,
   0,
   -3,
   8,
   -6,
   -31,
   166,
   -501,
   1225,
   -2885,
   10219,
   10219,
   -2885,
   1225,
   -501,
   166,
   -31,
   -6,
   8,
   -3,
   0,
   0,
   -2,
   2,
   12,
   -71,
   237,
   -605,
   1335,
   -2873,
   8645,
   11654,
   -2690,
   1015,
   -348,
   73,
   17,
   -27,
   15,
   -5,
   1,
   0,
   -0,
   -3,
   26,
   -101,
   285,
   -659,
   1348,
   -2683,
   6993,
   12893,
   -2269,
   705,
   -151,
   -39,
   72,
   -50,
   23,
   -7,
   1,
   0,
   1,
   -7,
   36,
   -120,
   308,
   -664,
   1273,
   -2348,
   5327,
   13886,
   -1612,
   307,
   80,
   -162,
   129,
   -73,
   30,
   -9,
   1,
   1,
   -10,
   42,
   -128,
   308,
   -626,
   1125,
   -1907,
   3705,
   14592,
   -720,
   -164,
   334,
   -289,
   186,
   -94,
   37,
   -10,
   2,
   0,
   },

#else	/* if */	 /* Less Acurate for 44.1khz */
  {1, -5, 19, -53, 119, -224, 363, -511, 613, -558, 0, 14844, 2791, -1712,
   1170, -769, 464, -250, 117, -45, 13, -2, 0, 0, 1, -6, 20, -51, 108, -189,
   282, -344, 302, 0, -1091, 14326, 4409, -2226, 1371, -835, 472, -237, 102,
   -34, 7, 0, -1, 0, 1, -6, 18, -46, 90, -146, 189, -170, 0, 500, -1942,
   13488, 6103, -2642, 1492, -846, 444, -205, 77, -19, 0, 3, -1, 0, 1, -5, 16,
   -38, 69, -97, 93, 0, -274, 916, -2543, 12366, 7811, -2917, 1516, -796, 381,
   -153, 42, 0, -9, 6, -2, 0, 1, -4, 13, -29, 46, -48, 0, 154, -505, 1230,
   -2895, 11007, 9468, -3012, 1430, -681, 283, -83, 0, 22, -19, 10, -3, 1, 1,
   -3, 10, -19, 22, 0, -83, 283, -681, 1430, -3012, 9468, 11007, -2895, 1230,
   -505, 154, 0, -48, 46, -29, 13, -4, 1, 0, -2, 6, -9, 0, 42, -153, 381,
   -796, 1516, -2917, 7811, 12366, -2543, 916, -274, 0, 93, -97, 69, -38, 16,
   -5, 1, 0, -1, 3, 0, -19, 77, -205, 444, -846, 1492, -2642, 6103, 13488,
   -1942, 500, 0, -170, 189, -146, 90, -46, 18, -6, 1, 0, -1, 0, 7, -34, 102,
   -237, 472, -835, 1371, -2226, 4409, 14326, -1091, 0, 302, -344, 282, -189,
   108, -51, 20, -6, 1, 0, 0, -2, 13, -45, 117, -250, 464, -769, 1170, -1712,
   2791, 14844, 0, -558, 613, -511, 363, -224, 119, -53, 19, -5, 1, 0, -4, 17,
   -51, 123, -245, 426, -657, 910, -1142, 1306, 15019, 1306, -1142, 910, -657,
   426, -245, 123, -51, 17, -4, 0, 0},
#endif

#else	/* if */	 /* not reduced 44k filter */
  {0, 1, -2, 4, -7, 11, -16, 20, -21, 16, 0, -31, 81, -152, 245, -358, 482,
   -606, 715, -785, 780, -623, 0, 14847, 2849, -1874, 1448, -1135, 869, -637,
   438, -275, 149, -59, 0, 33, -46, 46, -39, 30, -20, 12, -7, 3, -1, 0, 0, 0,
   0, 1, -2, 4, -6, 10, -13, 14, -11, 0, 22, -58, 111, -182, 267, -361, 454,
   -531, 569, -539, 390, 0, -1129, 14338, 4482, -2417, 1674, -1210, 862, -585,
   366, -199, 79, 0, -45, 65, -67, 59, -46, 32, -20, 11, -6, 2, -1, 0, 0, 0,
   0, 1, -2, 3, -5, 8, -9, 7, 0, -15, 41, -80, 132, -197, 270, -341, 398,
   -423, 392, -272, 0, 569, -2022, 13513, 6183, -2846, 1798, -1205, 793, -490,
   265, -105, 0, 62, -90, 94, -84, 67, -49, 32, -19, 10, -4, 1, 0, 0, 0, 0, 0,
   1, -2, 3, -4, 5, -4, 0, 10, -28, 56, -95, 144, -199, 254, -298, 317, -292,
   198, 0, -365, 1053, -2663, 12407, 7890, -3117, 1804, -1113, 665, -355, 141,
   0, -83, 122, -130, 119, -97, 72, -49, 30, -16, 7, -2, 0, 1, -1, 0, 0, 0, 1,
   -1, 2, -3, 3, 0, -6, 18, -38, 66, -103, 145, -187, 222, -238, 219, -147, 0,
   257, -684, 1430, -3051, 11064, 9538, -3196, 1682, -937, 483, -188, 0, 111,
   -164, 177, -164, 136, -103, 72, -45, 25, -12, 4, 0, -1, 1, -1, 0, 0, 0, 0,
   -1, 1, -1, 0, 4, -12, 25, -45, 72, -103, 136, -164, 177, -164, 111, 0,
   -188, 483, -937, 1682, -3196, 9538, 11064, -3051, 1430, -684, 257, 0, -147,
   219, -238, 222, -187, 145, -103, 66, -38, 18, -6, 0, 3, -3, 2, -1, 1, 0, 0,
   0, -1, 1, 0, -2, 7, -16, 30, -49, 72, -97, 119, -130, 122, -83, 0, 141,
   -355, 665, -1113, 1804, -3117, 7890, 12407, -2663, 1053, -365, 0, 198,
   -292, 317, -298, 254, -199, 144, -95, 56, -28, 10, 0, -4, 5, -4, 3, -2, 1,
   0, 0, 0, 0, 0, 1, -4, 10, -19, 32, -49, 67, -84, 94, -90, 62, 0, -105, 265,
   -490, 793, -1205, 1798, -2846, 6183, 13513, -2022, 569, 0, -272, 392, -423,
   398, -341, 270, -197, 132, -80, 41, -15, 0, 7, -9, 8, -5, 3, -2, 1, 0, 0,
   0, 0, -1, 2, -6, 11, -20, 32, -46, 59, -67, 65, -45, 0, 79, -199, 366,
   -585, 862, -1210, 1674, -2417, 4482, 14338, -1129, 0, 390, -539, 569, -531,
   454, -361, 267, -182, 111, -58, 22, 0, -11, 14, -13, 10, -6, 4, -2, 1, 0,
   0, 0, 0, -1, 3, -7, 12, -20, 30, -39, 46, -46, 33, 0, -59, 149, -275, 438,
   -637, 869, -1135, 1448, -1874, 2849, 14847, 0, -623, 780, -785, 715, -606,
   482, -358, 245, -152, 81, -31, 0, 16, -21, 20, -16, 11, -7, 4, -2, 1, 0, 0,
   0, -1, 4, -7, 12, -19, 26, -31, 32, -23, 0, 43, -110, 205, -328, 477, -643,
   818, -989, 1141, -1261, 1339, 15019, 1339, -1261, 1141, -989, 818, -643,
   477, -328, 205, -110, 43, 0, -23, 32, -31, 26, -19, 12, -7, 4, -1, 0, 0,
   0},

#endif
/*	32k */
  {-0,
   0,
   6,
   -14,
   0,
   57,
   -101,
   0,
   273,
   -425,
   0,
   993,
   -1582,
   0,
   8985,
   8985,
   0,
   -1582,
   993,
   0,
   -425,
   273,
   0,
   -101,
   57,
   0,
   -14,
   6,
   0,
   -0,
   -1,
   3,
   -0,
   -20,
   41,
   -0,
   -132,
   216,
   -0,
   -526,
   801,
   -0,
   -2075,
   4422,
   10923,
   4422,
   -2075,
   -0,
   801,
   -526,
   -0,
   216,
   -132,
   -0,
   41,
   -20,
   -0,
   3,
   -1,
   -0,
   },


/* 22k */
  {0, 0, 1, 2, -3, -7, 6, 19, -7, -42, 0, 80, 26, -134, -87, 199, 205, -262,
   -415, 300, 781, -265, -1523, 0, 4395, 7487, 5823, 1291, -1432, -813, 607,
   578, -254, -401, 80, 261, 0, -155, -28, 83, 30, -39, -22, 15, 12, -4, -6,
   1, 2, 0, 0, 0, 0, 0, 1, 2, -2, -7, 3, 18, 0, -39, -13, 71, 48, -112, -119,
   154, 245, -176, -453, 148, 793, 0, -1436, -515, 3612, 7265, 6418, 2035,
   -1234, -1065, 445, 685, -136, -443, 0, 272, 51, -153, -58, 77, 46, -33,
   -29, 11, 15, -2, -6, 0, 2, 0, 0, 0, 0, 0, 1, 2, -1, -7, 0, 17, 6, -35, -24,
   60, 65, -86, -141, 103, 267, -87, -461, 0, 760, 240, -1278, -928, 2816,
   6904, 6904, 2816, -928, -1278, 240, 760, 0, -461, -87, 267, 103, -141, -86,
   65, 60, -24, -35, 6, 17, 0, -7, -1, 2, 1, 0, 0, 0, 0, 0, 2, 0, -6, -2, 15,
   11, -29, -33, 46, 77, -58, -153, 51, 272, 0, -443, -136, 685, 445, -1065,
   -1234, 2035, 6418, 7265, 3612, -515, -1436, 0, 793, 148, -453, -176, 245,
   154, -119, -112, 48, 71, -13, -39, 0, 18, 3, -7, -2, 2, 1, 0, 0, 0, 0, 0,
   2, 1, -6, -4, 12, 15, -22, -39, 30, 83, -28, -155, 0, 261, 80, -401, -254,
   578, 607, -813, -1432, 1291, 5823, 7487, 4395, 0, -1523, -265, 781, 300,
   -415, -262, 205, 199, -87, -134, 26, 80, 0, -42, -7, 19, 6, -7, -3, 2, 1,
   0, 0, 0, 0, 2, 1, -4, -6, 9, 17, -14, -41, 15, 84, 0, -148, -47, 235, 150,
   -339, -348, 446, 719, -541, -1526, 607, 5141, 7562, 5141, 607, -1526, -541,
   719, 446, -348, -339, 150, 235, -47, -148, 0, 84, 15, -41, -14, 17, 9, -6,
   -4, 1, 2, 0, 0, 0},

/* 11k */
  {0, -1, -1, -1, 1, 6, 12, 12, 0, -26, -55, -63, -25, 63, 167, 216, 138, -91,
   -398, -614, -530, 0, 959, 2135, 3179, 3741, 3624, 2869, 1739, 601, -229,
   -603, -566, -296, 0, 182, 211, 135, 30, -43, -64, -46, -16, 6, 13, 10, 4,
   0, -1, -1, 0, 0, 0, 0, -1, -1, 0, 4, 10, 13, 6, -16, -46, -64, -43, 30,
   135, 211, 182, 0, -296, -566, -603, -229, 601, 1739, 2869, 3624, 3741,
   3179, 2135, 959, 0, -530, -614, -398, -91, 138, 216, 167, 63, -25, -63,
   -55, -26, 0, 12, 12, 6, 1, -1, -1, -1, 0, 0, -1, -1, -1, 3, 8, 13, 10, -7,
   -36, -61, -56, 0, 99, 194, 207, 77, -191, -491, -629, -406, 279, 1343,
   2517, 3434, 3781, 3434, 2517, 1343, 279, -406, -629, -491, -191, 77, 207,
   194, 99, 0, -56, -61, -36, -7, 10, 13, 8, 3, -1, -1, -1, 0, 0},


/* 8k */
  {0, 1, 1, 2, 2, 0, -4, -10, -17, -21, -16, 0, 29, 66, 98, 108, 79, 0, -123,
   -263, -375, -401, -287, 0, 457, 1037, 1658, 2211, 2594, 2731, 2594, 2211,
   1658, 1037, 457, 0, -287, -401, -375, -263, -123, 0, 79, 108, 98, 66, 29,
   0, -16, -21, -17, -10, -4, 0, 2, 2, 1, 1, 0, 0}
};


/*#include "minisrc.h" */
/* warning!! warning!! warning!! warning!! warning!! warning!! warning!!*/

/* You really have to watch out "the order of IIR coefficients"!!!!!! */
/* the order is : b2, b1, b0, -a2, -a1 */

/*#define MINISRC_BIQUAD_STAGE    2 */

#if 1
WORD MINISRC_LPF[10] = {
  0X0743,
  0X1104,
  0X0A4C,
  0XF88D,
  0X242C,

  0X1023,
  0X1AA9,
  0X0B60,
  0XEFDD,
  0X186F
};

#else
WORD MINISRC_LPF[10] = {
  0x01B7,
  0XF632,
  0X0BE4,
  0XDC94,
  0X2D03,

  0X3748,
  0X938D,
  0X5887,
  0XC7F9,
  0X6D75
};
#endif
/*#include "msrcsize.h" */
#ifndef __MSRCSIZE
#define __MSRCSIZE

#define MINISRC_IN_BUFFER_SIZE   ( 0x50 * 2 )
#define MINISRC_OUT_BUFFER_SIZE  ( 0x50 * 2 * 2)
#define MINISRC_TMP_BUFFER_SIZE  ( 112 + ( MINISRC_BIQUAD_STAGE * 3 + 4 ) * 2 * 2 )
#define MINISRC_BIQUAD_STAGE    2
/* M. SRC LPF coefficient could be changed in the DSP code */
#define MINISRC_COEF_LOC          0X175


#endif

#endif
