/*
 * Copyright (c) 2000 University of Utah and the Flux Group.
 * All rights reserved.
 * 
 * This file is part of the Flux OSKit.  The OSKit is free software, also known
 * as "open source;" you can redistribute it and/or modify it under the terms
 * of the GNU General Public License (GPL), version 2, as published by the Free
 * Software Foundation (FSF).  To explore alternate licensing terms, contact
 * the University of Utah at csl-dist@cs.utah.edu or +1-801-585-3271.
 * 
 * The OSKit is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GPL for more details.  You should have
 * received a copy of the GPL along with the OSKit; see the file COPYING.  If
 * not, write to the FSF, 59 Temple Place #330, Boston, MA 02111-1307, USA.
 */

/*
 * This maps host OS errno constants to OSKit errno constants.
 * How it is used depends on the sparseness of the constants.
 * Look at native_errno.h for details.
 */

NATIVE_ERROR(E2BIG, OSKIT_E2BIG)
NATIVE_ERROR(EACCES, OSKIT_EACCES)
NATIVE_ERROR(EADDRINUSE, OSKIT_EADDRINUSE)
NATIVE_ERROR(EADDRNOTAVAIL, OSKIT_EADDRNOTAVAIL)
NATIVE_ERROR(EAFNOSUPPORT, OSKIT_EAFNOSUPPORT)
NATIVE_ERROR(EAGAIN, OSKIT_EAGAIN)
NATIVE_ERROR(EALREADY, OSKIT_EALREADY)
NATIVE_ERROR(EBADF, OSKIT_EBADF)
#ifdef EBADMSG
NATIVE_ERROR(EBADMSG, OSKIT_EBADMSG)
#endif
NATIVE_ERROR(EBUSY, OSKIT_EBUSY)
#ifdef ECANCELED
NATIVE_ERROR(ECANCELED, OSKIT_ECANCELED)
#endif
NATIVE_ERROR(ECHILD, OSKIT_ECHILD)
NATIVE_ERROR(ECONNABORTED, OSKIT_ECONNABORTED)
NATIVE_ERROR(ECONNREFUSED, OSKIT_ECONNREFUSED)
NATIVE_ERROR(ECONNRESET, OSKIT_ECONNRESET)
NATIVE_ERROR(EDEADLK, OSKIT_EDEADLK)
NATIVE_ERROR(EDESTADDRREQ, OSKIT_EDESTADDRREQ)
NATIVE_ERROR(EDOM, OSKIT_EDOM)
NATIVE_ERROR(EDQUOT, OSKIT_EDQUOT)
NATIVE_ERROR(EEXIST, OSKIT_EEXIST)
NATIVE_ERROR(EFAULT, OSKIT_E_POINTER)
NATIVE_ERROR(EFBIG, OSKIT_EFBIG)
NATIVE_ERROR(EHOSTUNREACH, OSKIT_EHOSTUNREACH)
NATIVE_ERROR(EIDRM, OSKIT_EIDRM)
#ifdef EILSEQ
NATIVE_ERROR(EILSEQ, OSKIT_EILSEQ)
#endif
NATIVE_ERROR(EINPROGRESS, OSKIT_EINPROGRESS)
NATIVE_ERROR(EINTR, OSKIT_EINTR)
NATIVE_ERROR(EINVAL, OSKIT_E_INVALIDARG)
NATIVE_ERROR(EIO, OSKIT_EIO)
NATIVE_ERROR(EISCONN, OSKIT_EISCONN)
NATIVE_ERROR(EISDIR, OSKIT_EISDIR)
NATIVE_ERROR(ELOOP, OSKIT_ELOOP)
NATIVE_ERROR(EMFILE, OSKIT_EMFILE)
NATIVE_ERROR(EMLINK, OSKIT_EMLINK)
NATIVE_ERROR(EMSGSIZE, OSKIT_EMSGSIZE)
#ifdef EMULTIHOP
NATIVE_ERROR(EMULTIHOP, OSKIT_EMULTIHOP)
#endif
NATIVE_ERROR(ENAMETOOLONG, OSKIT_ENAMETOOLONG)
NATIVE_ERROR(ENETDOWN, OSKIT_ENETDOWN)
NATIVE_ERROR(ENETUNREACH, OSKIT_ENETUNREACH)
NATIVE_ERROR(ENFILE, OSKIT_ENFILE)
NATIVE_ERROR(ENOBUFS, OSKIT_ENOBUFS)
#ifdef ENODATA
NATIVE_ERROR(ENODATA, OSKIT_ENODATA)
#endif
NATIVE_ERROR(ENODEV, OSKIT_ENODEV)
NATIVE_ERROR(ENOENT, OSKIT_ENOENT)
NATIVE_ERROR(ENOEXEC, OSKIT_ENOEXEC)
NATIVE_ERROR(ENOLCK, OSKIT_ENOLCK)
#ifdef ENOLINK
NATIVE_ERROR(ENOLINK, OSKIT_ENOLINK)
#endif
NATIVE_ERROR(ENOMEM, OSKIT_E_OUTOFMEMORY)
NATIVE_ERROR(ENOMSG, OSKIT_ENOMSG)
NATIVE_ERROR(ENOPROTOOPT, OSKIT_ENOPROTOOPT)
NATIVE_ERROR(ENOSPC, OSKIT_ENOSPC)
#ifdef ENOSR
NATIVE_ERROR(ENOSR, OSKIT_ENOSR)
#endif
#ifdef ENOSTR
NATIVE_ERROR(ENOSTR, OSKIT_ENOSTR)
#endif
NATIVE_ERROR(ENOSYS, OSKIT_E_NOTIMPL)
NATIVE_ERROR(ENOTCONN, OSKIT_ENOTCONN)
NATIVE_ERROR(ENOTDIR, OSKIT_ENOTDIR)
NATIVE_ERROR(ENOTEMPTY, OSKIT_ENOTEMPTY)
NATIVE_ERROR(ENOTSOCK, OSKIT_ENOTSOCK)
NATIVE_ERROR(EOPNOTSUPP, OSKIT_EOPNOTSUPP)
#if defined ENOTSUP && ENOTSUP != EOPNOTSUPP
NATIVE_ERROR(ENOTSUP, OSKIT_ENOTSUP)
#endif
NATIVE_ERROR(ENOTTY, OSKIT_ENOTTY)
NATIVE_ERROR(ENXIO, OSKIT_ENXIO)
#ifdef EOVERFLOW
NATIVE_ERROR(EOVERFLOW, OSKIT_EOVERFLOW)
#endif
NATIVE_ERROR(EPERM, OSKIT_E_ACCESSDENIED)
NATIVE_ERROR(EPIPE, OSKIT_EPIPE)
#ifdef EPROTO
NATIVE_ERROR(EPROTO, OSKIT_EPROTO)
#endif
NATIVE_ERROR(EPROTONOSUPPORT, OSKIT_EPROTONOSUPPORT)
NATIVE_ERROR(EPROTOTYPE, OSKIT_EPROTOTYPE)
NATIVE_ERROR(ERANGE, OSKIT_ERANGE)
NATIVE_ERROR(EROFS, OSKIT_EROFS)
NATIVE_ERROR(ESPIPE, OSKIT_ESPIPE)
NATIVE_ERROR(ESRCH, OSKIT_ESRCH)
NATIVE_ERROR(ESTALE, OSKIT_ESTALE)
#ifdef ETIME
NATIVE_ERROR(ETIME, OSKIT_ETIME)
#endif
NATIVE_ERROR(ETIMEDOUT, OSKIT_ETIMEDOUT)
NATIVE_ERROR(ETXTBSY, OSKIT_ETXTBSY)
#if defined(EWOULDBLOCK) && (EWOULDBLOCK != EAGAIN)
NATIVE_ERROR(EWOULDBLOCK, OSKIT_EWOULDBLOCK)
#endif
NATIVE_ERROR(EXDEV, OSKIT_EXDEV)
