/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.protocols;

import java.util.Vector;
import org.javagroups.Address;
import org.javagroups.View;
import org.javagroups.ViewId;
import org.javagroups.log.Trace;
import org.javagroups.protocols.GMS;
import org.javagroups.protocols.GmsImpl;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ParticipantGmsImpl
extends GmsImpl {
    boolean leaving;
    boolean received_final_view;
    Object leave_mutex;
    Vector suspected_mbrs;
    Vector new_mbrs;

    public void init() {
        this.leaving = false;
        this.received_final_view = false;
        this.suspected_mbrs.removeAllElements();
        this.new_mbrs.removeAllElements();
        if (this.gms.members != null) {
            int i = 0;
            while (i < this.gms.members.size()) {
                this.new_mbrs.addElement(this.gms.members.elementAt(i));
                ++i;
            }
        }
    }

    public void join(Address mbr) {
        this.wrongMethod("join");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void leave(Address mbr) {
        Address coord;
        Object retval = null;
        if (mbr.equals(this.gms.local_addr)) {
            this.leaving = true;
        }
        while ((coord = this.gms.determineCoordinator()) != null && !this.received_final_view) {
            Object object = this.leave_mutex;
            // MONITORENTER : object
            {
                if (this.gms.local_addr.equals(coord)) {
                    this.gms.becomeCoordinator();
                    this.gms.handleLeave(mbr, false);
                } else {
                    try {
                        if (Trace.trace) {
                            Trace.info("Participant.leave()", "sending LEAVE request to " + coord);
                        }
                        this.gms.callRemoteMethod(coord, "handleLeave", mbr, new Boolean(false), 6, 0L);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                try {
                    this.leave_mutex.wait(this.gms.leave_timeout);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        this.gms.becomeClient();
    }

    public void suspect(Address mbr) {
        this.handleSuspect(mbr);
    }

    public void merge(Vector other_coords) {
        this.wrongMethod("merge");
    }

    public boolean handleJoin(Address mbr) {
        this.wrongMethod("handleJoin");
        return false;
    }

    public void handleLeave(Address mbr, boolean suspected) {
        this.wrongMethod("handleLeave");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleViewChange(ViewId new_view, Vector mbrs) {
        if (Trace.trace) {
            Trace.info("ParticipantGmsImpl.handleViewChange()", "mbrs are " + mbrs);
        }
        this.suspected_mbrs.removeAllElements();
        this.new_mbrs.removeAllElements();
        if (mbrs != null) {
            int i = 0;
            while (i < mbrs.size()) {
                this.new_mbrs.addElement(mbrs.elementAt(i));
                ++i;
            }
        }
        if (!this.leaving) {
            this.gms.installView(new_view, mbrs);
            return;
        }
        if (mbrs.contains(this.gms.local_addr)) {
            Trace.warn("ParticipantGmsImpl.handleViewChange()", "received view in which I'm still a member, cannot quit yet");
            this.gms.installView(new_view, mbrs);
            return;
        }
        Object object = this.leave_mutex;
        synchronized (object) {
            this.received_final_view = true;
            this.leave_mutex.notify();
            return;
        }
    }

    public View handleMerge(ViewId other_view, Vector other_members) {
        this.wrongMethod("handleMerge");
        return null;
    }

    public void handleSuspect(Address mbr) {
        Vector suspects = null;
        if (mbr == null) {
            return;
        }
        if (!this.suspected_mbrs.contains(mbr)) {
            this.suspected_mbrs.addElement(mbr);
        }
        this.new_mbrs.removeElement(mbr);
        if (Trace.trace) {
            Trace.info("ParticipantGmsImpl.handleSuspect()", "suspected mbr=" + mbr + "\nsuspected_mbrs=" + this.suspected_mbrs + "\nnew_mbrs=" + this.new_mbrs);
        }
        if (this.new_mbrs.size() > 0 && this.new_mbrs.elementAt(0).equals(this.gms.local_addr)) {
            if (Trace.trace) {
                Trace.info("ParticipantGmsImpl.handleSuspect()", "suspected mbr=" + mbr + ", members are " + this.gms.members + ", coord=" + this.gms.local_addr + ": I'm the new coord !");
            }
            suspects = (Vector)this.suspected_mbrs.clone();
            this.suspected_mbrs.removeAllElements();
            this.new_mbrs.removeAllElements();
            this.gms.becomeCoordinator();
            this.gms.castViewChange(null, null, suspects);
        }
    }

    private final /* synthetic */ void this() {
        this.leaving = false;
        this.received_final_view = false;
        this.leave_mutex = new Object();
        this.suspected_mbrs = new Vector();
        this.new_mbrs = new Vector();
    }

    public ParticipantGmsImpl(GMS g) {
        this.this();
        this.gms = g;
        this.init();
    }
}

