/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.blocks;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import org.javagroups.Address;
import org.javagroups.Event;
import org.javagroups.Message;
import org.javagroups.Transport;
import org.javagroups.View;
import org.javagroups.blocks.RequestHandler;
import org.javagroups.blocks.RspCollector;
import org.javagroups.log.Trace;
import org.javagroups.stack.Protocol;
import org.javagroups.util.Scheduler;
import org.javagroups.util.SchedulerListener;
import org.javagroups.util.Util;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class RequestCorrelator {
    protected Object transport;
    protected HashMap requests;
    protected RequestHandler request_handler;
    protected String name;
    protected Scheduler scheduler;
    protected Address local_addr;
    protected Stack call_stack;
    protected boolean deadlock_detection;
    protected CallStackSetter call_stack_setter;

    public void finalize() {
        this.stop();
    }

    public void setDeadlockDetection(boolean flag) {
        this.deadlock_detection = flag;
    }

    public void setRequestHandler(RequestHandler handler) {
        this.request_handler = handler;
        this.start();
    }

    public void sendRequest(long id, Message msg, RspCollector coll) {
        this.sendRequest(id, null, msg, coll);
    }

    public void sendRequest(long id, List dest_mbrs, Message msg, RspCollector coll) {
        if (this.transport == null) {
            Trace.warn("RequestCorrelator.sendRequest()", "transport is not available !");
            return;
        }
        boolean bl = false;
        if (coll != null) {
            bl = true;
        }
        Header hdr = new Header(0, id, bl, this.name);
        hdr.dest_mbrs = dest_mbrs;
        if (coll != null) {
            if (this.deadlock_detection) {
                if (this.local_addr == null) {
                    Trace.error("RequestCorrelator.sendRequest()", "local address is null !");
                    return;
                }
                Stack new_call_stack = this.call_stack != null ? (Stack)this.call_stack.clone() : new Stack();
                new_call_stack.push(this.local_addr);
                hdr.call_stack = new_call_stack;
            }
            this.addEntry(hdr.id, new RequestEntry(coll));
        }
        msg.putHeader(this.name, hdr);
        try {
            if (this.transport instanceof Protocol) {
                ((Protocol)this.transport).passDown(new Event(1, msg));
            } else if (this.transport instanceof Transport) {
                ((Transport)this.transport).send(msg);
            } else {
                Trace.error("RequestCorrelator.sendRequest()", "transport object has to be either a Transport or a Protocol, however it is a " + this.transport.getClass());
            }
        }
        catch (Throwable e) {
            Trace.warn("RequestCorrelator.sendRequest()", e.toString());
        }
    }

    public void done(long id) {
        this.removeEntry(id);
    }

    public void receive(Event evt) {
        switch (evt.getType()) {
            case 9: {
                this.receiveSuspect((Address)evt.getArg());
                break;
            }
            case 6: {
                this.receiveView((View)evt.getArg());
                break;
            }
            case 8: {
                this.setLocalAddress((Address)evt.getArg());
                break;
            }
            case 1: {
                if (this.receiveMessage((Message)evt.getArg())) break;
                return;
            }
        }
        if (this.transport instanceof Protocol) {
            ((Protocol)this.transport).passUp(evt);
        } else {
            Trace.error("RequestCorrelator.receive()", "we do not pass up messages via Transport");
        }
    }

    public void start() {
        if (this.scheduler == null) {
            this.scheduler = new Scheduler();
            if (this.deadlock_detection && this.call_stack_setter != null) {
                this.scheduler.setListener(this.call_stack_setter);
            }
            this.scheduler.start();
        }
    }

    public void stop() {
        if (this.scheduler != null) {
            this.scheduler.stop();
            this.scheduler = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void receiveSuspect(Address mbr) {
        if (mbr == null) {
            return;
        }
        var4_2 = this.requests;
        synchronized (var4_2) {
            copy = new ArrayList<V>(this.requests.values());
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl7 : MonitorExitStatement: MONITOREXIT : var4_2
            it = copy.iterator();
            if (true) ** GOTO lbl16
        }
        do {
            entry = (RequestEntry)it.next();
            if (entry.coll == null) continue;
            entry.coll.suspect(mbr);
lbl16:
            // 3 sources

        } while (it.hasNext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void receiveView(View new_view) {
        var4_2 = this.requests;
        synchronized (var4_2) {
            copy = new ArrayList<V>(this.requests.values());
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl5 : MonitorExitStatement: MONITOREXIT : var4_2
            it = copy.iterator();
            if (true) ** GOTO lbl14
        }
        do {
            entry = (RequestEntry)it.next();
            if (entry.coll == null) continue;
            entry.coll.viewChange(new_view);
lbl14:
            // 3 sources

        } while (it.hasNext());
    }

    public boolean receiveMessage(Message msg) {
        org.javagroups.Header tmpHdr = msg.getHeader(this.name);
        if (tmpHdr == null || !(tmpHdr instanceof Header)) {
            return true;
        }
        Header hdr = (Header)msg.getHeader(this.name);
        if (hdr.name == null || !hdr.name.equals(this.name)) {
            Trace.debug("RequestCorrelator.receiveMessage()", "name of request correlator header (" + hdr.name + ") is different from ours (" + this.name + "). Msg not accepted, passed up");
            return true;
        }
        List dests = hdr.dest_mbrs;
        if (dests != null && this.local_addr != null && !dests.contains(this.local_addr)) {
            if (Trace.trace) {
                Trace.info("RequestCorrelator.receiveMessage()", "discarded request from " + msg.getSrc() + " as we are not part of destination list (local_addr=" + this.local_addr + ", hdr=" + hdr + ')');
            }
            return false;
        }
        switch (hdr.type) {
            case 0: {
                if (this.request_handler == null) {
                    Trace.warn("RequestCorrelator.receiveMessage()", "there is no request handler installed to deliver request !");
                    return false;
                }
                Request req = new Request(msg);
                if (this.deadlock_detection) {
                    Stack stack = hdr.call_stack;
                    if (hdr.rsp_expected && stack != null && this.local_addr != null && stack.contains(this.local_addr)) {
                        this.scheduler.addPrio(req);
                        break;
                    }
                }
                this.scheduler.add(req);
                break;
            }
            case 1: {
                msg.removeHeader(this.name);
                RspCollector coll = this.findEntry(hdr.id);
                if (coll == null) break;
                coll.receiveResponse(msg);
                break;
            }
            default: {
                msg.removeHeader(this.name);
                Trace.error("RequestCorrelator.receiveMessage()", "header's type is neither REQ nor RSP !");
                break;
            }
        }
        return false;
    }

    public void setLocalAddress(Address local_addr) {
        this.local_addr = local_addr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void addEntry(long id, RequestEntry entry) {
        Long id_obj = new Long(id);
        HashMap hashMap = this.requests;
        synchronized (hashMap) {
            block4: {
                block3: {
                    if (this.requests.containsKey(id_obj)) break block3;
                    this.requests.put(id_obj, entry);
                    break block4;
                }
                Trace.warn("RequestCorrelator.addEntry()", "entry " + entry + " for request-id=" + id + " already present !");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void removeEntry(long id) {
        Long id_obj = new Long(id);
        HashMap hashMap = this.requests;
        synchronized (hashMap) {
            this.requests.remove(id_obj);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final RspCollector findEntry(long id) {
        Long id_obj = new Long(id);
        HashMap hashMap = this.requests;
        synchronized (hashMap) {
            RequestEntry entry = (RequestEntry)this.requests.get(id_obj);
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl6 : MonitorExitStatement: MONITOREXIT : var5_3
            if (entry == null) return null;
            RspCollector rspCollector = entry.coll;
            return rspCollector;
        }
    }

    private final void handleRequest(Message req) {
        byte[] rsp_buf;
        Header hdr = (Header)req.removeHeader(this.name);
        Object retval = this.request_handler.handle(req);
        if (!hdr.rsp_expected) {
            return;
        }
        if (this.transport == null) {
            Trace.error("RequestCorrelator.handleRequest()", "failure sending response. No protocol available ! ");
            return;
        }
        try {
            rsp_buf = retval != null ? Util.objectToByteBuffer(retval) : null;
        }
        catch (Exception e) {
            Trace.error("RequestCorrelator.handleRequest()", "failed sending response: return value is not serializable. Sending null value");
            return;
        }
        Message rsp = req.makeReply();
        if (rsp_buf != null) {
            rsp.setBuffer(rsp_buf);
        }
        Header rsp_hdr = new Header(1, hdr.id, false, this.name);
        rsp.putHeader(this.name, rsp_hdr);
        try {
            if (this.transport instanceof Protocol) {
                ((Protocol)this.transport).passDown(new Event(1, rsp));
            } else if (this.transport instanceof Transport) {
                ((Transport)this.transport).send(rsp);
            } else {
                Trace.error("RequestCorrelator.handleRequest()", "transport object has to be either a Transport or a Protocol, however it is a " + this.transport.getClass());
            }
        }
        catch (Throwable e) {
            Trace.error("RequestCorrelator.handleRequest", this.throwableToString(e));
        }
    }

    private final String throwableToString(Throwable ex) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        return sw.toString();
    }

    private final /* synthetic */ void this() {
        this.transport = null;
        this.requests = new HashMap();
        this.request_handler = null;
        this.name = null;
        this.scheduler = null;
        this.local_addr = null;
        this.call_stack = null;
        this.deadlock_detection = true;
        this.call_stack_setter = new CallStackSetter();
    }

    public RequestCorrelator(String name, Object transport, RequestHandler handler) {
        this.this();
        this.name = name;
        this.transport = transport;
        this.request_handler = handler;
        this.start();
    }

    public RequestCorrelator(String name, Object transport, RequestHandler handler, Address local_addr) {
        this.this();
        this.name = name;
        this.transport = transport;
        this.local_addr = local_addr;
        this.request_handler = handler;
        this.start();
    }

    public RequestCorrelator(String name, Object transport, RequestHandler handler, boolean deadlock_detection) {
        this.this();
        this.deadlock_detection = deadlock_detection;
        this.name = name;
        this.transport = transport;
        this.request_handler = handler;
        this.start();
    }

    public RequestCorrelator(String name, Object transport, RequestHandler handler, boolean deadlock_detection, Address local_addr) {
        this.this();
        this.deadlock_detection = deadlock_detection;
        this.name = name;
        this.transport = transport;
        this.local_addr = local_addr;
        this.request_handler = handler;
        this.start();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class RequestEntry {
        public RspCollector coll;

        private final /* synthetic */ void this() {
            this.coll = null;
        }

        public RequestEntry(RspCollector coll) {
            this.this();
            this.coll = coll;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Header
    extends org.javagroups.Header {
        public static final int REQ = 0;
        public static final int RSP = 1;
        public int type;
        public long id;
        public boolean rsp_expected;
        public String name;
        public Stack call_stack;
        public List dest_mbrs;

        public String toString() {
            StringBuffer ret = new StringBuffer();
            ret.append("[Header: name=" + this.name + ", type=");
            ret.append(this.type == 0 ? "REQ" : (this.type == 1 ? "RSP" : "<unknown>"));
            ret.append(", id=" + this.id);
            ret.append(", rsp_expected=" + this.rsp_expected + ']');
            if (this.dest_mbrs != null) {
                ret.append(", dest_mbrs=").append(this.dest_mbrs);
            }
            return ret.toString();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.type);
            out.writeLong(this.id);
            out.writeBoolean(this.rsp_expected);
            if (this.name != null) {
                out.writeBoolean(true);
                out.writeUTF(this.name);
            } else {
                out.writeBoolean(false);
            }
            out.writeObject(this.call_stack);
            out.writeObject(this.dest_mbrs);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.type = in.readInt();
            this.id = in.readLong();
            this.rsp_expected = in.readBoolean();
            if (in.readBoolean()) {
                this.name = in.readUTF();
            }
            this.call_stack = (Stack)in.readObject();
            this.dest_mbrs = (List)in.readObject();
        }

        private final /* synthetic */ void this() {
            this.type = 0;
            this.id = 0L;
            this.rsp_expected = true;
            this.name = null;
            this.call_stack = null;
            this.dest_mbrs = null;
        }

        public Header() {
            this.this();
        }

        public Header(int type, long id, boolean rsp_expected, String name) {
            this.this();
            this.type = type;
            this.id = id;
            this.rsp_expected = rsp_expected;
            this.name = name;
        }
    }

    private class CallStackSetter
    implements SchedulerListener {
        public void started(Runnable r) {
            this.setCallStack(r);
        }

        public void stopped(Runnable r) {
            this.setCallStack(null);
        }

        public void suspended(Runnable r) {
            this.setCallStack(null);
        }

        public void resumed(Runnable r) {
            this.setCallStack(r);
        }

        void setCallStack(Runnable r) {
            if (r == null) {
                RequestCorrelator.this.call_stack = null;
                return;
            }
            Message req = ((Request)r).req;
            if (req == null) {
                return;
            }
            org.javagroups.Header obj = req.getHeader(RequestCorrelator.this.name);
            if (obj == null || !(obj instanceof Header)) {
                return;
            }
            Header hdr = (Header)obj;
            if (!hdr.rsp_expected) {
                return;
            }
            Stack new_stack = hdr.call_stack;
            if (new_stack != null) {
                RequestCorrelator.this.call_stack = (Stack)new_stack.clone();
            }
        }

        private CallStackSetter() {
        }
    }

    private class Request
    implements Runnable {
        public Message req;

        public void run() {
            RequestCorrelator.this.handleRequest(this.req);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            if (this.req != null) {
                sb.append("req=" + this.req + ", headers=" + this.req.printObjectHeaders());
            }
            return sb.toString();
        }

        public Request(Message req) {
            this.req = req;
        }
    }
}

