/***********************************/
/* oroborus (c) Ken Lynch Jan 2001 */
/* Distributed under the GPL       */
/* See LICENSE for more details    */
/***********************************/

#ifdef WORKSPACE_SUPPORT

#include "oroborus.h"

/*
 *
 * Change to a new GNOME workspace
 *
 */

void change_to_workspace(int new_ws)
{
  Client *c=NULL, *focus_client=NULL;
  int i;

#ifdef DEBUG
  printf("change_to_workspace\n");
#endif

  if(new_ws==workspace || new_ws>=config.workspace_count || new_ws<0) return;

#ifdef DEBUG
  printf("  changing from workspace %d to workspace %d\n", workspace+1, new_ws+1);
#endif

  set_gnome_hint(root, WIN_WORKSPACE, new_ws);
  focus_client=get_focus_client();
  c=client_list;
  for(i=0;i<client_count;i++)
  {
    /* Keep sticky windows on current workspace */
    if(get_gnome_hint(c->window, WIN_STATE)&WIN_STATE_STICKY)
      set_gnome_hint(c->window, WIN_WORKSPACE, new_ws);
 
    if(get_wm_state(c->window)!=IconicState)
    {
      /* Show clients that are on the current workspace */
      if(get_gnome_hint(c->window, WIN_WORKSPACE)==new_ws)
      {
        show_client(c);
        if(c->has_focus==True)
          set_focus_client(c);
        c->has_focus=False;
      }

      /* Hide clients that aren't on the current workspace */
      else
      {
        if(c==focus_client || c->has_focus==True)
          c->has_focus=True;
        c->ignore_unmap++;
        XUnmapWindow(dpy, c->frame);
        XUnmapWindow(dpy, c->window);
      }
    }
    c=c->next;
  }

  workspace=new_ws;
}

/*
 *
 * Update workspace count
 *
 */

void update_workspace_count()
{
  int i, new_ws_count;
  Client *c=NULL;

#ifdef DEBUG
  printf("update_workspace_count\n");
#endif

  new_ws_count=get_gnome_hint(root, WIN_WORKSPACE_COUNT);
  
  c=client_list;
  for(i=0;i<client_count;i++)
  {
    if(get_gnome_hint(c->window, WIN_WORKSPACE)>=new_ws_count)
    {
      set_gnome_hint(c->window, WIN_WORKSPACE, new_ws_count-1);
      if(workspace==new_ws_count-1)
        show_client(c);
      c->has_focus=False;
    }
    c=c->next;
  }
  if(workspace>=new_ws_count)
    change_to_workspace(new_ws_count-1);
  config.workspace_count=new_ws_count;
}
#endif /* WORKSPACE */
