/***********************************/ 
/* oroborus (c) Ken Lynch Jan 2001 */ 
/* Distributed under the GPL       */ 
/* See LICENSE for more details    */ 
/***********************************/ 

#include "oroborus.h"
#include "parse_rc.h"
 
#define RC_THEME			0 
#define RC_USE_THEMERC			1
#define RC_FONT				2 
#define RC_TEXT_ALIGNMENT		3 
#define RC_ACTIVE_TEXT_COLOR		4 
#define RC_INACTIVE_TEXT_COLOR		5 
#define RC_WINDOW_PLACEMENT		6 
#define RC_FOCUS_STYLE			7 
#define RC_RAISE_ON_FOCUS		8 
#define RC_FOCUS_NEW			9
#define RC_CONTINUOUS_RESIZE		10 
#define RC_ACTIVE_COLOR_1		11
#define RC_ACTIVE_SHADOW_1		12 
#define RC_ACTIVE_HILIGHT_1		13 
#define RC_INACTIVE_COLOR_1		14 
#define RC_INACTIVE_SHADOW_1		15 
#define RC_INACTIVE_HILIGHT_1		16 
#define RC_ACTIVE_COLOR_2		17 
#define RC_ACTIVE_SHADOW_2		18 
#define RC_ACTIVE_HILIGHT_2		19 
#define RC_INACTIVE_COLOR_2		20 
#define RC_INACTIVE_SHADOW_2		21 
#define RC_INACTIVE_HILIGHT_2		22 
#define RC_TOP_MARGIN			23 
#define RC_BOTTOM_MARGIN		24 
#define RC_LEFT_MARGIN			25 
#define RC_RIGHT_MARGIN			26 
#define RC_KEY_NEXT_WINDOW		27
#define RC_KEY_PREV_WINDOW		28 
#define RC_KEY_MAXIMIZE			29
#define RC_KEY_SHADE			30 
#define RC_KEY_HIDE			31 
#define RC_KEY_CLOSE			32 
#define RC_KEY_MOVE_UP			33 
#define RC_KEY_MOVE_DOWN		34 
#define RC_KEY_MOVE_LEFT		35 
#define RC_KEY_MOVE_RIGHT		36 
#define RC_KEY_RESIZE_UP		37 
#define RC_KEY_RESIZE_DOWN		38 
#define RC_KEY_RESIZE_LEFT		39 
#define RC_KEY_RESIZE_RIGHT		40 
#define RC_KEY_RAISE_LAYER		41 
#define RC_KEY_LOWER_LAYER		42 
#define RC_WORKSPACE_COUNT		43 
#define RC_KEY_STICKY			44 
#define RC_KEY_NEXT_WS			45 
#define RC_KEY_PREV_WS			46 
#define RC_KEY_ADD_WS			47 
#define RC_KEY_DEL_WS			48 
#define RC_KEY_WS_1			49 
#define RC_KEY_WS_2			50 
#define RC_KEY_WS_3			51 
#define RC_KEY_WS_4			52 
#define RC_KEY_WS_5			53 
#define RC_KEY_WS_6			54 
#define RC_KEY_WS_7			55 
#define RC_KEY_WS_8			56 
#define RC_KEY_WS_9			57 
#define RC_KEY_MOVE_NEXT_WS		58 
#define RC_KEY_MOVE_PREV_WS		59 
#define RC_KEY_MOVE_WS_1		60 
#define RC_KEY_MOVE_WS_2		61 
#define RC_KEY_MOVE_WS_3		62 
#define RC_KEY_MOVE_WS_4		63 
#define RC_KEY_MOVE_WS_5		64 
#define RC_KEY_MOVE_WS_6		65 
#define RC_KEY_MOVE_WS_7		66 
#define RC_KEY_MOVE_WS_8		67 
#define RC_KEY_MOVE_WS_9		68 
#define RC_LAST				69
 
/* 
 * 
 * Load font 
 * 
 */ 

void load_font(char *font_name, char *def_font_name) 
{ 
#ifdef DEBUG 
  printf("load_font\n"); 
#endif 
 
  /* Load font */ 
#ifdef I18N_SUPPORT
  if(use_fontset)
  {
    config.fontset=XLoadQueryFontWrapper(dpy, font_name); 
    if(!config.fontset)
    {
      fprintf(stderr, "%s: Can't find fontset %s, loading default fontset...\n", PROGNAME, font_name); 
      config.fontset=XLoadQueryFontWrapper(dpy, def_font_name);
    }
    if(!config.fontset)
    { 
      fprintf(stderr, "%s: Can't find default fontset (%s).\n", PROGNAME, font_name); 
      exit(1);
    }
  }
  else
  {
    config.font=XLoadQueryFont(dpy, font_name); 
    if(!config.font)
    {
      fprintf(stderr, "%s: Can't find font %s, loading default font...\n", PROGNAME, font_name);
      config.font=XLoadQueryFont(dpy, def_font_name);
    }  
    if(!config.font)
    {
      fprintf(stderr, "%s: Can't find default font (%s).\n", PROGNAME, font_name); 
      exit(1);
    }
  }
#else 
  config.font=XLoadQueryFont(dpy, font_name); 
  if(!config.font)
  {
    fprintf(stderr, "%s: Can't find font %s, loading default font...\n", PROGNAME, font_name);
    config.font=XLoadQueryFont(dpy, def_font_name);
  }  
  if(!config.font)
  {
    fprintf(stderr, "%s: Can't find default font (%s).\n", PROGNAME, font_name); 
    exit(1);
  }
#endif /* I18N */ 
} 
 
/* 
 * 
 * Load config file 
 * 
 */ 

void load_config() 
{ 
  XGCValues gv; 
  XColor active_col, inactive_col, dummyc; 
  XpmColorSymbol color_table[14]; 
  RcStruct rc_values[RC_LAST+1]; 
  char *def_font=NULL;
  int i;
 
#ifdef DEBUG 
  printf("load_config\n"); 
#endif 
 
  /* Initialize rc structure */ 
  rc_values[RC_THEME].option=strdup("theme"); 
  rc_values[RC_THEME].value=NULL; 
  rc_values[RC_USE_THEMERC].option=strdup("use_themerc");
  rc_values[RC_USE_THEMERC].value=NULL;
  rc_values[RC_FONT].option=strdup("font"); 
  rc_values[RC_FONT].value=NULL; 
  rc_values[RC_TEXT_ALIGNMENT].option=strdup("text_alignment"); 
  rc_values[RC_TEXT_ALIGNMENT].value=NULL;
  rc_values[RC_CONTINUOUS_RESIZE].option=strdup("continuous_resize");
  rc_values[RC_CONTINUOUS_RESIZE].value=NULL;
  rc_values[RC_ACTIVE_TEXT_COLOR].option=strdup("active_text_color"); 
  rc_values[RC_ACTIVE_TEXT_COLOR].value=NULL; 
  rc_values[RC_INACTIVE_TEXT_COLOR].option=strdup("inactive_text_color"); 
  rc_values[RC_INACTIVE_TEXT_COLOR].value=NULL; 
  rc_values[RC_WINDOW_PLACEMENT].option=strdup("window_placement"); 
  rc_values[RC_WINDOW_PLACEMENT].value=NULL; 
  rc_values[RC_FOCUS_STYLE].option=strdup("focus_style"); 
  rc_values[RC_FOCUS_STYLE].value=NULL; 
  rc_values[RC_RAISE_ON_FOCUS].option=strdup("raise_on_focus"); 
  rc_values[RC_RAISE_ON_FOCUS].value=NULL; 
  rc_values[RC_FOCUS_NEW].option=strdup("focus_new"); 
  rc_values[RC_FOCUS_NEW].value=NULL; 
  rc_values[RC_ACTIVE_COLOR_1].option=strdup("active_color_1"); 
  rc_values[RC_ACTIVE_COLOR_1].value=NULL; 
  rc_values[RC_ACTIVE_SHADOW_1].option=strdup("active_shadow_1"); 
  rc_values[RC_ACTIVE_SHADOW_1].value=NULL; 
  rc_values[RC_ACTIVE_HILIGHT_1].option=strdup("active_hilight_1"); 
  rc_values[RC_ACTIVE_HILIGHT_1].value=NULL; 
  rc_values[RC_INACTIVE_COLOR_1].option=strdup("inactive_color_1"); 
  rc_values[RC_INACTIVE_COLOR_1].value=NULL; 
  rc_values[RC_INACTIVE_SHADOW_1].option=strdup("inactive_shadow_1"); 
  rc_values[RC_INACTIVE_SHADOW_1].value=NULL; 
  rc_values[RC_INACTIVE_HILIGHT_1].option=strdup("inactive_hilight_1"); 
  rc_values[RC_INACTIVE_HILIGHT_1].value=NULL; 
  rc_values[RC_ACTIVE_COLOR_2].option=strdup("active_color_2");  
  rc_values[RC_ACTIVE_COLOR_2].value=NULL; 
  rc_values[RC_ACTIVE_SHADOW_2].option=strdup("active_shadow_2");  
  rc_values[RC_ACTIVE_SHADOW_2].value=NULL; 
  rc_values[RC_ACTIVE_HILIGHT_2].option=strdup("active_hilight_2"); 
  rc_values[RC_ACTIVE_HILIGHT_2].value=NULL; 
  rc_values[RC_INACTIVE_COLOR_2].option=strdup("inactive_color_2"); 
  rc_values[RC_INACTIVE_COLOR_2].value=NULL; 
  rc_values[RC_INACTIVE_SHADOW_2].option=strdup("inactive_shadow_2"); 
  rc_values[RC_INACTIVE_SHADOW_2].value=NULL; 
  rc_values[RC_INACTIVE_HILIGHT_2].option=strdup("inactive_hilight_2"); 
  rc_values[RC_INACTIVE_HILIGHT_2].value=NULL; 
  rc_values[RC_TOP_MARGIN].option=strdup("top_margin"); 
  rc_values[RC_TOP_MARGIN].value=NULL; 
  rc_values[RC_BOTTOM_MARGIN].option=strdup("bottom_margin"); 
  rc_values[RC_BOTTOM_MARGIN].value=NULL; 
  rc_values[RC_LEFT_MARGIN].option=strdup("left_margin"); 
  rc_values[RC_LEFT_MARGIN].value=NULL; 
  rc_values[RC_RIGHT_MARGIN].option=strdup("right_margin"); 
  rc_values[RC_RIGHT_MARGIN].value=NULL; 
  rc_values[RC_WORKSPACE_COUNT].option=strdup("workspace_count"); 
  rc_values[RC_WORKSPACE_COUNT].value=NULL; 
  rc_values[RC_KEY_NEXT_WINDOW].option=strdup("key_next_window"); 
  rc_values[RC_KEY_NEXT_WINDOW].value=NULL;
  rc_values[RC_KEY_PREV_WINDOW].option=strdup("key_prev_window");
  rc_values[RC_KEY_PREV_WINDOW].value=NULL; 
  rc_values[RC_KEY_MAXIMIZE].option=strdup("key_maximize"); 
  rc_values[RC_KEY_MAXIMIZE].value=NULL; 
  rc_values[RC_KEY_SHADE].option=strdup("key_shade"); 
  rc_values[RC_KEY_SHADE].value=NULL; 
  rc_values[RC_KEY_HIDE].option=strdup("key_hide"); 
  rc_values[RC_KEY_HIDE].value=NULL; 
  rc_values[RC_KEY_CLOSE].option=strdup("key_close"); 
  rc_values[RC_KEY_CLOSE].value=NULL; 
  rc_values[RC_KEY_MOVE_UP].option=strdup("key_move_up"); 
  rc_values[RC_KEY_MOVE_UP].value=NULL; 
  rc_values[RC_KEY_MOVE_DOWN].option=strdup("key_move_down"); 
  rc_values[RC_KEY_MOVE_DOWN].value=NULL; 
  rc_values[RC_KEY_MOVE_LEFT].option=strdup("key_move_left"); 
  rc_values[RC_KEY_MOVE_LEFT].value=NULL; 
  rc_values[RC_KEY_MOVE_RIGHT].option=strdup("key_move_right"); 
  rc_values[RC_KEY_MOVE_RIGHT].value=NULL; 
  rc_values[RC_KEY_RESIZE_UP].option=strdup("key_resize_up"); 
  rc_values[RC_KEY_RESIZE_UP].value=NULL; 
  rc_values[RC_KEY_RESIZE_DOWN].option=strdup("key_resize_down"); 
  rc_values[RC_KEY_RESIZE_DOWN].value=NULL; 
  rc_values[RC_KEY_RESIZE_LEFT].option=strdup("key_resize_left"); 
  rc_values[RC_KEY_RESIZE_LEFT].value=NULL; 
  rc_values[RC_KEY_RESIZE_RIGHT].option=strdup("key_resize_right"); 
  rc_values[RC_KEY_RESIZE_RIGHT].value=NULL; 
  rc_values[RC_KEY_RAISE_LAYER].option=strdup("key_raise_layer"); 
  rc_values[RC_KEY_RAISE_LAYER].value=NULL; 
  rc_values[RC_KEY_LOWER_LAYER].option=strdup("key_lower_layer"); 
  rc_values[RC_KEY_LOWER_LAYER].value=NULL; 
  rc_values[RC_KEY_STICKY].option=strdup("key_sticky"); 
  rc_values[RC_KEY_STICKY].value=NULL; 
  rc_values[RC_KEY_NEXT_WS].option=strdup("key_next_ws"); 
  rc_values[RC_KEY_NEXT_WS].value=NULL; 
  rc_values[RC_KEY_PREV_WS].option=strdup("key_prev_ws"); 
  rc_values[RC_KEY_PREV_WS].value=NULL; 
  rc_values[RC_KEY_ADD_WS].option=strdup("key_add_ws"); 
  rc_values[RC_KEY_ADD_WS].value=NULL; 
  rc_values[RC_KEY_DEL_WS].option=strdup("key_del_ws"); 
  rc_values[RC_KEY_DEL_WS].value=NULL; 
  rc_values[RC_KEY_WS_1].option=strdup("key_ws_1"); 
  rc_values[RC_KEY_WS_1].value=NULL; 
  rc_values[RC_KEY_WS_2].option=strdup("key_ws_2"); 
  rc_values[RC_KEY_WS_2].value=NULL; 
  rc_values[RC_KEY_WS_3].option=strdup("key_ws_3"); 
  rc_values[RC_KEY_WS_3].value=NULL; 
  rc_values[RC_KEY_WS_4].option=strdup("key_ws_4"); 
  rc_values[RC_KEY_WS_4].value=NULL; 
  rc_values[RC_KEY_WS_5].option=strdup("key_ws_5"); 
  rc_values[RC_KEY_WS_5].value=NULL; 
  rc_values[RC_KEY_WS_6].option=strdup("key_ws_6"); 
  rc_values[RC_KEY_WS_6].value=NULL; 
  rc_values[RC_KEY_WS_7].option=strdup("key_ws_7"); 
  rc_values[RC_KEY_WS_7].value=NULL; 
  rc_values[RC_KEY_WS_8].option=strdup("key_ws_8"); 
  rc_values[RC_KEY_WS_8].value=NULL; 
  rc_values[RC_KEY_WS_9].option=strdup("key_ws_9"); 
  rc_values[RC_KEY_WS_9].value=NULL; 
  rc_values[RC_KEY_MOVE_NEXT_WS].option=strdup("key_move_next_ws"); 
  rc_values[RC_KEY_MOVE_NEXT_WS].value=NULL; 
  rc_values[RC_KEY_MOVE_PREV_WS].option=strdup("key_move_prev_ws"); 
  rc_values[RC_KEY_MOVE_PREV_WS].value=NULL; 
  rc_values[RC_KEY_MOVE_WS_1].option=strdup("key_move_ws_1"); 
  rc_values[RC_KEY_MOVE_WS_1].value=NULL; 
  rc_values[RC_KEY_MOVE_WS_2].option=strdup("key_move_ws_2"); 
  rc_values[RC_KEY_MOVE_WS_2].value=NULL; 
  rc_values[RC_KEY_MOVE_WS_3].option=strdup("key_move_ws_3"); 
  rc_values[RC_KEY_MOVE_WS_3].value=NULL; 
  rc_values[RC_KEY_MOVE_WS_4].option=strdup("key_move_ws_4"); 
  rc_values[RC_KEY_MOVE_WS_4].value=NULL; 
  rc_values[RC_KEY_MOVE_WS_5].option=strdup("key_move_ws_5"); 
  rc_values[RC_KEY_MOVE_WS_5].value=NULL; 
  rc_values[RC_KEY_MOVE_WS_6].option=strdup("key_move_ws_6"); 
  rc_values[RC_KEY_MOVE_WS_6].value=NULL; 
  rc_values[RC_KEY_MOVE_WS_7].option=strdup("key_move_ws_7"); 
  rc_values[RC_KEY_MOVE_WS_7].value=NULL; 
  rc_values[RC_KEY_MOVE_WS_8].option=strdup("key_move_ws_8"); 
  rc_values[RC_KEY_MOVE_WS_8].value=NULL; 
  rc_values[RC_KEY_MOVE_WS_9].option=strdup("key_move_ws_9"); 
  rc_values[RC_KEY_MOVE_WS_9].value=NULL; 
  rc_values[RC_LAST].option=NULL; 
 
  /* Parse default rc file */ 
  if(!parse_rc(DATADIR, "oroborusrc", rc_values))
  {
    fprintf(stderr, "%s: File %s/oroborusrc does not exist.\n", PROGNAME, DATADIR);
    exit(1);
  }

  /* Check all values are loaded in */
  for(i=0;i<RC_LAST;i++)
  {
    if(rc_values[i].value==NULL)
    {
      fprintf(stderr, "%s: Option %s not set in file %s/oroborusrc.\n", PROGNAME, rc_values[i].option, DATADIR);
      exit(1);
    }
  }
 
  def_font=strdup(rc_values[RC_FONT].value);
 
  /* Parse local rc file */ 
  parse_rc(getenv("HOME"), rcfile, rc_values); 

  config.theme_dir=strdup(rc_values[RC_THEME].value);

  /* Parse theme rc file */
  if(strcmp(rc_values[RC_USE_THEMERC].value, "false"))
    parse_rc(config.theme_dir, "themerc", rc_values);

  /* Add theme dir to font path */
  add_dir_to_font_path(config.theme_dir);
 
  /* Set up color replacement table */ 
  color_table[0].name=rc_values[RC_ACTIVE_TEXT_COLOR].option; 
  color_table[0].value=rc_values[RC_ACTIVE_TEXT_COLOR].value; 
  color_table[1].name=rc_values[RC_INACTIVE_TEXT_COLOR].option; 
  color_table[1].value=rc_values[RC_INACTIVE_TEXT_COLOR].value; 
  color_table[2].name=rc_values[RC_ACTIVE_COLOR_1].option; 
  color_table[2].value=rc_values[RC_ACTIVE_COLOR_1].value; 
  color_table[3].name=rc_values[RC_ACTIVE_SHADOW_1].option; 
  color_table[3].value=rc_values[RC_ACTIVE_SHADOW_1].value; 
  color_table[4].name=rc_values[RC_ACTIVE_HILIGHT_1].option; 
  color_table[4].value=rc_values[RC_ACTIVE_HILIGHT_1].value; 
  color_table[5].name=rc_values[RC_INACTIVE_COLOR_1].option; 
  color_table[5].value=rc_values[RC_INACTIVE_COLOR_1].value; 
  color_table[6].name=rc_values[RC_INACTIVE_SHADOW_1].option; 
  color_table[6].value=rc_values[RC_INACTIVE_SHADOW_1].value; 
  color_table[7].name=rc_values[RC_INACTIVE_HILIGHT_1].option; 
  color_table[7].value=rc_values[RC_INACTIVE_HILIGHT_1].value; 
  color_table[8].name=rc_values[RC_ACTIVE_COLOR_2].option; 
  color_table[8].value=rc_values[RC_ACTIVE_COLOR_2].value; 
  color_table[9].name=rc_values[RC_ACTIVE_SHADOW_2].option; 
  color_table[9].value=rc_values[RC_ACTIVE_SHADOW_2].value; 
  color_table[10].name=rc_values[RC_ACTIVE_HILIGHT_2].option; 
  color_table[10].value=rc_values[RC_ACTIVE_HILIGHT_2].value; 
  color_table[11].name=rc_values[RC_INACTIVE_COLOR_2].option; 
  color_table[11].value=rc_values[RC_INACTIVE_COLOR_2].value; 
  color_table[12].name=rc_values[RC_INACTIVE_SHADOW_2].option; 
  color_table[12].value=rc_values[RC_INACTIVE_SHADOW_2].value; 
  color_table[13].name=rc_values[RC_INACTIVE_HILIGHT_2].option; 
  color_table[13].value=rc_values[RC_INACTIVE_HILIGHT_2].value; 

  /* Load pixmaps */
  load_pixmaps(rc_values[RC_THEME].value, color_table, 14); 
 
  /* Set window placement */ 
  if(!strcmp(rc_values[RC_WINDOW_PLACEMENT].value, "center_root")) 
    config.window_placement=CENTER_ROOT; 
  else 
    config.window_placement=CENTER_MOUSE; 
 
  /* Set focus style */ 
  if(!strcmp(rc_values[RC_FOCUS_STYLE].value, "sloppy")) 
    config.focus_style=FOCUS_SLOPPY; 
  else 
    config.focus_style=FOCUS_CLICK; 
 
  if(!strcmp(rc_values[RC_RAISE_ON_FOCUS].value, "false")) 
    config.raise_on_focus=False; 
  else 
    config.raise_on_focus=True; 
 
  if(!strcmp(rc_values[RC_FOCUS_NEW].value, "false")) 
    config.focus_new=False; 
  else 
    config.focus_new=True; 

  /* Set resize mode */
  if(!strcmp(rc_values[RC_CONTINUOUS_RESIZE].value, "false"))
    config.continuous_resize=False;
  else
    config.continuous_resize=True;
 
  /* Load font */ 
  load_font(rc_values[RC_FONT].value, def_font);
  if(def_font) free(def_font); 
 
  /* Set text alignment */ 
  if(!strcmp(rc_values[RC_TEXT_ALIGNMENT].value, "left")) 
    config.text_align=ALIGNMENT_LEFT; 
  else if(!strcmp(rc_values[RC_TEXT_ALIGNMENT].value, "right")) 
    config.text_align=ALIGNMENT_RIGHT; 
  else 
    config.text_align=ALIGNMENT_MIDDLE; 
 
  /* Set text colors */ 
  XAllocNamedColor(dpy, DefaultColormap(dpy, screen), rc_values[RC_ACTIVE_TEXT_COLOR].value, &active_col, &dummyc); 
  XAllocNamedColor(dpy, DefaultColormap(dpy, screen), rc_values[RC_INACTIVE_TEXT_COLOR].value, &inactive_col, &dummyc); 
 
  /* Set active font */ 
  gv.function=GXcopy; 
  gv.foreground=active_col.pixel; 
#ifdef I18N_SUPPORT
  if(use_fontset)
    config.font_gc[FRAME_ACTIVE]=XCreateGC(dpy, root, GCFunction|GCForeground, &gv); 
  else
  {
    gv.font=config.font->fid;
    config.font_gc[FRAME_ACTIVE]=XCreateGC(dpy, root, GCFunction|GCForeground|GCFont, &gv);
  }
#else 
  gv.font=config.font->fid; 
  config.font_gc[FRAME_ACTIVE]=XCreateGC(dpy, root, GCFunction|GCForeground|GCFont, &gv); 
#endif /* I18N */   
 
  /* Set inactive font */ 
  gv.foreground=inactive_col.pixel; 
#ifdef I18N_SUPPORT
  if(use_fontset)
    config.font_gc[FRAME_INACTIVE]=XCreateGC(dpy, root, GCFunction|GCForeground, &gv);
  else
    config.font_gc[FRAME_INACTIVE]=XCreateGC(dpy, root, GCFunction|GCForeground|GCFont, &gv);
#else 
  config.font_gc[FRAME_INACTIVE]=XCreateGC(dpy, root, GCFunction|GCForeground|GCFont, &gv);
#endif /* I18N */ 
 
  /* Set margins */ 
  config.top_margin=atoi(rc_values[RC_TOP_MARGIN].value); 
  config.bottom_margin=atoi(rc_values[RC_BOTTOM_MARGIN].value); 
  config.left_margin=atoi(rc_values[RC_LEFT_MARGIN].value); 
  config.right_margin=atoi(rc_values[RC_RIGHT_MARGIN].value); 

#ifdef WORKSPACE_SUPPORT 
  /* Set number of workspaces */ 
  config.workspace_count=atoi(rc_values[RC_WORKSPACE_COUNT].value); 
  if(config.workspace_count<=0) config.workspace_count=1; 
#endif 
 
#ifdef KEYBOARD_SUPPORT 
  /* Keyboard bindings */ 
  parse_key(rc_values[RC_KEY_NEXT_WINDOW].value, &config.keys.next_window);
  parse_key(rc_values[RC_KEY_PREV_WINDOW].value, &config.keys.prev_window); 
  parse_key(rc_values[RC_KEY_MAXIMIZE].value, &config.keys.maximize); 
  parse_key(rc_values[RC_KEY_SHADE].value, &config.keys.shade); 
  parse_key(rc_values[RC_KEY_HIDE].value, &config.keys.hide); 
  parse_key(rc_values[RC_KEY_CLOSE].value, &config.keys.close); 
  parse_key(rc_values[RC_KEY_MOVE_UP].value, &config.keys.move_up); 
  parse_key(rc_values[RC_KEY_MOVE_DOWN].value, &config.keys.move_down); 
  parse_key(rc_values[RC_KEY_MOVE_LEFT].value, &config.keys.move_left); 
  parse_key(rc_values[RC_KEY_MOVE_RIGHT].value, &config.keys.move_right); 
  parse_key(rc_values[RC_KEY_RESIZE_UP].value, &config.keys.resize_up); 
  parse_key(rc_values[RC_KEY_RESIZE_DOWN].value, &config.keys.resize_down); 
  parse_key(rc_values[RC_KEY_RESIZE_LEFT].value, &config.keys.resize_left); 
  parse_key(rc_values[RC_KEY_RESIZE_RIGHT].value, &config.keys.resize_right); 
#ifdef LAYER_SUPPORT 
  parse_key(rc_values[RC_KEY_RAISE_LAYER].value, &config.keys.raise_layer); 
  parse_key(rc_values[RC_KEY_LOWER_LAYER].value, &config.keys.lower_layer); 
#endif 
#ifdef WORKSPACE_SUPPORT 
  parse_key(rc_values[RC_KEY_STICKY].value, &config.keys.sticky); 
  parse_key(rc_values[RC_KEY_NEXT_WS].value, &config.keys.next_ws); 
  parse_key(rc_values[RC_KEY_PREV_WS].value, &config.keys.prev_ws); 
  parse_key(rc_values[RC_KEY_ADD_WS].value, &config.keys.add_ws); 
  parse_key(rc_values[RC_KEY_DEL_WS].value, &config.keys.del_ws); 
  parse_key(rc_values[RC_KEY_WS_1].value, &config.keys.ws_1); 
  parse_key(rc_values[RC_KEY_WS_2].value, &config.keys.ws_2); 
  parse_key(rc_values[RC_KEY_WS_3].value, &config.keys.ws_3); 
  parse_key(rc_values[RC_KEY_WS_4].value, &config.keys.ws_4); 
  parse_key(rc_values[RC_KEY_WS_5].value, &config.keys.ws_5); 
  parse_key(rc_values[RC_KEY_WS_6].value, &config.keys.ws_6); 
  parse_key(rc_values[RC_KEY_WS_7].value, &config.keys.ws_7); 
  parse_key(rc_values[RC_KEY_WS_8].value, &config.keys.ws_8); 
  parse_key(rc_values[RC_KEY_WS_9].value, &config.keys.ws_9); 
  parse_key(rc_values[RC_KEY_MOVE_NEXT_WS].value, &config.keys.move_next_ws); 
  parse_key(rc_values[RC_KEY_MOVE_PREV_WS].value, &config.keys.move_prev_ws); 
  parse_key(rc_values[RC_KEY_MOVE_WS_1].value, &config.keys.move_ws_1); 
  parse_key(rc_values[RC_KEY_MOVE_WS_2].value, &config.keys.move_ws_2); 
  parse_key(rc_values[RC_KEY_MOVE_WS_3].value, &config.keys.move_ws_3); 
  parse_key(rc_values[RC_KEY_MOVE_WS_4].value, &config.keys.move_ws_4); 
  parse_key(rc_values[RC_KEY_MOVE_WS_5].value, &config.keys.move_ws_5); 
  parse_key(rc_values[RC_KEY_MOVE_WS_6].value, &config.keys.move_ws_6); 
  parse_key(rc_values[RC_KEY_MOVE_WS_7].value, &config.keys.move_ws_7); 
  parse_key(rc_values[RC_KEY_MOVE_WS_8].value, &config.keys.move_ws_8); 
  parse_key(rc_values[RC_KEY_MOVE_WS_9].value, &config.keys.move_ws_9); 
#endif 
#endif 
 
  /* Free allocated memory */ 
  free_rc(rc_values); 
} 
 
/* 
 * 
 * Free memory used by config structure 
 * 
 */ 

void free_config() 
{ 
#ifdef DEBUG 
  printf("free_config\n"); 
#endif 

  rem_dir_from_font_path(config.theme_dir);
  free(config.theme_dir); 
  XFreeGC(dpy, config.font_gc[FRAME_ACTIVE]); 
  XFreeGC(dpy, config.font_gc[FRAME_INACTIVE]); 
#ifdef I18N_SUPPORT
  if(use_fontset) 
    XFreeFontSet(dpy, config.fontset); 
  else
    XFreeFont(dpy, config.font);
#else 
  XFreeFont(dpy, config.font); 
#endif /* I18N */ 
  XFreePixmap(dpy, config.title.pixmap[FRAME_ACTIVE]);
  XFreePixmap(dpy, config.title.pixmap[FRAME_INACTIVE]);
  XFreePixmap(dpy, config.title.pixmap[FRAME_ACTIVE_SHADED]); 
  XFreePixmap(dpy, config.title.pixmap[FRAME_INACTIVE_SHADED]); 
  XFreePixmap(dpy, config.top_right.pixmap[FRAME_ACTIVE]);
  XFreePixmap(dpy, config.top_right.pixmap[FRAME_INACTIVE]);
  XFreePixmap(dpy, config.top_right.pixmap[FRAME_ACTIVE_SHADED]); 
  XFreePixmap(dpy, config.top_right.pixmap[FRAME_INACTIVE_SHADED]); 
  XFreePixmap(dpy, config.top_right.mask[0]); 
  XFreePixmap(dpy, config.top_left.pixmap[FRAME_ACTIVE]);
  XFreePixmap(dpy, config.top_left.pixmap[FRAME_INACTIVE]);
  XFreePixmap(dpy, config.top_left.pixmap[FRAME_ACTIVE_SHADED]);
  XFreePixmap(dpy, config.top_left.pixmap[FRAME_INACTIVE_SHADED]);
  XFreePixmap(dpy, config.top_left.mask[0]); 
  XFreePixmap(dpy, config.left.pixmap[FRAME_ACTIVE]); 
  XFreePixmap(dpy, config.left.pixmap[FRAME_INACTIVE]); 
  XFreePixmap(dpy, config.right.pixmap[FRAME_ACTIVE]); 
  XFreePixmap(dpy, config.right.pixmap[FRAME_INACTIVE]); 
  XFreePixmap(dpy, config.bottom_left.pixmap[FRAME_ACTIVE]); 
  XFreePixmap(dpy, config.bottom_left.pixmap[FRAME_INACTIVE]); 
  XFreePixmap(dpy, config.bottom_left.mask[0]); 
  XFreePixmap(dpy, config.bottom.pixmap[FRAME_ACTIVE]); 
  XFreePixmap(dpy, config.bottom.pixmap[FRAME_INACTIVE]); 
  XFreePixmap(dpy, config.resize.pixmap[FRAME_ACTIVE]); 
  XFreePixmap(dpy, config.resize.pixmap[FRAME_INACTIVE]); 
  XFreePixmap(dpy, config.resize.mask[0]); 
  XFreePixmap(dpy, config.close.pixmap[FRAME_ACTIVE]); 
  XFreePixmap(dpy, config.close.pixmap[FRAME_INACTIVE]); 
  XFreePixmap(dpy, config.close.pixmap[BUTTON_PRESSED]); 
  XFreePixmap(dpy, config.close.mask[0]); 
  XFreePixmap(dpy, config.hide.pixmap[FRAME_ACTIVE]); 
  XFreePixmap(dpy, config.hide.pixmap[FRAME_INACTIVE]); 
  XFreePixmap(dpy, config.hide.pixmap[BUTTON_PRESSED]); 
  XFreePixmap(dpy, config.hide.mask[0]); 
} 
 
/* 
 * 
 * Reload config file 
 * 
 */ 

void reload_config() 
{ 
  Client *c=NULL; 
  XWindowChanges wc; 
  int i; 
#ifdef WORKSPACE_SUPPORT 
  int old_ws_count=config.workspace_count; 
#endif 
 
#ifdef DEBUG 
  printf("reload_config\n"); 
#endif 

  /* Remove gravity from all clients */
  c=client_list;
  for(i=0;i<client_count;i++)
  {
    gravitate_client(c, REMOVE_GRAVITY);
    c=c->next;
  }
 
  free_config(); 
  load_config(); 
#ifdef KEYBOARD_SUPPORT 
  ungrab_keys(check_win); 
  grab_keys(check_win); 
#endif 
#ifdef WORKSPACE_SUPPORT 
  if(config.workspace_count!=old_ws_count) 
    config.workspace_count=old_ws_count; 
#endif 
 
  c=client_list; 
  for(i=0;i<client_count;i++) 
  {
    gravitate_client(c, APPLY_GRAVITY);
    wc.height=c->height; 
    wc.width=c->width; 
    wc.x=c->x; 
    wc.y=c->y;
    configure_client(c, CWHeight|CWWidth|CWX|CWY, &wc, False);
    redraw_client_frame(c); 
#ifdef KEYBOARD_SUPPORT 
    ungrab_keys(c->window); 
    grab_keys(c->window); 
#endif 
    c=c->next; 
  } 
} 

