###############################################################################
# OpenVAS Vulnerability Test
# $Id: xoops_37597.nasl 7592 2010-05-07 14:44:11Z chandra $
#
# XOOPS 'include/notification_update.php' SQL Injection Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100422);
 script_bugtraq_id(37597);
 script_version ("1.0-$Revision: 7592 $");
 script_tag(name:"risk_factor", value:"Medium");

 script_name("XOOPS 'include/notification_update.php' SQL Injection Vulnerability");

desc = "Overview:
XOOPS is prone to an SQL-injection vulnerability because it fails
to sufficiently sanitize user-supplied data before using it in an
SQL query.

Exploiting this issue could allow an attacker to compromise the
application, access or modify data, or exploit latent vulnerabilities
in the underlying database.

Versions prior to XOOPS 2.4.3 are affected.

Solution:
Updates are available. Please see the references for details.

References:
http://www.securityfocus.com/bid/37597
http://www.xoops.org/modules/news/article.php?storyid=5178
http://www.xoops.org

Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if XOOPS version is < 2.4.3");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2010 Greenbone Networks GmbH");
 script_dependencies("secpod_xoops_detect.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");
include("version_func.inc");

port = get_http_port(default:80);
if(!get_port_state(port))exit(0);

if (!can_host_php(port:port)) exit(0);

if(!version = get_kb_item(string("www/", port, "/XOOPS")))exit(0);
if(!matches = eregmatch(string:version, pattern:"^(.+) under (/.*)$"))exit(0);

vers = matches[1];

if(!isnull(vers)) {

  if(version_is_less(version: vers, test_version: "2.4.3")) {
      security_warning(port:port);
      exit(0);
  }

}

exit(0);
