###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_tematres_detect.nasl 2203 2009-05-11 14:13:24Z may $
#
# TemaTres Version Detection
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800802);
  script_version("Revision: 1.0 ");
  script_tag(name:"risk_factor", value:"None");
  script_name("TemaTres Version Detection");
  desc = "

  Overview: This script detects the installed version of TemaTres and sets the
  result in KB.

  Risk factor: None";

  script_description(desc);
  script_summary("Set Version of TemaTres in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  script_dependencies("find_service.nes", "http_version.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");

tematresPort = get_http_port(default:80);
if(!tematresPort){
  tematresPort = 80;
}

if(!get_port_state(tematresPort)){
  exit(0);
}

foreach dir (make_list("/tematres", "/", cgi_dirs()))
{
  sndReq = http_get(item:dir + "/index.php", port:tematresPort);
  rcvRes = http_send_recv(port:tematresPort, data:sndReq);

  if(rcvRes == NULL)
  {
    sndReq = http_get(item:dir + "/login.php", port:tematresPort);
    rcvRes = http_send_recv(port:tematresPort, data:sndReq);
  }

  if("TemaTres" >< rcvRes)
  {
    tematresVer = eregmatch(pattern:"TemaTres ([0-9.]+)", string:rcvRes);
    if(tematresVer[1] != NULL)
    {
      set_kb_item(name:"www/" + tematresPort + "/TemaTres", value:tematresVer[1] +
                       " under " + dir);
      security_note(data:"TemaTres version " + tematresVer[1] + 
                    " running at location " + dir + " was detected on the host");
    }
  }
}
