###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for openafs MDVA-2008:006-1 (openafs)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830365);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "MDVA", value: "2008:006-1");
  script_name( "Mandriva Update for openafs MDVA-2008:006-1 (openafs)");
  desc = "

  Vulnerability Insight:

  The previous openafs update (MDKA-2007:124) was released to correct
  gcc compiler optimisations, however it only corrected the problem
  on 32bit platforms.  This update fixes it for both 32bit and 64bit
  architectures.
  
  Update:
  
  The previous update did not completely correct the problem in all
  cases.  It prevented listing directory contents when attaching to an
  AFS server, making files inaccessible.

  Affected Software/OS:
  openafs on Mandriva Linux 2008.0,
  Mandriva Linux 2008.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-09/msg00026.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of openafs");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2008.0")
{

  if(isrpmvuln(pkg:"dkms-libafs", rpm:"dkms-libafs~1.4.4~8.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libopenafs1", rpm:"libopenafs1~1.4.4~8.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libopenafs1-devel", rpm:"libopenafs1-devel~1.4.4~8.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"openafs", rpm:"openafs~1.4.4~8.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"openafs-client", rpm:"openafs-client~1.4.4~8.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"openafs-doc", rpm:"openafs-doc~1.4.4~8.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"openafs-server", rpm:"openafs-server~1.4.4~8.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64openafs1", rpm:"lib64openafs1~1.4.4~8.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64openafs1-devel", rpm:"lib64openafs1-devel~1.4.4~8.1mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}