//                                               -*- C++ -*-
/**
 *  @file  t_Contour_std.cxx
 *  @brief The test file of class Contour for standard methods
 *
 *  Copyright (C) 2005-2014 Airbus-EDF-Phimeca
 *
 *  This library is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  @author schueller
 *  @date   2012-02-17 19:35:43 +0100 (Fri, 17 Feb 2012)
 */
#include "OT.hxx"
#include "OTtestcode.hxx"

using namespace OT;
using namespace OT::Test;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);

  try
  {
    // Create a function
    Description inputVar(2);
    inputVar[0] = "x";
    inputVar[1] = "y";
    Description outputVar(1);
    outputVar[0] = "z";
    Description formula(1);
    formula[0] = "exp(-sin(cos(y)^2*x^2+sin(x)^2*y^2))";
    NumericalMathFunction f(inputVar, outputVar, formula);

    // Generate the data for the curver to be drawn
    NumericalPoint discretization(2);
    UnsignedLong nX(75);
    UnsignedLong nY(75);
    discretization[0] = nX;
    discretization[1] = nY;
    NumericalSample inputData(Box(discretization).generate());
    inputData.scale(NumericalPoint(2, 10.0));
    inputData.translate(NumericalPoint(2, -5.0));
    NumericalSample data(f(inputData));
    UnsignedLong size(7);
    NumericalPoint levels(size);
    for (UnsignedLong i = 0; i < size; i++)
    {
      levels[i] = (0.5 + i) / size;
    }

    // Create an empty graph
    Graph myGraph("Complex iso lines", "u1", "u2", true, "topright");

    // Create the first cloud
    Contour myContour(nX + 2, nY + 2, data);
    myContour.setLevels(levels);
    myContour.setColor("red");
    fullprint << "contour=" << myContour << std::endl;

    // Then, draw it
    myGraph.add(Drawable(myContour));
    myGraph.draw("Graph_Contour_OT");

    // Check that the correct files have been generated by computing their checksum
    fullprint << "bitmap=" << myGraph.getBitmap() << std::endl;
    fullprint << "postscript=" << myGraph.getPostscript() << std::endl;
  }
  catch (TestFailed & ex)
  {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }


  return ExitCode::Success;
}
