//                                               -*- C++ -*-
/**
 *  @file  t_RandomWalk_std.cxx
 *  @brief The test file of class RandomWalk
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: lebrun $
 *  @date:   $LastChangedDate: 2011-10-26 13:54:47 +0200 (mer. 26 oct. 2011) $
 *  Id:      $Id: t_RandomWalk_std.cxx 2164 2011-10-26 11:54:47Z lebrun $
 */
#include <iostream>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "OStream.hxx"
#include "TimeSeries.hxx"
#include "RandomWalk.hxx"
#include "Uniform.hxx"
#include "Process.hxx"
#include "Distribution.hxx"
#include "NumericalPoint.hxx"

using namespace OT;
using namespace OT::Test;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);

  try {

    const NumericalScalar Tmin(0.0);
    const NumericalScalar deltaT(0.1);
    const UnsignedLong N(11);

    /* Initialization of the RegularGrid timeGrid1*/
    RegularGrid timeGrid(Tmin, deltaT, N);

    /* Distribution choice */
    Distribution dist = Uniform();
    fullprint << "dist = " << dist << std::endl;
    NumericalPoint origin(dist.getDimension());

    Process process = RandomWalk(origin, dist);

    /* Setting the timeGrid */
    process.setTimeGrid(timeGrid);

    /* Print of the process */
    fullprint << "process = " << process << std::endl;

    /* Initialization of the TimeSeries */
    TimeSeries timeSerie = process.getRealization();

    /* Full prints */
    fullprint << "timeSerie = " << timeSerie << std::endl;

    // Some steps further
    UnsignedLong stepNumber = 4;
    fullprint << "One future=" << process.getFuture(stepNumber) << std::endl;
    UnsignedLong size = 3;
    fullprint << "Some futures=" << process.getFuture(stepNumber, size) << std::endl;

    /* Tests for load and save */
    Study myStudy;
    myStudy.setStorageManager(XMLStorageManager("testStudy.ot"));
    myStudy.add("randomWalk", process);
    myStudy.save();

    Study myStudy2;
    myStudy2.setStorageManager(XMLStorageManager("testStudy.ot"));
    myStudy2.load();
    RandomWalk loadprocess;
    myStudy2.fillObject("randomWalk", loadprocess);
    fullprint << "loaded random walk =" << loadprocess << std::endl;

  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }


  return ExitCode::Success;
}
