//                                               -*- C++ -*-
/**
 *  @file  DiscreteDistribution.hxx
 *  @brief Abstract top-level class for Discrete distributions
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: lebrun $
 *  @date:   $LastChangedDate: 2012-03-20 06:42:21 +0100 (Tue, 20 Mar 2012) $
 *  Id:      $Id: DiscreteDistribution.hxx 2428 2012-03-20 05:42:21Z lebrun $
 */
#ifndef OPENTURNS_DISCRETEDISTRIBUTION_HXX
#define OPENTURNS_DISCRETEDISTRIBUTION_HXX

#include "OTprivate.hxx"
#include "UsualDistribution.hxx"
#include "ResourceMap.hxx"

BEGIN_NAMESPACE_OPENTURNS




/**
 * @class DiscreteDistribution
 *
 * A subclass for Discrete usual distributions.
 */
class DiscreteDistribution
  : public UsualDistribution
{
  CLASSNAME;
public:


  /** Default constructor */
  explicit DiscreteDistribution(const String & name = DefaultName);


  /** Virtual constructor */
  virtual DiscreteDistribution * clone() const;

  /** Comparison operator */
  Bool operator ==(const DiscreteDistribution & other) const;

  /** String converter */
  String __repr__() const;

  /* Methods inherited from upper classes */

  /** Tell if the distribution is continuous */
  Bool isContinuous() const;

  /** Tell if the distribution is integer valued */
  Bool isIntegral() const;

  /** Draw the PDF of the distribution */
  using DistributionImplementation::drawPDF;
  virtual Graph drawPDF(const NumericalScalar xMin,
                        const NumericalScalar xMax,
                        const UnsignedLong pointNumber = ResourceMap::GetAsUnsignedLong("DistributionImplementation-DefaultPointNumber")) const;

  /** Draw the CDF of the distribution */
  using DistributionImplementation::drawCDF;
  virtual Graph drawCDF(const NumericalScalar xMin,
                        const NumericalScalar xMax,
                        const UnsignedLong pointNumber = ResourceMap::GetAsUnsignedLong("DistributionImplementation-DefaultPointNumber")) const;

protected:


private:

}; /* class DiscreteDistribution */


END_NAMESPACE_OPENTURNS

#endif /* OPENTURNS_DISCRETEDISTRIBUTION_HXX */
