//                                               -*- C++ -*-
/**
 *  @file  SamplingStrategyImplementation.cxx
 *  @brief
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2012-02-17 19:35:43 +0100 (Fri, 17 Feb 2012) $
 *  Id:      $Id: SamplingStrategyImplementation.cxx 2392 2012-02-17 18:35:43Z schueller $
 */
#include "SamplingStrategyImplementation.hxx"
#include "Exception.hxx"
#include "DistFunc.hxx"

BEGIN_NAMESPACE_OPENTURNS




/**
 * @class SamplingStrategyImplementation
 */

CLASSNAMEINIT(SamplingStrategyImplementation);

/* Constructor with parameters */
SamplingStrategyImplementation::SamplingStrategyImplementation(const UnsignedLong dimension)
  : PersistentObject(),
    dimension_(dimension)
{
  // Nothing to do
}

/* Virtual constructor */
SamplingStrategyImplementation * SamplingStrategyImplementation::clone() const
{
  return new SamplingStrategyImplementation(*this);
}

/* Generate a set of directions */
NumericalSample SamplingStrategyImplementation::generate() const
{
  throw NotYetImplementedException(HERE);
}

/* Generate a uniform random unit vector */
NumericalPoint SamplingStrategyImplementation::getUniformUnitVectorRealization(const UnsignedLong dimension) const
{
  NumericalPoint direction(dimension);
  NumericalScalar norm(0.0);
  do
    {
      for (UnsignedLong i = 0; i < dimension; ++i) direction[i] = DistFunc::rNormal();
      norm = direction.norm();
    }
  while (norm == 0.0);
  return (1.0 / norm) * direction;
}

/* Generate a uniform random unit vector */
NumericalPoint SamplingStrategyImplementation::getUniformUnitVectorRealization() const
{
  return getUniformUnitVectorRealization(dimension_);
}

/* Dimension accessor */
void SamplingStrategyImplementation::setDimension(const UnsignedLong dimension)
{
  dimension_ = dimension;
}

UnsignedLong SamplingStrategyImplementation::getDimension() const
{
  return dimension_;
}

/* String converter */
String SamplingStrategyImplementation::__repr__() const
{
  OSS oss;
  oss << "class=" << SamplingStrategyImplementation::GetClassName()
      << " dimension=" << dimension_;
  return oss;
}

END_NAMESPACE_OPENTURNS
