//                                               -*- C++ -*-
/**
 *  @file  CobylaSpecificParameters.cxx
 *  @brief CobylaSpecificParameters is an encapsulation of the Cobyla specific
 *         parameters.
 *
 *  (C) Copyright 2005-2012 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2012-02-17 19:35:43 +0100 (Fri, 17 Feb 2012) $
 *  Id:      $Id: CobylaSpecificParameters.cxx 2392 2012-02-17 18:35:43Z schueller $
 */
#include <cstdlib>

#include "Cobyla.hxx"

BEGIN_NAMESPACE_OPENTURNS



CLASSNAMEINIT(CobylaSpecificParameters);


/* Default with parameters */
CobylaSpecificParameters::CobylaSpecificParameters():
  PersistentObject(),
  rhoBeg_(ResourceMap::GetAsNumericalScalar( "Cobyla-DefaultRhoBeg" ))
{
  // Nothing to do
} /* SpecificParametersCobyla */

  /* Parameters with parameters */
CobylaSpecificParameters::CobylaSpecificParameters(const NumericalScalar rhoBeg):
  PersistentObject()
{
  // Nothing to do
} /* SpecificParametersCobyla */

  /* Virtual constructor */
CobylaSpecificParameters * CobylaSpecificParameters::clone() const
{
  return new CobylaSpecificParameters(*this);
}

/* RhoBeg accessor */
NumericalScalar CobylaSpecificParameters::getRhoBeg() const
{
  return rhoBeg_;
}

/* RhoBeg accessor */
void CobylaSpecificParameters::setRhoBeg(const NumericalScalar rhoBeg)
{
  rhoBeg_ = rhoBeg;
}

/* String converter */
String CobylaSpecificParameters::__repr__() const
{
  OSS oss;
  oss << "class=" << CobylaSpecificParameters::GetClassName()
      << " rhoBeg=" << rhoBeg_;
  return oss;
}

END_NAMESPACE_OPENTURNS



