/* -*-c++-*- Producer - Copyright (C) 2001-2004  Don Burns
 *
 * This library is open source and may be redistributed and/or modified under
 * the terms of the OpenSceneGraph Public License (OSGPL) version 0.0 or
 * (at your option) any later version.  The full license is in LICENSE file
 * included with this distribution, and on the openscenegraph.org website.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * OpenSceneGraph Public License for more details.
 */


#if defined(WIN32) && !defined(__CYGWIN__)
    #include <Io.h>
    #include <Windows.h>
    #include <Winbase.h>
    // set up for windows so acts just like unix access().
    #define F_OK 4
#else // unix
    #include <unistd.h>
#endif


#ifdef _X11_IMPLEMENTATION
#  include <X11/Xlib.h>
#endif

#include <math.h>

#include <Producer/Math>
#include <Producer/CameraConfig>

using namespace Producer;

unsigned int CameraConfig::getNumberOfScreens()
{
#ifdef _X11_IMPLEMENTATION
    Display *dpy = XOpenDisplay("");
    if( dpy == NULL )
    {
        std::cerr << "Unable to open display \"" << XDisplayName( ":0.0") << "\".  Is the DISPLAY environmental variable set?\n";
        return 0;
    }
    unsigned int nscreens = ScreenCount(dpy); 
    XCloseDisplay(dpy);
    return nscreens;
#else
    return 1;
#endif
}



void CameraConfig::rotateCameraOffset( Matrix::value_type deg, Matrix::value_type x, Matrix::value_type y, Matrix::value_type z )
{
    Matrix m;
    m.invert(Matrix::rotate( deg2rad(deg), x,y,z)); 
    m = m * Matrix(_offset_matrix);
    memcpy( _offset_matrix, m.ptr(), sizeof( Matrix::value_type[16] ));
}

void CameraConfig::translateCameraOffset( Matrix::value_type x, Matrix::value_type y, Matrix::value_type z )
{
    Matrix m;
    m.invert(Matrix::translate( x,y,z)); 
    m = m * Matrix(_offset_matrix);
    memcpy( _offset_matrix, m.ptr(), sizeof( Matrix::value_type[16] ));
}

void CameraConfig::scaleCameraOffset( Matrix::value_type x, Matrix::value_type y, Matrix::value_type z )
{
    Matrix m = Matrix::scale( x,y,z) * Matrix(_offset_matrix);
    memcpy( _offset_matrix, m.ptr(), sizeof( Matrix::value_type[16] ));
}

bool CameraConfig::fileExists(const std::string& filename)
{
    return access( filename.c_str(), F_OK ) == 0;
}

// Order of precedence:
//
std::string CameraConfig::findFile( std::string filename )
{
    if (filename.empty()) return filename;

    std::string path;
    // Check env var
    char *ptr = getenv( "PRODUCER_CONFIG_FILE_PATH");
    if( ptr != NULL )
    {
         path = std::string(ptr) + '/' + filename;
        if( fileExists(path)) 
            return path;
    }

    // Check standard location(s)
    //path.clear();
    path = std::string( "/usr/local/share/Producer/Config/") + filename;
    if( fileExists(path) ) 
        return path;

    //path.clear();
    path = std::string( "/usr/share/Producer/Config/") + filename;
    if( fileExists(path) ) 
        return path;

    // Check local directory
    if(fileExists(filename)) 
        return filename;

    // Fail
    return std::string();
}

