/*
 *  Copyright 2001-2005 Internet2
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <cxxtest/TestSuite.h>

#include <saml/saml.h>
#include <sstream>

using namespace saml;
using namespace std;

class SAMLActionTest : public CxxTest::TestSuite {
public:
    XMLCh *value,*value2;

    void setUp() {
        value = XMLString::transcode("Read");
        value2 = XMLString::transcode("Write");
    }

    void tearDown() {
        XMLString::release(&value);
        XMLString::release(&value2);
    }
    
    void testSAMLAction(void) {
        TS_TRACE("testing SAMLAction class");

        auto_ptr<SAMLAction> a(new SAMLAction(value,SAMLAction::SAML_ACTION_NAMESPACE_RWEDC_NEG));

        TS_ASSERT(a.get());

        auto_ptr<SAMLAction> a2((SAMLAction*)a->clone());
        stringstream str1,str2;
        str1 << *a.get();
        str2 << *a2.get();
        
        TS_ASSERT_EQUALS(str1.str(),str2.str());

        auto_ptr<SAMLAction> a3(new SAMLAction(str1));
        a->setData(value2);
        a3->setData(value2);
        stringstream str3,str4;
        str3 << *a.get();
        str4 << *a3.get();

        TS_ASSERT_EQUALS(str3.str(),str4.str());
        TS_ASSERT(!XMLString::compareString(a3->getData(),value2));
    }
};
