# Copyright (C) 2000-2001 The OpenRPG Project
#
#        openrpg-dev@lists.sourceforge.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
# --
#
# File: map_miniature_nodehandler.py
# Author: Andrew Bennett
# Maintainer:
# Version:
#   $Id: map_miniature_nodehandler.py,v 1.7 2005/06/05 20:12:36 digitalxero Exp $
#
# Description: nodehandler for miniature images
#

#from nodehandlers.core import *
from core import *
from orpg.gametree import *
from orpg.mapper.miniatures_msg import mini_msg
from orpg.mapper.images import imageCache
import urllib

from orpg.gametree.gametree import STD_MENU_DELETE
# from orpg.gametree.gametree import STD_MENU_EDIT
from orpg.gametree.gametree import STD_MENU_RENAME
from orpg.gametree.gametree import STD_MENU_SEND
from orpg.gametree.gametree import STD_MENU_SAVE
from orpg.gametree.gametree import STD_MENU_ICON
from orpg.gametree.gametree import STD_MENU_CLONE
from orpg.gametree.gametree import STD_MENU_ABOUT
from orpg.gametree.gametree import STD_MENU_HTML
from orpg.gametree.gametree import STD_MENU_EMAIL
from orpg.gametree.gametree import STD_MENU_WHISPER
from orpg.gametree.gametree import STD_MENU_WIZARD
from orpg.gametree.gametree import wxNewId


#STD_MENU_MAP = wxNewId()


class map_miniature_handler(node_handler):

    """ A node handler for miniatures
        <nodehandler name='Elf-1' module='map_miniature_nodehandler' class='map_miniature_handler' >
                <miniature id='' label='Elf-1' posx='' posy='' path='' ...  />
        </nodehandler >
    """


    def __init__(self,xml_dom,tree_node,openrpg):
        node_handler.__init__(self,xml_dom,tree_node,openrpg)

        self.mapper = openrpg.get_component("map")
        self.session = openrpg.get_component("session")
        self.myopenrpg=openrpg


        self.miniature_dom = self.master_dom.getElementsByTagName("miniature")
        if self.miniature_dom:
            self.miniature_dom = self.miniature_dom[0]   # convert to scalar




    def get_scaled_bitmap(self,x,y):

        global imageCache

        my_mini_msg = mini_msg()
        my_mini_msg.init_from_dom(self.miniature_dom)

        path = my_mini_msg.get_prop("path")

        if path:
            if imageCache.has_key(path):
                bmp = imageCache[ path ]
            else:
                pos = string.rfind(path,'.')
                ext = string.lower(path[pos+1:])
                img_type = 0
                if ext == "gif":
                    img_type = wxBITMAP_TYPE_GIF
                elif (ext == "jpg") | (ext == "jpeg"):
                    img_type = wxBITMAP_TYPE_JPEG
                elif ext == "bmp":
                    img_type = wxBITMAP_TYPE_BMP
                elif ext == "png":
                    img_type = wxBITMAP_TYPE_PNG
                else:
                    bmp = None
                    raise Exception, "not a valid image type!"
                data = urllib.urlretrieve(path)
                bmp = wxBitmap(data[0],img_type)

            if bmp:
                img = wxImageFromBitmap(bmp)
                scaled_img = img.Scale(x,y)
                scaled_bmp = scaled_img.ConvertToBitmap()
                scratch = scaled_img.ConvertToBitmap()

                memDC = wxMemoryDC()
                memDC.BeginDrawing()
                memDC.SelectObject(scaled_bmp)

                memDC.SetBrush(wxWHITE_BRUSH)
                memDC.SetPen(wxWHITE_PEN)

                memDC.DrawRectangle(0,0,x,y)
                memDC.SetPen(wxNullPen)
                memDC.SetBrush(wxNullBrush)
                memDC.DrawBitmap(scratch,0,0,1)
                memDC.SelectObject(wxNullBitmap)
                memDC.EndDrawing()
                del memDC
                return scaled_bmp


    def map_aware(self):
        return 1

    def get_miniature_XML(self):
        my_mini_msg = mini_msg()
        my_mini_msg.init_from_dom(self.miniature_dom)
        my_mini_msg.init_prop("id",self.session.get_next_id())
        label = self.master_dom.getAttribute("name")
        my_mini_msg.init_prop("label",label)

        new_xml = my_mini_msg.get_all_xml()
        return new_xml

    def get_to_map_XML(self):
        new_xml = self.get_miniature_XML()
        new_xml = str("<map action='update'><miniatures>" + new_xml + "</miniatures></map>")
        return new_xml


    def on_send_to_map(self,evt):

        new_xml = self.get_to_map_XML()
        if (self.session.my_role() <> self.session.ROLE_GM) and (self.session.my_role() <> self.session.ROLE_PLAYER):
            self.myopenrpg.get_component("chat").InfoPost("You must be either a player or GM to use the miniature Layer")
            return

        if new_xml:
            self.mapper.new_data(new_xml)
            self.session.send(new_xml)
        else:
            print "problem converting old mini xml to new mini xml"

    def about(self):
        return "Miniature node by Andrew Bennett"

    def tohtml(self):

        html_str = "<table><tr><td>"
        html_str += "<center><img src='" + self.miniature_dom.getAttribute("path") + "'>"
        html_str += "</center></td></tr>\n"
        html_str += "<tr><td><center>" + self.master_dom.getAttribute("name") + "</center></td></tr></table>"

        return html_str
