/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: msfiltertracer.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 13:53:09 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _MS_FILTERTRACER_HXX
#define _MS_FILTERTRACER_HXX

// auto strip #ifndef _RTL_USTRING_HXX_
// auto strip #include <rtl/ustring.hxx>
// auto strip #endif
#ifndef _COM_SUN_STAR_UNO_ANY_H_
#include <com/sun/star/uno/Any.h>
#endif
#ifndef _COM_SUN_STAR_UNO_REFERENCE_H_
#include <com/sun/star/uno/Reference.h>
#endif
// auto strip #ifndef _COM_SUN_STAR_UTIL_XTEXTSEARCH_HPP_
// auto strip #include <com/sun/star/util/XTextSearch.hpp>
// auto strip #endif
#ifndef _COM_SUN_STAR_UTIL_LOGGING_XLOGGER_HPP_
#include <com/sun/star/util/logging/XLogger.hpp>
#endif
namespace binfilter {

class FilterConfigItem;
class MSFilterTracer
{
		sal_Bool			mbEnabled;
		FilterConfigItem*	mpCfgItem;

		::com::sun::star::uno::Reference< ::com::sun::star::uno::XInterface >			mxFilterTracer;
		::com::sun::star::uno::Reference< ::com::sun::star::util::logging::XLogger >	mxLogger;

	public :

		MSFilterTracer();
		~MSFilterTracer();

		void StartTracing( const ::rtl::OUString& rConfigurationPath );
		void EndTracing();

		void Trace( const ::rtl::OUString& rMessage ) const;

		// retrieve properties from given configuration path
		::com::sun::star::uno::Any GetProperty( const ::rtl::OUString& rPropName ) const;

		MSFilterTracer& operator=( const MSFilterTracer& rFilterTracer );
};

}//end of namespace binfilter
#endif
